/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadFileFilter;
import uk.ac.reload.dweezil.gui.ReloadToolBar;
import uk.ac.reload.dweezil.util.DweezilXMLException;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.dweezil.util.XMLUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.ReloadEditorSchemaController;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.MetadataEditor;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaController;

public class MetadataEditorDialog
extends JDialog {
    protected MetadataEditor _mdEditor;
    protected ContentPackage _contentPackage;
    protected Element _mdElement;
    protected Element _oldLom;

    public MetadataEditorDialog(Element mdElement, ContentPackage contentPackage, boolean isADLRMetadata) throws ReloadEditorException {
        super(ReloadEditor.getInstance(), "Metadata - " + contentPackage.getProjectName(), true);
        this._contentPackage = contentPackage;
        this._mdElement = mdElement;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MetadataEditorDialog.this.dispose();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        Menu_Edit editMenu = new Menu_Edit();
        menuBar.add(editMenu);
        ReloadToolBar toolBar = this.createToolBar(editMenu);
        this.getContentPane().add((Component)toolBar, "North");
        this._mdEditor = new MetadataEditor(editMenu, isADLRMetadata);
        this.getContentPane().add((Component)this._mdEditor, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton btnOK = new JButton("OK");
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetadataEditorDialog.this.finish();
            }
        });
        this.getRootPane().setDefaultButton(btnOK);
        buttonPanel.add(btnOK);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new CancelClick());
        buttonPanel.add(btnCancel);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new FlowLayout(0));
        JButton btnImport = new JButton("Import...");
        btnImport.setToolTipText("Import a standalone Metadata file");
        btnImport.addActionListener(new ImportMetadata());
        leftPanel.add(btnImport);
        JButton btnExport = new JButton("Export...");
        btnExport.setToolTipText("Export as a standalone Metadata file");
        btnExport.addActionListener(new ExportMetadata());
        leftPanel.add(btnExport);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)leftPanel, "West");
        bottomPanel.add((Component)buttonPanel, "East");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setSize(ReloadEditor.getInstance().getWidth() * 3 / 4, ReloadEditor.getInstance().getHeight() * 3 / 4);
        this.setLocationRelativeTo(ReloadEditor.getInstance());
        this.createDocument(this._mdElement, this._contentPackage);
    }

    public MetadataEditorDialog(Element mdElement, ContentPackage contentPackage) throws ReloadEditorException {
        this(mdElement, contentPackage, 0);
    }

    public MetadataEditorDialog(Element mdElement, ContentPackage contentPackage, int shouldUseHC) throws ReloadEditorException {
        super(ReloadEditor.getInstance(), "Metadata - " + contentPackage.getProjectName(), true);
        this._contentPackage = contentPackage;
        this._mdElement = mdElement;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MetadataEditorDialog.this.dispose();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        Menu_Edit editMenu = new Menu_Edit();
        menuBar.add(editMenu);
        ReloadToolBar toolBar = this.createToolBar(editMenu);
        this.getContentPane().add((Component)toolBar, "North");
        this._mdEditor = new MetadataEditor(editMenu);
        this.getContentPane().add((Component)this._mdEditor, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton btnOK = new JButton("OK");
        btnOK.addActionListener(new OKClick());
        this.getRootPane().setDefaultButton(btnOK);
        buttonPanel.add(btnOK);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new CancelClick());
        buttonPanel.add(btnCancel);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new FlowLayout(0));
        JButton btnImport = new JButton("Import...");
        btnImport.setToolTipText("Import a standalone Metadata file");
        btnImport.addActionListener(new ImportMetadata());
        leftPanel.add(btnImport);
        JButton btnExport = new JButton("Export...");
        btnExport.setToolTipText("Export as a standalone Metadata file");
        btnExport.addActionListener(new ExportMetadata());
        leftPanel.add(btnExport);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)leftPanel, "West");
        bottomPanel.add((Component)buttonPanel, "East");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setSize(ReloadEditor.getInstance().getWidth() * 3 / 4, ReloadEditor.getInstance().getHeight() * 3 / 4);
        this.setLocationRelativeTo(ReloadEditor.getInstance());
        this.createDocument(this._mdElement, this._contentPackage, shouldUseHC != 0);
    }

    protected void createDocument(Element mdElement, ContentPackage cp) throws ReloadEditorException {
        this.createDocument(mdElement, cp, false);
    }

    protected void createDocument(Element mdElement, ContentPackage cp, boolean isHealthCare) throws ReloadEditorException {
        ReloadSchemaController controller;
        Namespace mdNamespace = cp.getMetadataNamespace();
        if (mdNamespace != null) {
            this._oldLom = mdElement.getChild("lom", mdNamespace);
        }
        if (this._oldLom == null) {
            for (Element element : mdElement.getChildren()) {
                if (!element.getName().equals("lom")) continue;
                this._oldLom = element;
                break;
            }
        }
        if (this._oldLom != null) {
            controller = isHealthCare ? ReloadEditorSchemaController.getReloadSchemaController("lom_hc_10") : ReloadEditorSchemaController.getReloadSchemaController(cp.getDocument(), this._oldLom.getNamespace());
            MetadataSchemaController mdSchemaController = controller != null && controller instanceof MetadataSchemaController ? (MetadataSchemaController)controller : MetadataSchemaController.getDefaultSchemaController1_3();
            this._mdEditor.setMetadataElement((Element)this._oldLom.clone(), mdSchemaController);
        } else {
            controller = isHealthCare ? ReloadEditorSchemaController.getReloadSchemaController("lom_hc_10") : ReloadEditorSchemaController.getReloadSchemaController(cp.getDocument(), this._mdElement.getNamespace());
            MetadataSchemaController mdSchemaController = controller != null && controller instanceof MetadataSchemaController ? (MetadataSchemaController)controller : MetadataSchemaController.getDefaultSchemaController1_3();
            this._mdEditor.newDocument(false, mdSchemaController);
        }
        this._mdEditor.getUndoManager().setFocusGained();
    }

    protected void importMetadata() throws ReloadEditorException {
        ReloadFileFilter filter = new ReloadFileFilter(new String[]{"xml"}, "xml files");
        File file = ReloadUtils.askFileNameOpen(this, "Import Metadata File", filter);
        if (file != null) {
            Document doc = null;
            try {
                doc = XMLUtils.readXMLFile(file);
            }
            catch (DweezilXMLException ex) {
                throw new ReloadEditorException(ex);
            }
            String schemaVersion = IMSDocumentHandler.getSchemaVersion(doc);
            if (schemaVersion == null || !schemaVersion.startsWith("imsmd") || !schemaVersion.startsWith("lom")) {
                throw new ReloadEditorException("Invalid Metadata file");
            }
            MetadataSchemaController schemaController = (MetadataSchemaController)this._mdEditor.getMetadata().getReloadSchemaController();
            this._mdEditor.importMetadata(doc, schemaController);
            this._mdEditor.getUndoManager().setFocusGained();
        }
    }

    protected void exportMetadata() {
        try {
            ReloadFileFilter filter = new ReloadFileFilter(new String[]{"xml"}, "xml files");
            File file = ReloadUtils.askFileNameSave(this, "Save Metadata", filter, "xml");
            if (file != null) {
                this._mdEditor.SaveClassifications();
                this._mdEditor.exportMetadata(file);
            }
        }
        catch (ReloadEditorException ex) {
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            ErrorDialogBox.showWarning("Error in Metadata", "Could not export Metadata File", ex);
        }
    }

    @Override
    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MetadataEditorDialog.this._mdEditor.initView();
            }
        });
        super.show();
    }

    protected void finish() {
        Metadata md = this._mdEditor.getMetadata();
        if (md.isDirty()) {
            if (this._oldLom != null) {
                this._mdElement.removeContent(this._oldLom);
            }
            Element newLom = md.getRootElement();
            newLom.detach();
            this._mdElement.addContent(newLom);
            this._mdEditor.saveMandatoryElements(newLom);
            this._contentPackage.changedElement(this, this._mdElement);
            this.updateSchemas();
        }
        this._mdEditor.SaveClassifications();
        this.dispose();
    }

    private void updateSchemas() {
        try {
            ReloadUtils.copyFolder(new File(ReloadEditorDocumentHandler.SCHEMASHIPPEDFOLDER, IMSDocumentHandler.LOM_10), this._contentPackage.getProjectFolder(), null);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void dispose() {
        try {
            this._mdEditor.destroy();
            super.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ReloadToolBar createToolBar(Menu_Edit editMenu) {
        ReloadToolBar tBar = new ReloadToolBar();
        tBar.add(editMenu.actionUndo);
        tBar.add(editMenu.actionRedo);
        tBar.addSeparator();
        tBar.add(editMenu.actionCut);
        tBar.add(editMenu.actionCopy);
        tBar.add(editMenu.actionPaste);
        tBar.add(editMenu.actionDelete);
        tBar.addSeparator();
        tBar.add(editMenu.actionMoveUp);
        tBar.add(editMenu.actionMoveDown);
        tBar.addSeparator();
        return tBar;
    }

    private class CancelClick
    extends AbstractAction {
        private CancelClick() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetadataEditorDialog.this.dispose();
        }
    }

    private class OKClick
    implements ActionListener {
        private OKClick() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetadataEditorDialog.this.finish();
        }
    }

    private class ImportMetadata
    extends AbstractAction {
        private ImportMetadata() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                MetadataEditorDialog.this.importMetadata();
            }
            catch (ReloadEditorException ex) {
                if (ReloadEditor.DEBUG) {
                    ex.printStackTrace();
                }
                ErrorDialogBox.showWarning("Error in Metadata", "Could not import Metadata File", ex);
            }
        }
    }

    private class ExportMetadata
    extends AbstractAction {
        private ExportMetadata() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetadataEditorDialog.this.exportMetadata();
        }
    }
}

