/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata;

import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jdom.Document;
import uk.ac.reload.dweezil.ApplicationListener;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadFileFilter;
import uk.ac.reload.dweezil.gui.ReloadInternalFrame;
import uk.ac.reload.dweezil.gui.ReloadInternalFrameManager;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.menu.ReloadMenuEvent;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.MetadataEditor;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.editor.prefs.ReloadEditorPrefs;
import uk.ac.reload.moonunit.dom.ReloadDocumentListener;
import uk.ac.reload.moonunit.dom.ReloadDocumentListenerEvent;
import uk.ac.reload.moonunit.dom.ReloadDomException;
import uk.ac.reload.moonunit.dom.ReloadSchemaDocument;

public class MetadataEditorFrame
extends ReloadInternalFrame
implements ApplicationListener,
ReloadDocumentListener {
    protected MetadataEditor _mdEditor;
    protected ProxySaveHandler _saveHandler;
    protected ProxySaveHandler _saveAsHandler;

    public MetadataEditorFrame() {
        this(false);
    }

    public MetadataEditorFrame(boolean useShortForm) {
        super("SCORM Metadata", ReloadEditor.ICON_MD);
        this.setDefaultCloseOperation(0);
        ReloadEditor.getInstance().addApplicationListener(this);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MetadataEditorFrame.this.checkNeedsSaving();
                    }
                });
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                MetadataEditorFrame.this.setFocusGained();
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                MetadataEditorFrame.this.setFocusLost();
            }
        });
        this._mdEditor = new MetadataEditor(MainMenu.sharedInstance.editMenu, useShortForm);
        this.getContentPane().add(this._mdEditor);
    }

    public void newDocument(MetadataSchemaController schemaController) throws ReloadEditorException {
        this.setTitle("Metadata - untitled");
        this._mdEditor.newDocument(true, schemaController);
        this.init(this._mdEditor.getMetadata());
    }

    public void setDocument(File file, Document doc, MetadataSchemaController schemaController) throws ReloadEditorException {
        this.setTitle("Metadata - " + file.getPath());
        this._mdEditor.setDocument(file, doc, schemaController);
        ReloadInternalFrameManager.addReloadInternalFrameToWindowMap(file, this);
        this.init(this._mdEditor.getMetadata());
    }

    private void init(Metadata metadata) {
        metadata.addReloadDocumentListener(this);
        this._saveHandler = new ProxySaveHandler(MainMenu.sharedInstance.actionSave);
        this._saveAsHandler = new ProxySaveHandler(MainMenu.sharedInstance.actionSaveAs);
    }

    @Override
    public void show() {
        super.show();
        this._mdEditor.initView();
    }

    @Override
    public void elementAdded(ReloadDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._mdEditor.getMetadata().isDirty());
        }
    }

    @Override
    public void elementChanged(ReloadDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._mdEditor.getMetadata().isDirty());
        }
    }

    @Override
    public void elementRemoved(ReloadDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._mdEditor.getMetadata().isDirty());
        }
    }

    @Override
    public void documentSaved(ReloadSchemaDocument doc) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._mdEditor.getMetadata().isDirty());
        }
    }

    protected void setFocusGained() {
        if (this._mdEditor.getMetadata() != null) {
            this._mdEditor.getUndoManager().setFocusGained();
            this._saveHandler.setEnabled(this._mdEditor.getMetadata().isDirty());
            this._saveHandler.addListener();
            this._saveAsHandler.setEnabled(true);
            this._saveAsHandler.addListener();
        }
    }

    protected void setFocusLost() {
        this._mdEditor.getUndoManager().setFocusLost();
        this._saveHandler.setEnabled(false);
        this._saveHandler.removeListener();
        this._saveAsHandler.setEnabled(false);
        this._saveAsHandler.removeListener();
    }

    @Override
    public boolean applicationClosing() {
        return this.checkNeedsSaving();
    }

    protected boolean checkNeedsSaving() {
        boolean isOK = true;
        if (this._mdEditor.getMetadata() != null && this._mdEditor.getMetadata().isDirty()) {
            int doSave = JOptionPane.showConfirmDialog(this, "File has been modified. Do you wish to save changes?", "Save Metadata File", 1);
            if (doSave == 0) {
                isOK = this.saveDocument();
            } else if (doSave == 2) {
                isOK = false;
            }
        }
        if (isOK) {
            this.dispose();
        }
        return isOK;
    }

    @Override
    public void dispose() {
        try {
            ReloadEditor.getInstance().removeApplicationListener(this);
            this._saveHandler.removeListener();
            this._saveAsHandler.removeListener();
            this._mdEditor.getMetadata().removeReloadDocumentListener(this);
            this._mdEditor.destroy();
            super.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean saveDocument() {
        Metadata md = this._mdEditor.getMetadata();
        if (this._mdEditor.getMetadata().getFile() == null) {
            return this.saveAsDocument();
        }
        this._mdEditor.saveMandatoryElements(md.getRootElement());
        this._mdEditor.SaveClassifications();
        try {
            this._mdEditor.getMetadata().saveDocument();
        }
        catch (ReloadDomException ex) {
            ErrorDialogBox.showWarning(this, "Could not save file: ", "Save Metadata", ex);
            return false;
        }
        return true;
    }

    protected boolean saveAsDocument() {
        Metadata md = this._mdEditor.getMetadata();
        this._mdEditor.saveMandatoryElements(md.getRootElement());
        ReloadFileFilter filter = new ReloadFileFilter(new String[]{"xml"}, "xml files");
        File file = ReloadUtils.askFileNameSave(this, "Save Metadata", filter, "xml");
        if (file == null) {
            return false;
        }
        this.setTitle("Metadata - " + file.getPath());
        try {
            this._mdEditor.SaveClassifications();
            this._mdEditor.getMetadata().saveAsDocument(file);
            ReloadInternalFrameManager.addReloadInternalFrameToWindowMap(file, this);
            ReloadEditorPrefs.getInstance().addFileToHistory(file);
        }
        catch (ReloadDomException ex) {
            ErrorDialogBox.showWarning(this, "Could not save file: ", "Save Metadata", ex);
            return false;
        }
        return true;
    }

    class ProxySaveHandler
    extends ProxyAction {
        public ProxySaveHandler(MenuAction menuAction) {
            super(menuAction);
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            if (MetadataEditorFrame.this.isSelected() && event.getSource() == MainMenu.sharedInstance.actionSave) {
                MetadataEditorFrame.this.saveDocument();
            }
            if (MetadataEditorFrame.this.isSelected() && event.getSource() == MainMenu.sharedInstance.actionSaveAs) {
                MetadataEditorFrame.this.saveAsDocument();
            }
        }
    }
}

