/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata;

import java.io.File;
import java.io.FileFilter;
import java.util.Hashtable;
import java.util.Vector;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.ReloadHelperProfile;
import uk.ac.reload.editor.metadata.MetadataProfileElement;
import uk.ac.reload.editor.prefs.ReloadEditorPrefs;

public class MetadataHelperProfile
extends ReloadHelperProfile {
    protected static Hashtable _mdProfilesTable = new Hashtable();
    protected MetadataProfileElement _rootElement;

    public MetadataHelperProfile(File fileProfile) throws ReloadEditorException {
        super(fileProfile);
        this._rootElement = new MetadataProfileElement(this._docProfile.getRootElement());
    }

    public static MetadataHelperProfile getMetadataProfile(File fileProfile) throws ReloadEditorException {
        if (fileProfile == null) {
            return null;
        }
        MetadataHelperProfile mdProfile = (MetadataHelperProfile)_mdProfilesTable.get(fileProfile);
        if (mdProfile == null && fileProfile.exists()) {
            mdProfile = new MetadataHelperProfile(fileProfile);
            _mdProfilesTable.put(fileProfile, mdProfile);
        }
        return mdProfile;
    }

    public static MetadataHelperProfile[] getMetadataHelperProfiles() {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return ReloadUtils.getFileExtension(file).equals("xml");
            }
        };
        Vector<MetadataHelperProfile> v = new Vector<MetadataHelperProfile>();
        File[] files = ReloadEditorDocumentHandler.folderMDProfile.listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    MetadataHelperProfile profile = MetadataHelperProfile.getMetadataProfile(files[i]);
                    v.addElement(profile);
                    continue;
                }
                catch (ReloadEditorException ex) {
                    // empty catch block
                }
            }
        }
        Object[] profiles = new MetadataHelperProfile[v.size()];
        v.copyInto(profiles);
        return profiles;
    }

    @Override
    public File getVocabFile() {
        return new File(ReloadEditorDocumentHandler.folderMDVocab, this.getVocabularyFileName());
    }

    @Override
    public File getSchemaHelperFile() {
        return new File(ReloadEditorDocumentHandler.folderMDSchemahelper, this.getSchemaHelperFileName());
    }

    public static MetadataHelperProfile getPrefsMetadataHelperProfile() throws ReloadEditorException {
        File file;
        String defProfileName = ReloadEditorPrefs.getInstance().getValue("default_mdprofile");
        if (defProfileName != null && (file = new File(ReloadEditorDocumentHandler.folderMDProfile, defProfileName)).exists()) {
            return MetadataHelperProfile.getMetadataProfile(file);
        }
        return null;
    }

    public static MetadataHelperProfile getDefaultMetadataHelperProfile() throws ReloadEditorException {
        String defProfileName = ReloadEditorPrefs.getInstance().getValue("default_mdprofile");
        if (defProfileName == null) {
            return MetadataHelperProfile.getMetadataProfile(ReloadEditorDocumentHandler.fileDefaultMDProfile);
        }
        File file = new File(ReloadEditorDocumentHandler.folderMDProfile, defProfileName);
        if (file.exists()) {
            return MetadataHelperProfile.getMetadataProfile(file);
        }
        return MetadataHelperProfile.getMetadataProfile(ReloadEditorDocumentHandler.fileDefaultMDProfile);
    }

    public static MetadataHelperProfile getDefaultSCORM2004MetadataHelperProfile() throws ReloadEditorException {
        MetadataHelperProfile userPrefMDProfile = MetadataHelperProfile.getPrefsMetadataHelperProfile();
        if (userPrefMDProfile != null) {
            return userPrefMDProfile;
        }
        return MetadataHelperProfile.getMetadataProfile(ReloadEditorDocumentHandler.fileDefaultSCORM2004MDProfile);
    }

    public static MetadataHelperProfile getHealthCareSCORM2004MetadataHelperProfile() throws ReloadEditorException {
        return MetadataHelperProfile.getMetadataProfile(ReloadEditorDocumentHandler.fileHealthCareSCORM2004MDProfile);
    }

    public static MetadataHelperProfile getDefaultSCORM1_2MetadataHelperProfile() throws ReloadEditorException {
        MetadataHelperProfile userPrefMDProfile = MetadataHelperProfile.getPrefsMetadataHelperProfile();
        if (userPrefMDProfile != null) {
            return userPrefMDProfile;
        }
        return MetadataHelperProfile.getMetadataProfile(ReloadEditorDocumentHandler.fileDefaultSCORM1_2MDProfile);
    }

    public MetadataProfileElement getRootElement() {
        return this._rootElement;
    }
}

