/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata;

import java.io.File;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.ReloadEditorSchemaController;
import uk.ac.reload.editor.metadata.MetadataHelperProfile;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class MetadataSchemaController
extends ReloadEditorSchemaController {
    String metadataVersion;

    public MetadataSchemaController(File fileSchema, String version) {
        try {
            this.metadataVersion = version;
            this.loadSchema(fileSchema);
            if (version.equals(IMSDocumentHandler.LOM_10)) {
                MetadataHelperProfile defProfile = MetadataHelperProfile.getDefaultMetadataHelperProfile();
                MetadataHelperProfile defSCORM2004Profile = MetadataHelperProfile.getDefaultSCORM2004MetadataHelperProfile();
                this.setHelperProfiles(defProfile, defSCORM2004Profile);
            } else if (version.equals("lom_hc_10")) {
                MetadataHelperProfile defProfile = MetadataHelperProfile.getDefaultMetadataHelperProfile();
                MetadataHelperProfile defSCORM2004Profile = MetadataHelperProfile.getHealthCareSCORM2004MetadataHelperProfile();
                this.setHelperProfiles(defProfile, defSCORM2004Profile);
            } else if (version.equals(IMSDocumentHandler.IMSMD_122) || version.equals(IMSDocumentHandler.IMSMD_121)) {
                MetadataHelperProfile defProfile = MetadataHelperProfile.getDefaultSCORM1_2MetadataHelperProfile();
                this.setHelperProfile(defProfile);
            }
        }
        catch (ReloadEditorException ex) {
            ErrorDialogBox.showWarning("Could not load Default Metadata Profile", "Load Profile", ex);
        }
    }

    public String getMetadataVersion() {
        return this.metadataVersion;
    }

    public static MetadataSchemaController getDefaultSchemaController1_2() {
        return (MetadataSchemaController)ReloadEditorSchemaController.getReloadSchemaController(IMSDocumentHandler.IMSMD_122);
    }

    public static MetadataSchemaController getDefaultSchemaController1_3() {
        return (MetadataSchemaController)ReloadEditorSchemaController.getReloadSchemaController(IMSDocumentHandler.LOM_10);
    }

    public static MetadataSchemaController getHealthCareSchemaController1_3() {
        return (MetadataSchemaController)ReloadEditorSchemaController.getReloadSchemaController("lom_hc_10");
    }

    @Override
    public String getRootElementName() {
        return "lom";
    }

    public ReloadSchemaElement[] getTopLevelElements() {
        return this._reloadSchema.getRootElement().getChildren();
    }

    public boolean isTopLevelElement(ReloadSchemaElement schemaElement) {
        return schemaElement.getParent() == this._reloadSchema.getRootElement();
    }

    @Override
    public Icon getLeafIcon(Element element) {
        String elementName = element.getName();
        if (elementName.equals("lom")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_MD);
        }
        return ReloadUIManager.getIcon(ReloadEditor.ICON_MDLEAF);
    }

    @Override
    public Icon getLeafIcon(ReloadSchemaElement schemaElement) {
        String elementName = schemaElement.getName();
        if (elementName.equals("lom")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_MD);
        }
        return ReloadUIManager.getIcon(ReloadEditor.ICON_MDLEAF);
    }

    @Override
    public Icon getOpenIcon(Element element) {
        String elementName = element.getName();
        if (elementName.equals("lom")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_MD);
        }
        return ReloadUIManager.getIcon(ReloadEditor.ICON_MDFOLDER);
    }

    @Override
    public Icon getOpenIcon(ReloadSchemaElement schemaElement) {
        String elementName = schemaElement.getName();
        if (elementName.equals("lom")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_MD);
        }
        return ReloadUIManager.getIcon(ReloadEditor.ICON_MDFOLDER);
    }

    @Override
    public Icon getClosedIcon(Element element) {
        return this.getOpenIcon(element);
    }

    @Override
    public Icon getClosedIcon(ReloadSchemaElement schemaElement) {
        return this.getLeafIcon(schemaElement);
    }
}

