/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.formview;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import uk.ac.reload.editor.metadata.formview.ClassificationController;
import uk.ac.reload.editor.metadata.formview.ClassificationView;
import uk.ac.reload.editor.metadata.formview.DefaultClassificationController;
import uk.ac.reload.editor.metadata.formview.MetadataFormModel;

public class ClassificationFormView
extends JPanel
implements ClassificationView {
    private JLabel mPurposeSourceLabel = new JLabel();
    private JLabel mPurposeValueLabel = new JLabel();
    private JLabel mTaxonPathSourceLabel = new JLabel();
    private JLabel mTaxonPathTaxonEntryLabel = new JLabel();
    private JLabel mIdLabel = new JLabel();
    private JTextArea mPurposeSourceField = new JTextArea();
    private JTextArea mPurposeValueField = new JTextArea();
    private JTextArea mTaxonPathSourceField = new JTextArea();
    private JTextArea mTaxonPathTaxonEntryField = new JTextArea();
    private JComboBox mTaxonPathTaxonEntrySelection = null;
    private JTextArea mIdField = new JTextArea();
    private boolean mDirty = true;
    private ClassificationController mController;

    public ClassificationFormView(int number, MetadataFormModel model) {
        this(number, model, false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component comp : this.getComponents()) {
            if (comp instanceof JCheckBox) continue;
            comp.setEnabled(enabled);
        }
        boolean editable = false;
        this.mPurposeSourceField.setEnabled(editable);
        this.mPurposeValueField.setEnabled(editable);
    }

    public ClassificationFormView(int number, MetadataFormModel model, boolean editable) {
        this.mController = new DefaultClassificationController(this, model, number);
        this.mController.Load();
        this.mPurposeSourceLabel.setText("Purpose Source:");
        this.mPurposeValueLabel.setText("Purpose Value:");
        this.mTaxonPathSourceLabel.setText("Taxonomy Source:");
        this.mTaxonPathTaxonEntryLabel.setText("Taxonomy Entry:");
        GridLayout layout = new GridLayout(0, 2, 0, 10);
        this.setLayout(layout);
        this.add(this.createMainLabel(number));
        if (number > 4) {
            JCheckBox box = new JCheckBox();
            this.mDirty = false;
            box.setText("Enable Classificatoin");
            box.setSelected(this.getTaxonPathSource() != null && !"".equals(this.getTaxonPathSource()));
            this.setEnabled(box.isSelected());
            box.addActionListener(new viewEnableListner(this));
            this.add(box);
        } else {
            this.add(new JLabel());
        }
        this.add(this.mPurposeSourceLabel);
        this.add(this.mPurposeSourceField);
        this.mPurposeSourceField.setEnabled(editable);
        this.add(this.mPurposeValueLabel);
        this.add(this.mPurposeValueField);
        this.mPurposeValueField.setEnabled(editable);
        this.add(this.mTaxonPathSourceLabel);
        this.add(this.mTaxonPathSourceField);
        this.mTaxonPathSourceField.setEnabled(editable);
        this.add(this.mTaxonPathTaxonEntryLabel);
        if (this.mTaxonPathTaxonEntryField != null) {
            this.add(this.mTaxonPathTaxonEntryField);
            this.mTaxonPathTaxonEntryField.setEnabled(editable);
        } else {
            this.add(this.mTaxonPathTaxonEntrySelection);
            this.mTaxonPathTaxonEntrySelection.setEnabled(true);
        }
        if (number == 4) {
            if (this.mTaxonPathTaxonEntryField != null) {
                this.mTaxonPathTaxonEntryField.setEnabled(true);
            }
        } else if (number > 4) {
            this.mIdLabel = new JLabel();
            this.mIdLabel.setText("Taxon Id");
            this.mTaxonPathSourceField.setEnabled(true);
            this.mTaxonPathTaxonEntryField.setEnabled(true);
            this.add(this.mIdLabel);
            this.add(this.mIdField);
        }
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof JTextArea)) continue;
            ((JTextArea)comp).addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    ClassificationFormView.this.mDirty = true;
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        }
    }

    private JLabel createMainLabel(int number) {
        JLabel mainLabel = new JLabel();
        String format = "<html><b>%s</b></html>";
        String text = "";
        switch (number) {
            case 0: {
                text = "Security classification";
                break;
            }
            case 1: {
                text = "ADL/DOD object type";
                break;
            }
            case 2: {
                text = "ADL/DOD distribution restrictions";
                break;
            }
            case 3: {
                text = "ADL/DOD complies with";
                break;
            }
            case 4: {
                text = "ADL/DOD categorization";
                break;
            }
            case 5: {
                text = "Educational objective";
                break;
            }
            case 6: {
                text = "Competency";
            }
        }
        mainLabel.setText(String.format("<html><b>%s</b></html>", text));
        return mainLabel;
    }

    @Override
    public String getPurposeValue() {
        return this.mPurposeValueField.getText();
    }

    @Override
    public String getSource() {
        return this.mPurposeSourceField.getText();
    }

    @Override
    public String getTaxonPathSource() {
        return this.mTaxonPathSourceField.getText();
    }

    @Override
    public String getTaxonPathTaxonEntry() {
        if (this.mTaxonPathTaxonEntryField != null) {
            return this.mTaxonPathTaxonEntryField.getText();
        }
        return this.mTaxonPathTaxonEntrySelection.getSelectedItem().toString();
    }

    @Override
    public void setPurposeValue(String value) {
        this.mPurposeValueField.setText(value);
    }

    @Override
    public void setSource(String value) {
        this.mPurposeSourceField.setText(value);
    }

    @Override
    public void setTaxonPathSource(String value) {
        this.mTaxonPathSourceField.setText(value);
    }

    @Override
    public void setTaxonPathTaxonEntry(String value) {
        if (this.mTaxonPathTaxonEntryField != null) {
            this.mTaxonPathTaxonEntryField.setText(value);
        } else {
            this.mTaxonPathTaxonEntrySelection.setSelectedItem(value);
        }
    }

    @Override
    public void Save() {
        this.mController.Save();
    }

    @Override
    public String getId() {
        return this.mIdField.getText();
    }

    @Override
    public void setId(String value) {
        this.mIdField.setText(value);
    }

    @Override
    public boolean isDirty() {
        return this.mDirty;
    }

    @Override
    public void addTaxonPathTaxonEntryValue(String ... entries) {
        this.remove(this.mTaxonPathTaxonEntryField);
        this.mTaxonPathTaxonEntryField = null;
        if (this.mTaxonPathTaxonEntrySelection == null) {
            this.mTaxonPathTaxonEntrySelection = new JComboBox();
        }
        for (String item : entries) {
            this.mTaxonPathTaxonEntrySelection.addItem(item);
        }
    }

    private class viewEnableListner
    implements ActionListener {
        private ClassificationFormView mView;

        public viewEnableListner(ClassificationFormView view) {
            this.mView = view;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JCheckBox check = (JCheckBox)arg0.getSource();
            this.mView.setEnabled(check.isSelected());
            if (!check.isSelected()) {
                this.mView.setTaxonPathSource("");
                this.mView.setTaxonPathTaxonEntry("");
                this.mView.setId("");
            }
        }
    }
}

