/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.formview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uk.ac.reload.dweezil.gui.widgets.ReloadNumberField;
import uk.ac.reload.dweezil.gui.widgets.ReloadTextField;
import uk.ac.reload.dweezil.gui.widgets.ReloadWidget;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.formview.MetadataField;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class DateTimeMetadataTextField
extends MetadataField
implements DocumentListener {
    boolean _allowNotification = true;
    protected JPanel _reloadWidget;
    private ReloadWidget yearComponent;
    private ReloadWidget monthComponent;
    private ReloadWidget dayComponent;
    private ReloadWidget hourComponent;
    private ReloadWidget minuteComponent;
    private ReloadWidget secondComponent;
    private ReloadWidget secondFractionComponent;
    private ReloadWidget timeZoneComponent;
    private Vector widgetArray = new Vector();

    public DateTimeMetadataTextField(Metadata metadata, ReloadSchemaElement schemaElement) {
        super(metadata, schemaElement);
        this._reloadWidget = new JPanel();
        if (schemaElement.getName().equalsIgnoreCase("dateTime")) {
            this.setDateTimeElementWidget();
        }
        if (this._reloadWidget != null) {
            this._reloadWidget.setBorder(null);
            this._element = metadata.getElement(this._schemaElement);
            if (this._element != null) {
                this.setValue(this._element.getText());
            }
        }
        metadata.addReloadDocumentListener(this);
    }

    protected void setDateTimeElementWidget() {
        this.yearComponent = new ReloadNumberField(4);
        ((ReloadNumberField)this.yearComponent).setColumns(4);
        this.widgetArray.add(this.yearComponent);
        this.monthComponent = new ReloadNumberField(2);
        ((ReloadNumberField)this.monthComponent).setColumns(2);
        this.widgetArray.add(this.monthComponent);
        this.dayComponent = new ReloadNumberField(2);
        ((ReloadNumberField)this.dayComponent).setColumns(2);
        this.widgetArray.add(this.dayComponent);
        this.hourComponent = new ReloadNumberField(2);
        ((ReloadNumberField)this.hourComponent).setColumns(2);
        this.widgetArray.add(this.hourComponent);
        this.minuteComponent = new ReloadNumberField(2);
        ((ReloadNumberField)this.minuteComponent).setColumns(2);
        this.widgetArray.add(this.minuteComponent);
        this.secondComponent = new ReloadNumberField(2);
        ((ReloadNumberField)this.secondComponent).setColumns(2);
        this.widgetArray.add(this.secondComponent);
        this.secondFractionComponent = new ReloadNumberField(7);
        ((ReloadNumberField)this.secondFractionComponent).setColumns(7);
        this.widgetArray.add(this.secondFractionComponent);
        this.timeZoneComponent = new ReloadTextField(3);
        ((ReloadTextField)this.timeZoneComponent).setColumns(4);
        this.widgetArray.add(this.timeZoneComponent);
        JLabel year = new JLabel("<html>YYYY (four-digit year <font color=red>REQUIRED FOR DATETIME ELEMENT</font>)    </html>");
        JLabel months = new JLabel("<html>MM (01 through 12)    </html>");
        JLabel days = new JLabel("<html>DD (01 through 31)  </html>");
        JLabel hours = new JLabel("<html>hh (00 - 23)   </html>");
        JLabel minutes = new JLabel("<html>mm (00 - 59)   </html>");
        JLabel seconds = new JLabel("<html>ss (00 - 59)  .</html>");
        JLabel fractionSeconds = new JLabel("<html>s (fraction of a second)   </html>");
        JLabel tzd = new JLabel("<html>TZD (time zone designator)   </html>");
        for (int i = 0; i < this.widgetArray.size(); ++i) {
            ((JComponent)this.widgetArray.get(i)).setBorder(null);
            ((ReloadWidget)this.widgetArray.get(i)).addDocumentListener(this);
        }
        JPanel YYYYMMDD = new JPanel();
        JPanel theRest = new JPanel();
        YYYYMMDD.add((ReloadNumberField)this.yearComponent);
        YYYYMMDD.add(year);
        YYYYMMDD.add((ReloadNumberField)this.monthComponent);
        YYYYMMDD.add(months);
        YYYYMMDD.add((ReloadNumberField)this.dayComponent);
        YYYYMMDD.add(days);
        theRest.add((ReloadNumberField)this.hourComponent);
        theRest.add(hours);
        theRest.add((ReloadNumberField)this.minuteComponent);
        theRest.add(minutes);
        theRest.add((ReloadNumberField)this.secondComponent);
        theRest.add(seconds);
        theRest.add((ReloadNumberField)this.secondFractionComponent);
        theRest.add(fractionSeconds);
        theRest.add((ReloadTextField)this.timeZoneComponent);
        theRest.add(tzd);
        this._reloadWidget.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 0, 5, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 17;
        this._reloadWidget.add((Component)YYYYMMDD, constraints);
        ++constraints.gridy;
        this._reloadWidget.add((Component)theRest, constraints);
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.widgetArray.size(); ++i) {
            ((ReloadWidget)this.widgetArray.get(i)).removeDocumentListener(this);
        }
        this._reloadDocument.removeReloadDocumentListener(this);
    }

    @Override
    public String getValue() {
        String value = null;
        if (this.yearComponent.getTextValue().length() > 0) {
            value = this.yearComponent.getTextValue();
            if (this.monthComponent.getTextValue().length() > 0) {
                value = value + "-" + this.monthComponent.getTextValue();
            }
            if (this.dayComponent.getTextValue().length() > 0) {
                value = value + "-" + this.dayComponent.getTextValue();
            }
            value = value + "T";
            value = this.hourComponent.getTextValue().length() > 0 ? value + this.hourComponent.getTextValue() : value + "00";
            value = this.minuteComponent.getTextValue().length() > 0 ? value + ":" + this.minuteComponent.getTextValue() : value + ":00";
            value = this.secondComponent.getTextValue().length() > 0 ? value + ":" + this.secondComponent.getTextValue() : value + ":00";
            value = this.secondFractionComponent.getTextValue().length() > 0 ? value + "." + this.secondFractionComponent.getTextValue() : value + ".00";
            if (this.timeZoneComponent.getTextValue().length() > 0) {
                value = value + this.timeZoneComponent.getTextValue();
            }
        }
        return value;
    }

    @Override
    public void setValue(String value) {
        this._allowNotification = false;
        String yearText = null;
        if (value.length() >= 4) {
            yearText = value.substring(0, 4);
        }
        Integer year = null;
        if (yearText != null) {
            try {
                year = new Integer(yearText);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
        }
        if (year != null) {
            this.yearComponent.setTextValue(year.toString());
            int previousIndex = 4;
            int i = 0;
            for (i = previousIndex; i < value.length(); ++i) {
                if (value.charAt(i) == '-' && i + 2 <= value.length()) {
                    String dateText = value.substring(i + 1, i + 3);
                    Integer date = null;
                    try {
                        date = new Integer(dateText);
                        if (i == 4) {
                            this.monthComponent.setTextValue(dateText);
                            continue;
                        }
                        if (i == 7) {
                            this.dayComponent.setTextValue(dateText);
                            continue;
                        }
                        JOptionPane.showMessageDialog(null, "DateTime value for Year in existing metadata is invalid and will not be added.");
                    }
                    catch (NumberFormatException ne) {
                        JOptionPane.showMessageDialog(null, "DateTime value for Year in existing metadata is invalid and will not be added.");
                    }
                    continue;
                }
                if (value.charAt(i) == 'T') break;
            }
            if (value.contains("T") && value.charAt(i) == 'T' && i + 2 <= value.length()) {
                Object date;
                String timeText = value.substring(i + 1, i + 3);
                Integer time = null;
                try {
                    time = new Integer(timeText);
                    this.hourComponent.setTextValue(timeText);
                }
                catch (NumberFormatException ne) {
                    JOptionPane.showMessageDialog(null, "DateTime value for Hour in existing metadata is invalid and will not be added.");
                }
                if ((i += 3) < value.length() && value.charAt(i) == ':' && i + 2 <= value.length()) {
                    timeText = value.substring(i + 1, i + 3);
                    date = null;
                    try {
                        time = new Integer(timeText);
                        this.minuteComponent.setTextValue(timeText);
                    }
                    catch (NumberFormatException ne) {
                        JOptionPane.showMessageDialog(null, "DateTime value for Minute in existing metadata is invalid and will not be added.");
                    }
                    i += 3;
                }
                if (i < value.length() && value.charAt(i) == ':' && i + 2 <= value.length()) {
                    timeText = value.substring(i + 1, i + 3);
                    date = null;
                    try {
                        time = new Integer(timeText);
                        this.secondComponent.setTextValue(timeText);
                    }
                    catch (NumberFormatException ne) {
                        JOptionPane.showMessageDialog(null, "DateTime value for Second existing metadata is invalid and will not be added.");
                    }
                    i += 3;
                }
                if (i < value.length() && value.charAt(i) == '.') {
                    String decimal = null;
                    for (int j = i; j < value.length(); ++j) {
                        timeText = value.substring(j, j + 1);
                        Object date2 = null;
                        try {
                            time = new Integer(timeText);
                            if (decimal == null) {
                                decimal = time.toString();
                                continue;
                            }
                            decimal = decimal + time.toString();
                            continue;
                        }
                        catch (NumberFormatException ne) {
                            // empty catch block
                        }
                    }
                    if (decimal != null) {
                        this.secondFractionComponent.setTextValue(decimal);
                        i += decimal.length() + 1;
                    }
                }
                if (value.length() - i >= 3) {
                    this.timeZoneComponent.setTextValue(value.substring(i, i + 3));
                }
            }
        }
        this._allowNotification = true;
    }

    @Override
    public Component getComponent() {
        return this._reloadWidget;
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }
}

