/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.formview;

import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.formview.ClassificationController;
import uk.ac.reload.editor.metadata.formview.ClassificationView;
import uk.ac.reload.editor.metadata.formview.MetadataFormModel;
import uk.ac.reload.moonunit.IMSDocumentHandler;

public class DefaultClassificationController
implements ClassificationController {
    private static final String ENTRY = "entry";
    private static final String TAXON = "taxon";
    private static final String STRING = "string";
    private static final String TAXON_PATH = "taxonPath";
    private static final String VALUE = "value";
    private static final String SOURCE = "source";
    private static final String PURPOSE = "purpose";
    private static final String ID = "id";
    private ClassificationView mView;
    private MetadataFormModel mModel;
    private Document mDocument;
    private int mClassificationNumber;
    private static final String CLASSIFICATION = "classification";

    public DefaultClassificationController(ClassificationView view, MetadataFormModel model, int number) {
        this.mView = view;
        this.mModel = model;
        this.mDocument = model._metadata.getDocument();
        this.mClassificationNumber = number;
    }

    @Override
    public void Load() {
        Element root = this.mDocument.getRootElement();
        List children = root.getChildren(CLASSIFICATION, IMSDocumentHandler.LOM_NAMESPACE_10);
        switch (this.mClassificationNumber) {
            case 1: {
                this.mView.addTaxonPathTaxonEntryValue("asset", "sco", "aggregation", "other");
                break;
            }
            case 2: {
                this.mView.addTaxonPathTaxonEntryValue("LR", "NR", "CP", "CG", "CD", "RD", "NF", "OT", "Distribution Statement A", "Distribution Statement B", "Distribution Statement C", "Distribution Statement D", "Distribution Statement E", "Distribution Statement F", "Distribution Statement X");
                break;
            }
            case 3: {
                this.mView.addTaxonPathTaxonEntryValue("SCORM 2004", "SCORM Version 1.2", "S1000D V2.0", "S1000D V2.0", "S1000D V2.1", "S1000D V2.2", "IMS RCDEO V1.0", "Unknown");
            }
        }
        if (children != null && children.size() > this.mClassificationNumber) {
            Element element = (Element)children.get(this.mClassificationNumber);
            Element purpose = element.getChild(PURPOSE, IMSDocumentHandler.LOM_NAMESPACE_10);
            Element purposeSource = purpose.getChild(SOURCE, IMSDocumentHandler.LOM_NAMESPACE_10);
            Element purposeValue = purpose.getChild(VALUE, IMSDocumentHandler.LOM_NAMESPACE_10);
            this.mView.setSource(purposeSource.getText());
            this.mView.setPurposeValue(purposeValue.getText());
            Element taxonPath = element.getChild(TAXON_PATH, IMSDocumentHandler.LOM_NAMESPACE_10);
            Element taxonPathSource = taxonPath.getChild(SOURCE, IMSDocumentHandler.LOM_NAMESPACE_10).getChild(STRING, IMSDocumentHandler.LOM_NAMESPACE_10);
            Element taxon = taxonPath.getChild(TAXON, IMSDocumentHandler.LOM_NAMESPACE_10);
            Element taxonPathTaxonEntryString = taxon.getChild(ENTRY, IMSDocumentHandler.LOM_NAMESPACE_10).getChild(STRING, IMSDocumentHandler.LOM_NAMESPACE_10);
            this.mView.setTaxonPathSource(taxonPathSource.getText());
            this.mView.setTaxonPathTaxonEntry(taxonPathTaxonEntryString.getText());
            if (this.mClassificationNumber > 4) {
                Element taxonId = taxonPath.getChild(TAXON, IMSDocumentHandler.LOM_NAMESPACE_10).getChild(ID, IMSDocumentHandler.LOM_NAMESPACE_10);
                this.mView.setId(taxonId.getText());
            }
        } else {
            String source = "";
            String purposeValue = "";
            String taxonPathSource = "";
            String taxonPathTaxonEntry = "";
            String id = "";
            switch (this.mClassificationNumber) {
                case 0: {
                    source = "LOMv1.0";
                    purposeValue = "security level";
                    taxonPathSource = "ADL/DOD Security Taxonomy";
                    taxonPathTaxonEntry = "unclassified";
                    break;
                }
                case 1: {
                    source = "ADL-Rv1.0";
                    purposeValue = "object type";
                    taxonPathSource = "ADL/DOD Object Type Taxonomy";
                    taxonPathTaxonEntry = "asset";
                    break;
                }
                case 2: {
                    source = "ADL-Rv1.0";
                    purposeValue = "distribution restrictions";
                    taxonPathSource = "ADL/DOD Distribution Taxonomy";
                    taxonPathTaxonEntry = "LR";
                    break;
                }
                case 3: {
                    source = "ADL-Rv1.0";
                    purposeValue = "complies with";
                    taxonPathSource = "ADL/DOD Compliance Taxonomy";
                    taxonPathTaxonEntry = "SCORM 2004 4rd Edition";
                    break;
                }
                case 4: {
                    source = "ADL-Rv1.0";
                    purposeValue = "collection";
                    taxonPathSource = "ADL/DOD Object Category Taxonomy";
                    taxonPathTaxonEntry = "DOD";
                    break;
                }
                case 5: {
                    source = "LOMv1.0";
                    purposeValue = "educational objective";
                    taxonPathSource = "";
                    taxonPathTaxonEntry = "";
                    break;
                }
                case 6: {
                    source = "LOMv1.0";
                    purposeValue = "competency";
                    taxonPathSource = "";
                    taxonPathTaxonEntry = "";
                }
            }
            this.mView.setSource(source);
            this.mView.setPurposeValue(purposeValue);
            this.mView.setTaxonPathSource(taxonPathSource);
            this.mView.setTaxonPathTaxonEntry(taxonPathTaxonEntry);
        }
    }

    @Override
    public void Save() {
        if (this.mView.isDirty()) {
            Element root = this.mDocument.getRootElement();
            List children = root.getChildren(CLASSIFICATION, IMSDocumentHandler.LOM_NAMESPACE_10);
            Element element = null;
            if (children != null && children.size() > this.mClassificationNumber) {
                element = (Element)children.get(this.mClassificationNumber);
            } else {
                Metadata metadata = this.mModel._metadata;
                element = new Element(CLASSIFICATION, IMSDocumentHandler.LOM_NAMESPACE_10);
                metadata.addElement(this, root, element, false);
            }
            this.savePurposeElement(element);
            this.saveTaxonPathElement(element);
            this.saveTaxonId(element);
        }
    }

    private void savePurposeElement(Element element) {
        Element purpose = this.getTargetElement(PURPOSE, element, IMSDocumentHandler.LOM_NAMESPACE_10);
        Element purposeSource = this.getTargetElement(SOURCE, purpose, IMSDocumentHandler.LOM_NAMESPACE_10);
        purposeSource.setText(this.mView.getSource());
        Element purposeValue = this.getTargetElement(VALUE, purpose, IMSDocumentHandler.LOM_NAMESPACE_10);
        purposeValue.setText(this.mView.getPurposeValue());
    }

    private void saveTaxonPathElement(Element element) {
        Element taxonPath = this.getTargetElement(TAXON_PATH, element, IMSDocumentHandler.LOM_NAMESPACE_10);
        Element source = this.getTargetElement(SOURCE, taxonPath, IMSDocumentHandler.LOM_NAMESPACE_10);
        Element sourceString = this.getTargetElement(STRING, source, IMSDocumentHandler.LOM_NAMESPACE_10);
        sourceString.setText(this.mView.getTaxonPathSource());
        Element taxon = this.getTargetElement(TAXON, taxonPath, IMSDocumentHandler.LOM_NAMESPACE_10);
        Element entry = this.getTargetElement(ENTRY, taxon, IMSDocumentHandler.LOM_NAMESPACE_10);
        Element taxonString = this.getTargetElement(STRING, entry, IMSDocumentHandler.LOM_NAMESPACE_10);
        taxonString.setText(this.mView.getTaxonPathTaxonEntry());
    }

    private void saveTaxonId(Element element) {
        Element taxonPath = this.getTargetElement(TAXON_PATH, element, IMSDocumentHandler.LOM_NAMESPACE_10);
        Element taxon = this.getTargetElement(TAXON, taxonPath, IMSDocumentHandler.LOM_NAMESPACE_10);
        Element id = this.getTargetElement(ID, taxon, IMSDocumentHandler.LOM_NAMESPACE_10);
        id.setText(this.mView.getId());
    }

    private Element getTargetElement(String targetElementName, Element parent, Namespace ns) {
        Metadata metadata = this.mModel._metadata;
        Element target = parent.getChild(targetElementName, IMSDocumentHandler.LOM_NAMESPACE_10);
        if (target == null) {
            target = new Element(targetElementName, IMSDocumentHandler.LOM_NAMESPACE_10);
            metadata.addElement(this, parent, target, false);
        }
        return target;
    }

    @Override
    public void Update() {
    }
}

