/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.formview;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uk.ac.reload.dweezil.gui.widgets.ReloadDecimalField;
import uk.ac.reload.dweezil.gui.widgets.ReloadNumberField;
import uk.ac.reload.dweezil.gui.widgets.ReloadWidget;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.formview.MetadataField;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class DurationMetadataTextField
extends MetadataField
implements DocumentListener {
    boolean _allowNotification = true;
    protected JPanel _reloadWidget = new JPanel();
    private ReloadWidget yearsComponent;
    private ReloadWidget monthsComponent;
    private ReloadWidget daysComponent;
    private ReloadWidget hoursComponent;
    private ReloadWidget minutesComponent;
    private ReloadWidget secondsComponent;

    public DurationMetadataTextField(Metadata metadata, ReloadSchemaElement schemaElement) {
        super(metadata, schemaElement);
        if (schemaElement.getName().equalsIgnoreCase("duration")) {
            this.setDurationElementWidget();
        }
        if (this._reloadWidget != null) {
            this._reloadWidget.setBorder(null);
            this._element = metadata.getElement(this._schemaElement);
            if (this._element != null) {
                this.setValue(this._element.getText());
            }
        }
        metadata.addReloadDocumentListener(this);
    }

    protected void setDurationElementWidget() {
        this.yearsComponent = new ReloadNumberField();
        ((ReloadNumberField)this.yearsComponent).setColumns(4);
        this.monthsComponent = new ReloadNumberField();
        ((ReloadNumberField)this.monthsComponent).setColumns(4);
        this.daysComponent = new ReloadNumberField();
        ((ReloadNumberField)this.daysComponent).setColumns(4);
        this.hoursComponent = new ReloadNumberField();
        ((ReloadNumberField)this.hoursComponent).setColumns(4);
        this.minutesComponent = new ReloadNumberField();
        ((ReloadNumberField)this.minutesComponent).setColumns(4);
        this.secondsComponent = new ReloadDecimalField();
        ((ReloadDecimalField)this.secondsComponent).setColumns(4);
        int maxLength = 7;
        this.yearsComponent.setMaxLength(maxLength);
        this.monthsComponent.setMaxLength(maxLength);
        this.daysComponent.setMaxLength(maxLength);
        this.hoursComponent.setMaxLength(maxLength);
        this.minutesComponent.setMaxLength(maxLength);
        this.secondsComponent.setMaxLength(maxLength);
        ((JComponent)((Object)this.yearsComponent)).setBorder(null);
        ((JComponent)((Object)this.monthsComponent)).setBorder(null);
        ((JComponent)((Object)this.daysComponent)).setBorder(null);
        ((JComponent)((Object)this.hoursComponent)).setBorder(null);
        ((JComponent)((Object)this.minutesComponent)).setBorder(null);
        ((JComponent)((Object)this.secondsComponent)).setBorder(null);
        this.yearsComponent.addDocumentListener(this);
        this.monthsComponent.addDocumentListener(this);
        this.daysComponent.addDocumentListener(this);
        this.hoursComponent.addDocumentListener(this);
        this.minutesComponent.addDocumentListener(this);
        this.secondsComponent.addDocumentListener(this);
        JLabel years = new JLabel("Years   ");
        JLabel months = new JLabel("Months   ");
        JLabel days = new JLabel("Days   ");
        JLabel hours = new JLabel("Hours   ");
        JLabel minutes = new JLabel("Minutes   ");
        JLabel seconds = new JLabel("Seconds   ");
        this._reloadWidget.add((ReloadNumberField)this.yearsComponent);
        this._reloadWidget.add(years);
        this._reloadWidget.add((ReloadNumberField)this.monthsComponent);
        this._reloadWidget.add(months);
        this._reloadWidget.add((ReloadNumberField)this.daysComponent);
        this._reloadWidget.add(days);
        this._reloadWidget.add((ReloadNumberField)this.hoursComponent);
        this._reloadWidget.add(hours);
        this._reloadWidget.add((ReloadNumberField)this.minutesComponent);
        this._reloadWidget.add(minutes);
        this._reloadWidget.add((ReloadDecimalField)this.secondsComponent);
        this._reloadWidget.add(seconds);
    }

    @Override
    public void destroy() {
        this.yearsComponent.removeDocumentListener(this);
        this.monthsComponent.removeDocumentListener(this);
        this.daysComponent.removeDocumentListener(this);
        this.hoursComponent.removeDocumentListener(this);
        this.minutesComponent.removeDocumentListener(this);
        this.secondsComponent.removeDocumentListener(this);
        this._reloadDocument.removeReloadDocumentListener(this);
    }

    @Override
    public String getValue() {
        String value = "P";
        if (this.yearsComponent.getTextValue().length() > 0) {
            value = value + this.yearsComponent.getTextValue() + "Y";
        }
        if (this.monthsComponent.getTextValue().length() > 0) {
            value = value + this.monthsComponent.getTextValue() + "M";
        }
        if (this.daysComponent.getTextValue().length() > 0) {
            value = value + this.daysComponent.getTextValue() + "D";
        }
        if (this.hoursComponent.getTextValue().length() > 0 || this.minutesComponent.getTextValue().length() > 0 || this.secondsComponent.getTextValue().length() > 0) {
            value = value + "T";
        }
        if (this.hoursComponent.getTextValue().length() > 0) {
            value = value + this.hoursComponent.getTextValue() + "H";
        }
        if (this.minutesComponent.getTextValue().length() > 0) {
            value = value + this.minutesComponent.getTextValue() + "M";
        }
        if (this.secondsComponent.getTextValue().length() > 0) {
            value = value + this.secondsComponent.getTextValue() + "S";
        }
        return value;
    }

    @Override
    public void setValue(String value) {
        this._allowNotification = false;
        int previousIndex = 0;
        int t = Integer.MAX_VALUE;
        if (value != null) {
            previousIndex = value.indexOf("P") + 1;
            t = value.indexOf("T") + 1;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == 'Y' && i > previousIndex) {
                this.yearsComponent.setTextValue(value.substring(previousIndex, i));
                previousIndex = i + 1;
                continue;
            }
            if (value.charAt(i) == 'M' && i > previousIndex) {
                if (t >= 0 && t < i) {
                    if (t > previousIndex) {
                        this.minutesComponent.setTextValue(value.substring(t, i));
                    } else {
                        this.minutesComponent.setTextValue(value.substring(previousIndex, i));
                    }
                } else {
                    this.monthsComponent.setTextValue(value.substring(previousIndex, i));
                }
                previousIndex = i + 1;
                continue;
            }
            if (value.charAt(i) == 'D' && i > previousIndex) {
                this.daysComponent.setTextValue(value.substring(previousIndex, i));
                previousIndex = i + 1;
                continue;
            }
            if (value.charAt(i) == 'H' && i > previousIndex) {
                if (t >= 0 && t > previousIndex && t < i) {
                    this.hoursComponent.setTextValue(value.substring(t, i));
                } else {
                    this.hoursComponent.setTextValue(value.substring(previousIndex, i));
                }
                previousIndex = i + 1;
                continue;
            }
            if (value.charAt(i) != 'S' || i <= previousIndex) continue;
            if (t >= 0 && t > previousIndex && t < i) {
                this.secondsComponent.setTextValue(value.substring(t, i));
            } else {
                this.secondsComponent.setTextValue(value.substring(previousIndex, i));
            }
            previousIndex = i + 1;
        }
        this._allowNotification = true;
    }

    @Override
    public Component getComponent() {
        return this._reloadWidget;
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }
}

