/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.formview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import uk.ac.reload.dweezil.gui.ReloadComboBox;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.formview.MetadataField;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;
import uk.ac.reload.moonunit.schema.ReloadVocabularyList;

public class MetadataComboBox
extends MetadataField
implements ActionListener {
    boolean allowNotification = true;
    protected ReloadComboBox _comboBox;

    public MetadataComboBox(Metadata metadata, ReloadSchemaElement schemaElement, ReloadVocabularyList rvList) {
        super(metadata, schemaElement);
        this._comboBox = schemaElement.getName().equalsIgnoreCase("metadataSchema1") || schemaElement.getName().equalsIgnoreCase("metadataSchema2") ? new ReloadComboBox(false) : new ReloadComboBox(true);
        this._comboBox.setBorder(null);
        this._comboBox.setItems(rvList.getList());
        this._element = metadata.getElement(this._schemaElement);
        if (this._element != null && !this._element.getName().equalsIgnoreCase("metadataSchema1") && !this._element.getName().equalsIgnoreCase("metadataSchema2")) {
            this.setValue(this._element.getText());
        } else {
            this.setValue("");
        }
        String defaultValue = rvList.getDefaultValue();
        if (defaultValue != null) {
            this.setValue(defaultValue);
            if (this.allowNotification) {
                this.fireElementChanged();
            }
        }
        this._comboBox.addActionListener(this);
        metadata.addReloadDocumentListener(this);
    }

    @Override
    public void destroy() {
        this._reloadDocument.removeReloadDocumentListener(this);
        this._comboBox.removeActionListener(this);
    }

    @Override
    public String getValue() {
        return (String)this._comboBox.getSelectedItem();
    }

    @Override
    public void setValue(String value) {
        this.allowNotification = false;
        this._comboBox.setSelectedItem(value);
        this.allowNotification = true;
    }

    @Override
    public Component getComponent() {
        return this._comboBox;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.allowNotification) {
            this.fireElementChanged();
        }
    }
}

