/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.formview;

import java.util.List;
import org.jdom.Element;
import uk.ac.reload.editor.gui.ReloadFormField;
import uk.ac.reload.moonunit.dom.ReloadDocumentListenerEvent;
import uk.ac.reload.moonunit.dom.ReloadSchemaDocument;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public abstract class MetadataField
extends ReloadFormField {
    public MetadataField(ReloadSchemaDocument doc, ReloadSchemaElement schemaElement) {
        super(doc, null, schemaElement);
    }

    protected synchronized void fireElementChanged() {
        String text = this.getValue();
        if (this._element != null) {
            if (this.getValue().length() <= 0) {
                Element parent = this._element.getParentElement();
                this._reloadDocument.removeElement(this, this._element);
                List children = parent.getChildren();
                if (children.size() <= 0) {
                    this._reloadDocument.removeElement(this, parent);
                    parent = null;
                }
                this._element = null;
            } else {
                this._element.setText(text);
                this._reloadDocument.changedElement(this, this._element);
            }
        } else {
            this._element = this._reloadDocument.addElementUnique(this, this._schemaElement, true);
            if (this._element != null) {
                this._element.setText(text);
            }
        }
    }

    @Override
    public void elementAdded(ReloadDocumentListenerEvent event) {
        if (event.getSource() == this) {
            return;
        }
        this.addElement(event.getElement());
    }

    protected void addElement(Element element) {
        if (element == this._reloadDocument.getElement(this._schemaElement)) {
            this._element = element;
            this.setValue(this._element.getText());
        } else {
            for (Element child : element.getChildren()) {
                this.addElement(child);
            }
        }
    }

    @Override
    public void elementChanged(ReloadDocumentListenerEvent event) {
        if (event.getSource() == this) {
            return;
        }
        Element element = event.getElement();
        if (element == this._element) {
            this.setValue(this._element.getText());
        }
    }

    @Override
    public void elementRemoved(ReloadDocumentListenerEvent event) {
        if (event.getSource() == this) {
            return;
        }
        Element element = event.getElement();
        if (this._element != null && (element == this._element || this._element.isAncestor(element))) {
            this._element = this._reloadDocument.getElement(this._schemaElement);
            if (this._element == null) {
                this.setValue("");
            } else {
                this.setValue(this._element.getText());
            }
        }
    }

    @Override
    public void documentSaved(ReloadSchemaDocument doc) {
    }
}

