/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.formview;

import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.MetadataHelperProfile;
import uk.ac.reload.editor.metadata.MetadataProfileElement;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.editor.metadata.formview.DateTimeMetadataTextField;
import uk.ac.reload.editor.metadata.formview.DurationMetadataTextField;
import uk.ac.reload.editor.metadata.formview.MetadataComboBox;
import uk.ac.reload.editor.metadata.formview.MetadataField;
import uk.ac.reload.editor.metadata.formview.MetadataTextField;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;
import uk.ac.reload.moonunit.schema.ReloadSchemaNode;
import uk.ac.reload.moonunit.schema.ReloadVocabularyList;

public class MetadataFormModel {
    protected Metadata _metadata;
    protected MetadataSchemaController _schemaController;
    protected MetadataHelperProfile _mdProfile;
    protected MetadataHelperProfile _mdProfileShortFormSCORM2004;

    public void setDocument(Metadata metadata) {
        this._metadata = metadata;
        this._schemaController = (MetadataSchemaController)this._metadata.getReloadSchemaController();
        this._mdProfile = (MetadataHelperProfile)this._schemaController.getReloadHelperProfile();
    }

    public void setSCORM2004Document(Metadata metadata) {
        this._metadata = metadata;
        this._schemaController = (MetadataSchemaController)this._metadata.getReloadSchemaController();
        this._mdProfileShortFormSCORM2004 = (MetadataHelperProfile)this._schemaController.getReloadSCORM2004HelperProfile();
    }

    public MetadataProfileElement getRootElement() {
        return this._mdProfile.getRootElement();
    }

    public MetadataProfileElement getSCORM2004RootElement() {
        return this._mdProfileShortFormSCORM2004.getRootElement();
    }

    public MetadataField createWidget(MetadataProfileElement profileElement) {
        ReloadSchemaNode schemaNode = this._schemaController.getReloadSchemaNode(profileElement.getDomPath());
        if (schemaNode instanceof ReloadSchemaElement) {
            return this.createElementWidget((ReloadSchemaElement)schemaNode);
        }
        return null;
    }

    protected MetadataField createElementWidget(ReloadSchemaElement schemaElement) {
        ReloadVocabularyList rvList = this._schemaController.getVocabularyList(schemaElement);
        if (rvList != null) {
            return new MetadataComboBox(this._metadata, schemaElement, rvList);
        }
        if (schemaElement.getName().equalsIgnoreCase("duration")) {
            return new DurationMetadataTextField(this._metadata, schemaElement);
        }
        if (schemaElement.getName().equalsIgnoreCase("dateTime")) {
            return new DateTimeMetadataTextField(this._metadata, schemaElement);
        }
        return new MetadataTextField(this._metadata, schemaElement);
    }
}

