/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.formview;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.MetadataEditor;
import uk.ac.reload.editor.metadata.MetadataProfileElement;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.editor.metadata.formview.ClassificationFormView;
import uk.ac.reload.editor.metadata.formview.ClassificationView;
import uk.ac.reload.editor.metadata.formview.MetadataField;
import uk.ac.reload.editor.metadata.formview.MetadataFormModel;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.dom.DomPath;

public class MetadataFormPanel
extends JPanel {
    private final int INDENT = 15;
    protected MetadataFormModel _mdFormModel;
    protected Vector _fields = new Vector();
    protected ArrayList<ClassificationView> mViews = new ArrayList();
    protected ArrayList<ExtraTextField> mTextFields = new ArrayList();

    public void SaveClassificationData() {
        for (ClassificationView view : this.mViews) {
            view.Save();
        }
        this.SaveExtraTextFields();
    }

    private void SaveExtraTextFields() {
        for (ExtraTextField field : this.mTextFields) {
            field.Save();
        }
    }

    public MetadataFormPanel(MetadataEditor mdEditor) {
        this.setLayout(new FlowLayout(0));
        this._mdFormModel = new MetadataFormModel();
    }

    public void setDocument(Metadata metadata) {
        this.destroy();
        this.removeAll();
        this._mdFormModel.setDocument(metadata);
        MetadataProfileElement rootElement = this._mdFormModel.getRootElement();
        this.add(new GroupPanel(rootElement));
        this.revalidate();
    }

    private void createADLRClassifications(JPanel panel) {
        for (int i = 0; i < 7; ++i) {
            ClassificationFormView view = new ClassificationFormView(i, this._mdFormModel);
            this.mViews.add(view);
            panel.add(view);
        }
    }

    public void setSCORM2004Document(Metadata metadata) {
        this.destroy();
        this.removeAll();
        this._mdFormModel.setSCORM2004Document(metadata);
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout(new BoxLayout(tempPanel, 1));
        JPanel tempPanel2 = new JPanel(new FlowLayout(0));
        MetadataProfileElement rootElement = this._mdFormModel.getSCORM2004RootElement();
        tempPanel2.add(new GroupPanel(rootElement));
        tempPanel.add(tempPanel2);
        this.createADLRClassifications(tempPanel);
        this.add(tempPanel);
        this.revalidate();
    }

    public void destroy() {
        for (int i = 0; i < this._fields.size(); ++i) {
            MetadataField mdField = (MetadataField)this._fields.get(i);
            mdField.destroy();
        }
        for (ClassificationView view : this.mViews) {
            view.Save();
        }
        this.SaveExtraTextFields();
        this.mTextFields.clear();
        this._fields.clear();
    }

    class GroupPanel
    extends JPanel {
        protected GridBagConstraints constraints;

        public GroupPanel(MetadataProfileElement profileElement) {
            this.setLayout(new GridBagLayout());
            this.constraints = new GridBagConstraints();
            this.constraints.insets = new Insets(0, 15, 5, 0);
            this.constraints.gridx = 0;
            this.constraints.gridy = 0;
            this.constraints.weightx = 1.0;
            this.constraints.weighty = 0.0;
            this.constraints.fill = 2;
            this.constraints.anchor = 17;
            MetadataProfileElement[] children = null;
            this.addGroupLabel(profileElement);
            String version = ((MetadataSchemaController)MetadataFormPanel.this._mdFormModel._metadata.getReloadSchemaController()).getMetadataVersion();
            children = profileElement.getChildren();
            for (int i = 0; i < children.length; ++i) {
                MetadataProfileElement child = children[i];
                if (child.isGroup()) {
                    if (child.getName().contains("Health") && version.equals(IMSDocumentHandler.LOM_10)) continue;
                    this.constraints.gridx = 0;
                    this.constraints.gridwidth = 2;
                    this.constraints.weightx = 1.0;
                    this.constraints.fill = 2;
                    this.add((Component)new GroupPanel(child), this.constraints);
                    ++this.constraints.gridy;
                    continue;
                }
                if (child != null && child.getDomPath().getElementsPart().contains(IMSDocumentHandler.HEALTHCARE_LOM_NAMESPACE_PREFIX + ":") && version.equals(IMSDocumentHandler.LOM_10)) continue;
                this.addField(child);
            }
        }

        protected void addField(MetadataProfileElement profileElement) {
            this.constraints.fill = 0;
            MetadataField mdField = MetadataFormPanel.this._mdFormModel.createWidget(profileElement);
            if (mdField != null) {
                JLabel l = new JLabel(profileElement.getName());
                l.setBorder(new EmptyBorder(0, 15, 0, 0));
                this.constraints.gridx = 0;
                this.constraints.gridwidth = 1;
                this.constraints.weightx = 0.0;
                this.add((Component)l, this.constraints);
                MetadataFormPanel.this._fields.add(mdField);
                this.constraints.gridx = 1;
                this.add(mdField.getComponent(), this.constraints);
                ++this.constraints.gridy;
            } else if (profileElement.getDomPath().getPath().contains(IMSDocumentHandler.HEALTHCARE_LOM_ADDRESS_NAMESPACE_PREFIX + ":")) {
                JLabel l = new JLabel(profileElement.getName());
                l.setBorder(new EmptyBorder(0, 15, 0, 0));
                this.constraints.gridx = 0;
                this.constraints.gridwidth = 1;
                this.constraints.weightx = 0.0;
                this.add((Component)l, this.constraints);
                ExtraTextField field = new ExtraTextField(profileElement);
                this.constraints.gridx = 1;
                MetadataFormPanel.this.mTextFields.add(field);
                this.add((Component)field, this.constraints);
                ++this.constraints.gridy;
            }
        }

        protected void addGroupLabel(MetadataProfileElement profileElement) {
            this.constraints.fill = 2;
            this.constraints.gridwidth = 2;
            this.constraints.gridx = 0;
            Color color = Color.black;
            if (profileElement.getParent() == null) {
                color = Color.blue;
            } else if (profileElement.getParent().getParent() == null) {
                color = Color.blue;
            }
            JLabel label = new JLabel(profileElement.getName());
            label.setOpaque(true);
            label.setBackground(Color.lightGray);
            label.setForeground(color);
            label.setBorder(new EmptyBorder(0, 3, 0, 0));
            this.add((Component)label, this.constraints);
            ++this.constraints.gridy;
        }
    }

    public class ExtraTextField
    extends JPanel {
        private JTextField mText;
        private MetadataProfileElement mProfileElement;

        public ExtraTextField(MetadataProfileElement profile) {
            this.mProfileElement = profile;
            this.mText = new JTextField();
            this.mText.setBorder(new EmptyBorder(0, 15, 0, 0));
            this.mText.setColumns(50);
            String[] domPathParts = this.mProfileElement.getDomPath().getPath().split(DomPath.XMLPATHSEPARATOR);
            Metadata meta = MetadataFormPanel.this._mdFormModel._metadata;
            Element element = meta.getDocument().getRootElement();
            if (element.getName().equals("manifest")) {
                element = element.getChild("metadata");
            }
            for (String attr : domPathParts) {
                if (attr.contains(":")) {
                    String[] pathParts = attr.split(":");
                    String uri = "";
                    if (pathParts[0].equals(IMSDocumentHandler.HEALTHCARE_LOM_ADDRESS_NAMESPACE_PREFIX)) {
                        uri = IMSDocumentHandler.HEALTHCARE_LOM_ADDRESS_NAMESPACE_URI_10;
                    } else if (pathParts[0].equals(IMSDocumentHandler.HEALTHCARE_LOM_NAMESPACE_PREFIX)) {
                        uri = IMSDocumentHandler.HEALTHCARE_LOM_NAMESPACE_URI_10;
                    }
                    Namespace ns = Namespace.getNamespace(pathParts[0], uri);
                    element = element.getChild(pathParts[1], ns);
                    if (element != null) continue;
                    break;
                }
                if (element.getName().equals(attr)) continue;
                Element temp = element.getChild(attr);
                if (temp == null) {
                    temp = element.getChild(attr, Namespace.getNamespace(IMSDocumentHandler.LOM_NAMESPACE_PREFIX, IMSDocumentHandler.LOM_NAMESPACE_URI_10));
                }
                element = temp;
            }
            if (element != null && this.mProfileElement.getDomPath().getElementsPart().endsWith(element.getName())) {
                this.mText.setText(element.getText());
            }
            this.add(this.mText);
        }

        public void Save() {
            String[] domPathParts;
            if (this.mText.getText().length() <= 0) {
                return;
            }
            Metadata meta = MetadataFormPanel.this._mdFormModel._metadata;
            Element parent = meta.getDocument().getRootElement();
            if (parent.getName().equals("manifest")) {
                parent = parent.getChild("metadata");
            }
            Element child = null;
            for (String attr : domPathParts = this.mProfileElement.getDomPath().getPath().split(DomPath.XMLPATHSEPARATOR)) {
                Element temp = null;
                if (attr.contains(":")) {
                    String[] pathParts = attr.split(":");
                    String uri = "";
                    if (pathParts[0].equals(IMSDocumentHandler.HEALTHCARE_LOM_ADDRESS_NAMESPACE_PREFIX)) {
                        uri = IMSDocumentHandler.HEALTHCARE_LOM_ADDRESS_NAMESPACE_URI_10;
                    } else if (pathParts[0].equals(IMSDocumentHandler.HEALTHCARE_LOM_NAMESPACE_PREFIX)) {
                        uri = IMSDocumentHandler.HEALTHCARE_LOM_NAMESPACE_URI_10;
                    }
                    Namespace ns = Namespace.getNamespace(pathParts[0], uri);
                    temp = parent.getChild(pathParts[1], ns);
                    if (temp == null) {
                        temp = child = this.addElement(pathParts[1], ns, parent, meta);
                    }
                } else {
                    if (parent.getName().equals(attr)) continue;
                    temp = parent.getChild(attr);
                    if (temp == null) {
                        temp = parent.getChild(attr, Namespace.getNamespace(IMSDocumentHandler.LOM_NAMESPACE_PREFIX, IMSDocumentHandler.LOM_NAMESPACE_URI_10));
                    }
                }
                if (temp == null) break;
                parent = temp;
            }
            meta.setDirty(true);
            if (child != null) {
                child.setText(this.mText.getText());
            } else {
                parent.setText(this.mText.getText());
            }
        }

        private Element addElement(String elementTagText, Namespace targetNamespace, Element parent, Metadata metadata) {
            Element child = new Element(elementTagText, targetNamespace);
            metadata.addElement(this, parent, child, false);
            return child;
        }
    }
}

