/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.formview;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uk.ac.reload.dweezil.gui.widgets.ReloadNumberField;
import uk.ac.reload.dweezil.gui.widgets.ReloadTextArea;
import uk.ac.reload.dweezil.gui.widgets.ReloadTextField;
import uk.ac.reload.dweezil.gui.widgets.ReloadWidget;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.formview.MetadataField;
import uk.ac.reload.moonunit.schema.ReloadSchemaController;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class MetadataTextField
extends MetadataField
implements DocumentListener {
    boolean _allowNotification = true;
    protected ReloadWidget _reloadWidget;

    public MetadataTextField(Metadata metadata, ReloadSchemaElement schemaElement) {
        super(metadata, schemaElement);
        this._reloadWidget = this.getMetadataTextFieldWidget(schemaElement);
        ((JComponent)((Object)this._reloadWidget)).setBorder(null);
        this._element = metadata.getElement(this._schemaElement);
        if (this._element != null) {
            this.setValue(this._element.getText());
        }
        this._reloadWidget.addDocumentListener(this);
        metadata.addReloadDocumentListener(this);
    }

    protected ReloadWidget getMetadataTextFieldWidget(ReloadSchemaElement schemaElement) {
        if (schemaElement == null) {
            return this.getDefaultWidget();
        }
        String name = schemaElement.getName();
        ReloadWidget component = null;
        ReloadSchemaController schemaController = this._reloadDocument.getReloadSchemaController();
        String widget_type = schemaController.getWidgetType(schemaElement.getDomPath());
        if (widget_type != null) {
            if (widget_type.equals("textpane")) {
                component = new ReloadTextArea();
                ((ReloadTextArea)component).setColumns(50);
            } else if (widget_type.equals("numberfield")) {
                component = new ReloadNumberField();
                ((ReloadNumberField)component).setColumns(30);
            } else {
                component = this.getDefaultWidget();
            }
        } else {
            component = this.getDefaultWidget();
        }
        int maxLength = -1;
        String value = schemaController.getFacetValue(schemaElement, "maxLength");
        if (value != null) {
            maxLength = Integer.parseInt(value);
        }
        component.setMaxLength(maxLength);
        return component;
    }

    private ReloadWidget getDefaultWidget() {
        ReloadTextField textField = new ReloadTextField();
        textField.setColumns(50);
        return textField;
    }

    @Override
    public void destroy() {
        this._reloadWidget.removeDocumentListener(this);
        this._reloadDocument.removeReloadDocumentListener(this);
    }

    @Override
    public String getValue() {
        return this._reloadWidget.getTextValue();
    }

    @Override
    public void setValue(String value) {
        this._allowNotification = false;
        this._reloadWidget.setTextValue(value);
        this._allowNotification = true;
    }

    @Override
    public Component getComponent() {
        return (Component)((Object)this._reloadWidget);
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        if (this._allowNotification) {
            this.fireElementChanged();
        }
    }
}

