/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.tableview;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import uk.ac.reload.editor.gui.ReloadInfoPanel;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.tableview.MetadataTreeNode;
import uk.ac.reload.editor.metadata.tableview.MetadataTreeTable;
import uk.ac.reload.editor.metadata.tableview.MetadataTreeTableModel;

public class MetadataTablePanel
extends JPanel {
    protected MetadataTreeTable _treeTable;
    protected ReloadInfoPanel _infoPanel;
    private JScrollPane _scrollPane;
    private JSplitPane splitPane;
    protected Menu_Edit _editMenu;

    public MetadataTablePanel(Menu_Edit editMenu) {
        this._editMenu = editMenu;
        this.setLayout(new BorderLayout());
        this._scrollPane = new JScrollPane();
        this._scrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        this._infoPanel = new ReloadInfoPanel();
        this.splitPane = new JSplitPane(0);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setTopComponent(this._scrollPane);
        this.splitPane.setBottomComponent(this._infoPanel);
        this.add((Component)this.splitPane, "Center");
    }

    public void setDocument(Metadata metadata) {
        MetadataTreeTableModel model = new MetadataTreeTableModel(metadata);
        this._treeTable = new MetadataTreeTable(model, this._infoPanel, this._editMenu);
        this._scrollPane.setViewportView(this._treeTable);
        this._treeTable.selectNode((MetadataTreeNode)model.getRoot());
    }

    public void destroy() {
        if (this._treeTable != null) {
            this._treeTable.destroy();
        }
        if (this._infoPanel != null) {
            this._infoPanel.destroy();
        }
    }

    public void refresh() {
        this._treeTable.refresh();
    }

    public void initView() {
        this.splitPane.setDividerLocation(0.7);
        this._infoPanel.initView();
    }
}

