/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.tableview;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.treetable.ReloadTreeTable;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.menu.ReloadMenuEvent;
import uk.ac.reload.editor.ReloadEditorSchemaController;
import uk.ac.reload.editor.ReloadElementBinding;
import uk.ac.reload.editor.gui.ReloadInfoPanel;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.tableview.MetadataTreeNode;
import uk.ac.reload.editor.metadata.tableview.MetadataTreeRenderer;
import uk.ac.reload.editor.metadata.tableview.MetadataTreeTableModel;
import uk.ac.reload.moonunit.dom.ReloadDocumentClipboard;
import uk.ac.reload.moonunit.dom.ReloadDocumentListener;
import uk.ac.reload.moonunit.dom.ReloadDocumentListenerEvent;
import uk.ac.reload.moonunit.dom.ReloadSchemaDocument;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class MetadataTreeTable
extends ReloadTreeTable
implements TreeSelectionListener,
ReloadDocumentListener,
FocusListener {
    protected ReloadInfoPanel _infoPanel;
    protected JPopupMenu _popupMenu;
    protected Metadata _metadata;
    protected ReloadEditorSchemaController _schemaController;
    protected Menu_Edit _editMenu;
    protected TreePath _currentTreePath;
    protected ProxyDeleteHandler _deleteHandler;
    protected ProxyCutHandler _cutHandler;
    protected ProxyCopyHandler _copyHandler;
    protected ProxyPasteHandler _pasteHandler;
    protected ProxyMoveUpHandler _moveUpHandler;
    protected ProxyMoveDownHandler _moveDownHandler;

    public MetadataTreeTable(MetadataTreeTableModel treeTableModel, ReloadInfoPanel infoPanel, Menu_Edit editMenu) {
        super(treeTableModel);
        this._infoPanel = infoPanel;
        this._metadata = treeTableModel.getMetadata();
        this._metadata.addReloadDocumentListener(this);
        this._schemaController = (ReloadEditorSchemaController)this._metadata.getReloadSchemaController();
        this.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tcm = this.getTableHeader().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(100);
        tcm.getColumn(1).setPreferredWidth(300);
        tcm.getColumn(2).setPreferredWidth(80);
        this.setShowVerticalLines(true);
        this.setSelectionMode(0);
        this.tree.setCellRenderer(new MetadataTreeRenderer());
        this.tree.addTreeSelectionListener(this);
        this._popupMenu = new JPopupMenu();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                MetadataTreeTable.this.checkPopupTrigger(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MetadataTreeTable.this.checkPopupTrigger(e);
            }
        });
        this.addFocusListener(this);
        this._editMenu = editMenu;
        this._editMenu.remapKeyStrokes(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!e.isTemporary()) {
            this.updateMenus(this.tree.getSelectionPath());
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.clearMenus();
        }
    }

    public void destroy() {
        this._metadata.removeReloadDocumentListener(this);
        this.clearMenus();
    }

    public void refresh() {
        this.updateInfoPanel(this.tree.getSelectionPath());
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath selPath = event.getPath();
        if (selPath != this._currentTreePath) {
            this.updateMenus(selPath);
            this.updateInfoPanel(selPath);
            this._currentTreePath = selPath;
        }
    }

    protected synchronized void updateInfoPanel(TreePath selPath) {
        if (this._infoPanel != null) {
            if (selPath == null) {
                this._infoPanel.clear();
                return;
            }
            Object selectedNode = selPath.getLastPathComponent();
            if (selectedNode instanceof MetadataTreeNode) {
                MetadataTreeNode treeNode = (MetadataTreeNode)selectedNode;
                ReloadElementBinding eb = treeNode.createReloadElementBinding();
                this._infoPanel.setElement(eb);
            }
        }
    }

    protected synchronized void updateMenus(TreePath selPath) {
        this.clearMenus();
        if (selPath == null) {
            return;
        }
        Object selectedNode = selPath.getLastPathComponent();
        if (selectedNode instanceof MetadataTreeNode) {
            MetadataTreeNode treeNode = (MetadataTreeNode)selectedNode;
            Element element = treeNode.getElement();
            ReloadSchemaElement schemaElement = treeNode.getSchemaElement();
            this._cutHandler = new ProxyCutHandler(this._editMenu.actionCut, element, schemaElement);
            this._copyHandler = new ProxyCopyHandler(this._editMenu.actionCopy, element);
            this._pasteHandler = new ProxyPasteHandler(this._editMenu.actionPaste, element);
            this._deleteHandler = new ProxyDeleteHandler(this._editMenu.actionDelete, element, schemaElement);
            this._popupMenu.add(this._cutHandler.getMenuAction());
            this._popupMenu.add(this._copyHandler.getMenuAction());
            this._popupMenu.add(this._pasteHandler.getMenuAction());
            this._popupMenu.add(this._deleteHandler.getMenuAction());
            this._popupMenu.addSeparator();
            this._moveUpHandler = new ProxyMoveUpHandler(this._editMenu.actionMoveUp, element);
            this._popupMenu.add(this._moveUpHandler.getMenuAction());
            this._moveDownHandler = new ProxyMoveDownHandler(this._editMenu.actionMoveDown, element);
            this._popupMenu.add(this._moveDownHandler.getMenuAction());
            if (schemaElement != null && schemaElement.hasChildren()) {
                this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                this._popupMenu.addSeparator();
                ReloadSchemaElement[] children = schemaElement.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    ReloadSchemaElement childSchemaElement = children[i];
                    if (!((MetadataTreeTableModel)this.getTreeTableModel()).canAddNode(childSchemaElement)) continue;
                    Action_AddChildElement actionAddElement = new Action_AddChildElement(element, childSchemaElement);
                    this._popupMenu.add(actionAddElement);
                    this._editMenu.addAdditionalItem(actionAddElement);
                }
            }
        }
    }

    protected synchronized void clearMenus() {
        this._popupMenu.removeAll();
        this._editMenu.removeAdditionalItems();
        if (this._cutHandler != null) {
            this._cutHandler.clearMenu();
        }
        if (this._copyHandler != null) {
            this._copyHandler.clearMenu();
        }
        if (this._pasteHandler != null) {
            this._pasteHandler.clearMenu();
        }
        if (this._deleteHandler != null) {
            this._deleteHandler.clearMenu();
        }
        if (this._moveUpHandler != null) {
            this._moveUpHandler.clearMenu();
        }
        if (this._moveDownHandler != null) {
            this._moveDownHandler.clearMenu();
        }
    }

    protected void checkPopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger()) {
            TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            this.tree.setSelectionPath(selPath);
            this._popupMenu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void elementAdded(ReloadDocumentListenerEvent event) {
        MetadataTreeNode newNode;
        Element element = event.getElement();
        Element parent = element.getParentElement();
        DefaultMutableTreeNode parentNode = this.getNode(parent);
        if (parentNode != null && (newNode = this.addNode(parentNode, element)) != null && event.doSelect()) {
            this.selectNode(newNode);
        }
    }

    private MetadataTreeNode addNode(DefaultMutableTreeNode parentNode, Element element) {
        MetadataTreeNode newNode = null;
        int index = this.getInsertNodePosition(parentNode, element);
        if (index != -1) {
            newNode = new MetadataTreeNode(element);
            this.getTreeTableModel().insertNodeInto(newNode, parentNode, index);
            for (Element child : element.getChildren()) {
                this.addNode(newNode, child);
            }
        }
        return newNode;
    }

    protected int getInsertNodePosition(DefaultMutableTreeNode parentNode, Element element) {
        Element child;
        if (!((MetadataTreeTableModel)this.getTreeTableModel()).doShowNode(element)) {
            return -1;
        }
        int index = 0;
        List children = element.getParentElement().getChildren();
        for (int i = 0; i < children.size() && (child = (Element)children.get(i)) != element; ++i) {
            if (!((MetadataTreeTableModel)this.getTreeTableModel()).doShowNode(child)) continue;
            ++index;
        }
        if (index > parentNode.getChildCount()) {
            index = parentNode.getChildCount();
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    @Override
    public void elementRemoved(ReloadDocumentListenerEvent event) {
        Element element = event.getElement();
        DefaultMutableTreeNode nodeToDelete = this.getNode(element);
        if (nodeToDelete != null) {
            if (nodeToDelete.isNodeDescendant(this.getSelectedNode())) {
                DefaultMutableTreeNode prevNode = nodeToDelete.getPreviousSibling();
                if (prevNode == null) {
                    prevNode = (DefaultMutableTreeNode)nodeToDelete.getParent();
                }
                this.getTreeTableModel().removeNodeFromParent(nodeToDelete);
                this.selectNode(prevNode);
            } else {
                this.getTreeTableModel().removeNodeFromParent(nodeToDelete);
                this.updateMenus(this.tree.getSelectionPath());
            }
        }
    }

    @Override
    public void elementChanged(ReloadDocumentListenerEvent event) {
        final DefaultMutableTreeNode node = this.getNode(event.getElement());
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MetadataTreeTable.this.getTreeTableModel().nodeChanged(node);
                }
            });
        }
    }

    @Override
    public void documentSaved(ReloadSchemaDocument doc) {
    }

    class ProxyPasteHandler
    extends ProxyAction {
        Element element;

        public ProxyPasteHandler(MenuAction proxyMenuAction, Element element) {
            super(proxyMenuAction);
            this.element = element;
            proxyMenuAction.setEnabled(MetadataTreeTable.this._metadata.canPasteFromClipboard(element));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            if (MetadataTreeTable.this._metadata.canPasteFromClipboard(this.element)) {
                Element clipBoardElement = ReloadDocumentClipboard.getElement();
                MetadataTreeTable.this._metadata.pasteElementUndoable(MetadataTreeTable.this, clipBoardElement, this.element, false);
                MetadataTreeTable.this.updateMenus(MetadataTreeTable.this.tree.getSelectionPath());
            }
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyCopyHandler
    extends ProxyAction {
        Element element;

        public ProxyCopyHandler(MenuAction proxyMenuAction, Element element) {
            super(proxyMenuAction);
            this.element = element;
            proxyMenuAction.setEnabled(MetadataTreeTable.this._metadata.canCopyElement(element));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            ReloadDocumentClipboard.addCopiedElement(this.element);
            MetadataTreeTable.this.updateMenus(MetadataTreeTable.this.tree.getSelectionPath());
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyCutHandler
    extends ProxyAction {
        Element element;

        public ProxyCutHandler(MenuAction proxyMenuAction, Element element, ReloadSchemaElement schemaElement) {
            super(proxyMenuAction);
            this.element = element;
            proxyMenuAction.setEnabled(MetadataTreeTable.this._metadata.canCutElement(element, schemaElement));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            MetadataTreeTable.this._metadata.cutElementUndoable(MetadataTreeTable.this, this.element);
            ReloadDocumentClipboard.addCutElement(this.element);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyDeleteHandler
    extends ProxyAction {
        Element parent;
        Element element;

        public ProxyDeleteHandler(MenuAction proxyMenuAction, Element element, ReloadSchemaElement schemaElement) {
            super(proxyMenuAction);
            this.element = element;
            proxyMenuAction.setEnabled(MetadataTreeTable.this._metadata.canDeleteElement(element, schemaElement));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            MetadataTreeTable.this._metadata.deleteElementUndoable(MetadataTreeTable.this, this.element);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyMoveDownHandler
    extends ProxyAction {
        Element element;

        public ProxyMoveDownHandler(MenuAction proxyMenuAction, Element element) {
            super(proxyMenuAction);
            this.element = element;
            proxyMenuAction.setEnabled(MetadataTreeTable.this._metadata.canMoveElementDown(element));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            MetadataTreeTable.this._metadata.moveElementDown(MetadataTreeTable.this, this.element, true);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyMoveUpHandler
    extends ProxyAction {
        Element element;

        public ProxyMoveUpHandler(MenuAction proxyMenuAction, Element element) {
            super(proxyMenuAction);
            this.element = element;
            proxyMenuAction.setEnabled(MetadataTreeTable.this._metadata.canMoveElementUp(element));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            MetadataTreeTable.this._metadata.moveElementUp(MetadataTreeTable.this, this.element, true);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class Action_AddChildElement
    extends AbstractAction {
        Element parentElement;
        ReloadSchemaElement childSchemaElement;
        String name;

        public Action_AddChildElement(Element parentElement, ReloadSchemaElement childSchemaElement) {
            this.parentElement = parentElement;
            this.childSchemaElement = childSchemaElement;
            this.name = MetadataTreeTable.this._schemaController.getElementFriendlyName(childSchemaElement.getDomPath());
            if (this.name == null) {
                this.name = childSchemaElement.getName();
            }
            this.putValue("Name", "Add " + this.name);
            this.putValue("SmallIcon", MetadataTreeTable.this._schemaController.getLeafIcon(childSchemaElement));
            this.setEnabled(MetadataTreeTable.this._metadata.canAddElement(parentElement, childSchemaElement));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetadataTreeTable.this._metadata.addElementBySchemaUndoable(MetadataTreeTable.this, this.parentElement, this.childSchemaElement, true);
        }
    }
}

