/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.tableview;

import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.gui.treetable.ReloadTreeTableModel;
import uk.ac.reload.dweezil.gui.treetable.TreeTableModel;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.tableview.MetadataTreeNode;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class MetadataTreeTableModel
extends ReloadTreeTableModel {
    protected static Class[] cTypes = new Class[]{TreeTableModel.class, String.class, String.class};
    protected static String[] cNames = new String[]{"Name", "Value", "Attr"};
    protected Metadata _metadata;

    public MetadataTreeTableModel(Metadata metadata) {
        this._metadata = metadata;
        this.root = new MetadataTreeNode(metadata);
        this.buildChildren((MetadataTreeNode)this.root);
    }

    public void buildChildren(MetadataTreeNode node) {
        for (Element child : node.getElement().getChildren()) {
            if (!this.doShowNode(child)) continue;
            MetadataTreeNode newNode = new MetadataTreeNode(child);
            node.add(newNode);
            this.buildChildren(newNode);
        }
    }

    protected boolean doShowNode(Element element) {
        return this.doShowNode(element.getName(), element.getNamespace());
    }

    protected boolean doShowNode(ReloadSchemaElement schemaElement) {
        return this.doShowNode(schemaElement.getName(), schemaElement.getNamespace());
    }

    protected boolean doShowNode(String elementName, Namespace ns) {
        return true;
    }

    protected boolean canAddNode(Element element) {
        return this.canAddNode(element.getName(), element.getNamespace());
    }

    protected boolean canAddNode(ReloadSchemaElement schemaElement) {
        return this.canAddNode(schemaElement.getName(), schemaElement.getNamespace());
    }

    protected boolean canAddNode(String elementName, Namespace ns) {
        return this.doShowNode(elementName, ns);
    }

    public Metadata getMetadata() {
        return this._metadata;
    }

    @Override
    public int getChildCount(Object parent) {
        MetadataTreeNode elementNode = (MetadataTreeNode)parent;
        return elementNode.getChildCount();
    }

    @Override
    public Object getChild(Object parent, int index) {
        MetadataTreeNode elementNode = (MetadataTreeNode)parent;
        return elementNode.getChildAt(index);
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
    }

    @Override
    public Object getValueAt(Object node, int column) {
        MetadataTreeNode elementNode = (MetadataTreeNode)node;
        switch (column) {
            case 1: {
                return elementNode.getElement().getText();
            }
            case 2: {
                List list = elementNode.getElement().getAttributes();
                if (!list.isEmpty()) {
                    Attribute att = (Attribute)list.get(0);
                    return att.getValue();
                }
                return "";
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        MetadataTreeNode elementNode = (MetadataTreeNode)node;
        switch (column) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    @Override
    public Class getColumnClass(int column) {
        return cTypes[column];
    }

    @Override
    public int getColumnCount() {
        return cNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return cNames[column];
    }
}

