/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.prefs;

import java.awt.Component;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import uk.ac.reload.dweezil.gui.ReloadComboBox;
import uk.ac.reload.dweezil.gui.layout.XYConstraints;
import uk.ac.reload.dweezil.gui.layout.XYLayout;
import uk.ac.reload.dweezil.prefs.PrefsPanel;
import uk.ac.reload.dweezil.prefs.UserPrefs;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.contentpackaging.ContentPackageHelperProfile;
import uk.ac.reload.editor.contentpackaging.SCORM1_3HelperProfile;

public class CP_PrefsPanel
extends PrefsPanel {
    protected JCheckBox _checkbox_hideResources;
    protected JCheckBox _checkbox_hideSCORM;
    protected ReloadComboBox _profileCPCombobox;
    protected ReloadComboBox _profileSCORMCombobox;

    public CP_PrefsPanel() {
        this.setLayout(new XYLayout());
        this.constructFields();
    }

    private void constructFields() {
        int x = 5;
        int y = 10;
        this._checkbox_hideResources = new JCheckBox("Hide Resources node (effective the next time you open a Manifest)");
        this.add((Component)this._checkbox_hideResources, new XYConstraints(x, y, 0, 20));
        this._checkbox_hideSCORM = new JCheckBox("Hide SCORM nodes (effective the next time you open a Manifest)");
        this.add((Component)this._checkbox_hideSCORM, new XYConstraints(x, y += 20, 0, 20));
        x = 10;
        JLabel label = new JLabel("Default IMS Profile:");
        this.add((Component)label, new XYConstraints(x, (y += 30) + 2, 0, 0));
        this._profileCPCombobox = new ReloadComboBox(false);
        this.add((Component)this._profileCPCombobox, new XYConstraints(x += 120, y, 300, 22));
        Object[] cp_profiles = ContentPackageHelperProfile.getContentPackageHelperProfiles();
        this._profileCPCombobox.setItems(cp_profiles);
        x = 10;
        label = new JLabel("Default SCORM Profile:");
        this.add((Component)label, new XYConstraints(x, (y += 30) + 2, 0, 0));
        this._profileSCORMCombobox = new ReloadComboBox(false);
        this.add((Component)this._profileSCORMCombobox, new XYConstraints(x += 120, y, 300, 22));
        Object[] scorm_profiles = SCORM1_3HelperProfile.getSCORM1_3HelperProfiles();
        this._profileSCORMCombobox.setItems(scorm_profiles);
        y += 20;
    }

    @Override
    public void saveToUserPrefs(UserPrefs prefs) {
        prefs.putBooleanValue("hide_resources", this._checkbox_hideResources.isSelected());
        prefs.putBooleanValue("hide_scorm", this._checkbox_hideSCORM.isSelected());
        ContentPackageHelperProfile cp_profile = (ContentPackageHelperProfile)this._profileCPCombobox.getSelectedItem();
        prefs.putValue("default_cpprofile", cp_profile.getFile().getName());
        SCORM1_3HelperProfile scorm_profile = (SCORM1_3HelperProfile)this._profileSCORMCombobox.getSelectedItem();
        prefs.putValue("default_scormprofile", scorm_profile.getFile().getName());
    }

    @Override
    public void setFields(UserPrefs prefs) {
        ContentPackageHelperProfile profile;
        File file;
        this._checkbox_hideResources.setSelected(prefs.getBooleanValue("hide_resources"));
        this._checkbox_hideSCORM.setSelected(prefs.getBooleanValue("hide_scorm"));
        String fileName = prefs.getValue("default_cpprofile");
        if (fileName != null) {
            file = new File(ReloadEditorDocumentHandler.folderCPProfile, fileName);
            try {
                profile = ContentPackageHelperProfile.getContentPackageProfile(file);
                if (profile != null) {
                    this._profileCPCombobox.setSelectedItem(profile);
                }
            }
            catch (ReloadEditorException ex) {
                // empty catch block
            }
        }
        if ((fileName = prefs.getValue("default_scormprofile")) != null) {
            file = new File(ReloadEditorDocumentHandler.folderSCORM1_3Profile, fileName);
            try {
                profile = SCORM1_3HelperProfile.getSCORM1_3Profile(file);
                if (profile != null) {
                    this._profileSCORMCombobox.setSelectedItem(profile);
                }
            }
            catch (ReloadEditorException ex) {
                // empty catch block
            }
        }
    }
}

