/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.prefs;

import java.awt.Component;
import java.io.File;
import javax.swing.JLabel;
import uk.ac.reload.dweezil.gui.ReloadComboBox;
import uk.ac.reload.dweezil.gui.layout.XYConstraints;
import uk.ac.reload.dweezil.gui.layout.XYLayout;
import uk.ac.reload.dweezil.prefs.PrefsPanel;
import uk.ac.reload.dweezil.prefs.UserPrefs;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.metadata.MetadataHelperProfile;

public class MD_PrefsPanel
extends PrefsPanel {
    protected ReloadComboBox _profileCombobox;

    public MD_PrefsPanel() {
        this.setLayout(new XYLayout());
        this.constructFields();
    }

    private void constructFields() {
        int x = 10;
        int y = 10;
        JLabel label = new JLabel("Default Profile:");
        this.add((Component)label, new XYConstraints(x, y + 2, 0, 0));
        this._profileCombobox = new ReloadComboBox(false);
        this.add((Component)this._profileCombobox, new XYConstraints(x += 110, y, 300, 22));
        Object[] profiles = MetadataHelperProfile.getMetadataHelperProfiles();
        this._profileCombobox.setItems(profiles);
    }

    @Override
    public void saveToUserPrefs(UserPrefs prefs) {
        MetadataHelperProfile profile = (MetadataHelperProfile)this._profileCombobox.getSelectedItem();
        prefs.putValue("default_mdprofile", profile.getFile().getName());
    }

    @Override
    public void setFields(UserPrefs prefs) {
        String fileName = prefs.getValue("default_mdprofile");
        if (fileName != null) {
            File file = new File(ReloadEditorDocumentHandler.folderMDProfile, fileName);
            try {
                MetadataHelperProfile profile = MetadataHelperProfile.getMetadataProfile(file);
                if (profile != null) {
                    this._profileCombobox.setSelectedItem(profile);
                }
            }
            catch (ReloadEditorException ex) {
                // empty catch block
            }
        }
    }
}

