/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.prefs;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import uk.ac.reload.dweezil.prefs.UserPrefs;

public class ReloadEditorPrefs
extends UserPrefs {
    public static final String GENERAL_PREFS_DEFAULT_FOLDER = "default_folder";
    public static final String GENERAL_PREFS_LF = "look_and_feel";
    public static final String GENERAL_HISTORY = "history";
    public static final String CP_HIDE_RESOURCES = "hide_resources";
    public static final String CP_HIDE_SCORM = "hide_scorm";
    public static final String CP_DEFAULT_PROFILE = "default_cpprofile";
    public static final String SCORM_DEFAULT_PROFILE = "default_scormprofile";
    public static final String MD_DEFAULT_PROFILE = "default_mdprofile";
    public static final String USER_PREFS_FILENAME = "reload_prefs.xml";
    public static final String USER_PREFS_ELEMENTNAME = "reload_prefs";
    private static ReloadEditorPrefs _userPrefs = new ReloadEditorPrefs();

    public static ReloadEditorPrefs getInstance() {
        return _userPrefs;
    }

    @Override
    protected void setDefaultValues() {
        String value = this.getValue(CP_HIDE_RESOURCES);
        if (value == null) {
            this.putBooleanValue(CP_HIDE_RESOURCES, false);
        }
        if ((value = this.getValue(CP_HIDE_SCORM)) == null) {
            this.putBooleanValue(CP_HIDE_SCORM, true);
        }
    }

    @Override
    public File getPrefsFile() {
        File reloadHome = new File(System.getProperty("user.home"), "reload");
        reloadHome.mkdirs();
        return new File(reloadHome, USER_PREFS_FILENAME);
    }

    @Override
    public String getElementRootName() {
        return USER_PREFS_ELEMENTNAME;
    }

    public String[] getFileHistory() {
        Vector<String> v = new Vector<String>();
        String val = this.getValue(GENERAL_HISTORY);
        if (val != null) {
            StringTokenizer t = new StringTokenizer(val, ";");
            while (t.hasMoreElements()) {
                String path = t.nextToken();
                v.addElement(path);
            }
        }
        Object[] vals = new String[v.size()];
        v.copyInto(vals);
        return vals;
    }

    public void addFileToHistory(File file) {
        String val = file.getPath();
        int count = 1;
        String[] history = this.getFileHistory();
        for (int i = 0; i < history.length && count < 8; ++i) {
            if (history[i].equalsIgnoreCase(file.getPath())) continue;
            val = val + ";" + history[i];
            ++count;
        }
        this.putValue(GENERAL_HISTORY, val);
    }
}

