/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.prefs.UserPrefs;
import uk.ac.reload.dweezil.util.DweezilXMLException;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.prefs.CP_PrefsPanel;
import uk.ac.reload.editor.prefs.General_PrefsPanel;
import uk.ac.reload.editor.prefs.MD_PrefsPanel;
import uk.ac.reload.editor.prefs.ReloadEditorPrefs;

public class ReloadPrefsDialog
extends JDialog {
    private General_PrefsPanel _generalPrefsPanel;
    private CP_PrefsPanel _cpPrefsPanel;
    private MD_PrefsPanel _mdPrefsPanel;
    private UserPrefs _userPrefs;

    public ReloadPrefsDialog() {
        super(ReloadEditor.getInstance(), "Preferences", true);
        this.setSize(500, 350);
        this.setLocationRelativeTo(ReloadEditor.getInstance());
        this.setResizable(false);
        this._generalPrefsPanel = new General_PrefsPanel();
        this._cpPrefsPanel = new CP_PrefsPanel();
        this._mdPrefsPanel = new MD_PrefsPanel();
        this._userPrefs = ReloadEditorPrefs.getInstance();
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab("General", ReloadUIManager.getIcon(ReloadEditor.ICON_APP16), this._generalPrefsPanel);
        tabPane.addTab("Content Packager", ReloadUIManager.getIcon(ReloadEditor.ICON_CP), this._cpPrefsPanel);
        tabPane.addTab("Metadata Editor", ReloadUIManager.getIcon(ReloadEditor.ICON_MD), this._mdPrefsPanel);
        this.getContentPane().add((Component)tabPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton btnOK = new JButton("OK");
        btnOK.addActionListener(new OKClick());
        this.getRootPane().setDefaultButton(btnOK);
        buttonPanel.add(btnOK);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new CancelClick());
        buttonPanel.add(btnCancel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)buttonPanel, "East");
        this.getContentPane().add((Component)bottomPanel, "South");
    }

    @Override
    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReloadPrefsDialog.this._generalPrefsPanel.setFields(ReloadPrefsDialog.this._userPrefs);
                ReloadPrefsDialog.this._cpPrefsPanel.setFields(ReloadPrefsDialog.this._userPrefs);
                ReloadPrefsDialog.this._mdPrefsPanel.setFields(ReloadPrefsDialog.this._userPrefs);
            }
        });
        super.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish() {
        this._generalPrefsPanel.saveToUserPrefs(this._userPrefs);
        this._cpPrefsPanel.saveToUserPrefs(this._userPrefs);
        this._mdPrefsPanel.saveToUserPrefs(this._userPrefs);
        try {
            this._userPrefs.save();
        }
        catch (DweezilXMLException ex) {
            ErrorDialogBox.showWarning(this, "Could not save Preferences: ", "Preferences", ex);
        }
        finally {
            this.dispose();
        }
    }

    private class CancelClick
    extends AbstractAction {
        private CancelClick() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReloadPrefsDialog.this.dispose();
        }
    }

    private class OKClick
    extends AbstractAction {
        private OKClick() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReloadPrefsDialog.this.finish();
        }
    }
}

