/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.schemaviewer;

import java.awt.Color;
import javax.swing.JTextPane;
import uk.ac.reload.dweezil.DweezilConstants;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.moonunit.dom.DomPath;
import uk.ac.reload.moonunit.schema.ReloadSchemaAttribute;
import uk.ac.reload.moonunit.schema.ReloadSchemaController;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;
import uk.ac.reload.moonunit.schema.ReloadVocabularyList;

public class NodeViewer
extends JTextPane
implements DweezilConstants {
    ReloadSchemaController schemaController;

    public NodeViewer(ReloadSchemaController schemaController) {
        this.setEditable(false);
        this.setCursor(ReloadUIManager.TEXT_CURSOR);
        this.schemaController = schemaController;
        this.setBackground(Color.lightGray);
    }

    public void setElement(ReloadSchemaElement schemaElement) {
        int i;
        StringBuffer sb = new StringBuffer();
        DomPath domPath = schemaElement.getDomPath();
        sb.append("Name:\t" + schemaElement.getName() + CR);
        sb.append("Friendly:\t" + this.schemaController.getElementFriendlyName(domPath) + CR);
        sb.append("Tip:\t" + this.schemaController.getElementTip(domPath) + CR);
        sb.append("Path:\t" + domPath.getPath() + CR);
        sb.append("Type:\t" + schemaElement.getTypeName() + CR);
        sb.append("Base:\t" + schemaElement.getBaseTypeName() + CR);
        sb.append("Atomic Base:\t" + schemaElement.getAtomicBaseTypeName() + CR);
        sb.append("Min:\t" + schemaElement.getMinOccurs() + CR);
        sb.append("Max:\t" + schemaElement.getMaxOccurs() + CR);
        sb.append("MaxLength:\t" + schemaElement.getFacetValue("maxLength") + CR);
        sb.append("Default:\t" + this.schemaController.getDefaultValue(schemaElement) + CR);
        ReloadVocabularyList rvList = this.schemaController.getVocabularyList(schemaElement);
        if (rvList != null) {
            String[] vocab = rvList.getList();
            sb.append("Vocabulary:\t");
            for (i = 0; i < vocab.length; ++i) {
                sb.append(vocab[i]);
                if (i >= vocab.length - 1) continue;
                sb.append(", ");
            }
            sb.append(CR);
        }
        sb.append(CR);
        if (schemaElement.hasAttributes()) {
            sb.append("Attributes" + CR);
            sb.append("----------" + CR);
            ReloadSchemaAttribute[] atts = schemaElement.getAttributes();
            for (i = 0; i < atts.length; ++i) {
                ReloadSchemaAttribute schemaAttribute = atts[i];
                domPath = schemaAttribute.getDomPath();
                sb.append("Name:\t" + schemaAttribute.getName() + CR);
                sb.append("Friendly:\t" + this.schemaController.getElementFriendlyName(domPath) + CR);
                sb.append("Tip:\t" + this.schemaController.getElementTip(domPath) + CR);
                sb.append("Path:\t" + domPath.getPath() + CR);
                sb.append("Type:\t" + schemaAttribute.getTypeName() + CR);
                sb.append("Base:\t" + schemaAttribute.getBaseTypeName() + CR);
                sb.append("Atomic Base:\t" + schemaAttribute.getAtomicBaseTypeName() + CR);
                sb.append("Use:\t" + schemaAttribute.getUse() + CR);
                sb.append("MinLength:\t" + schemaAttribute.getMinLength() + CR);
                sb.append("MaxLength:\t" + schemaAttribute.getMaxLength() + CR);
                sb.append("Default:\t" + this.schemaController.getDefaultValue(schemaAttribute) + CR);
                rvList = this.schemaController.getVocabularyList(schemaAttribute);
                if (rvList != null) {
                    String[] vocab = rvList.getList();
                    sb.append("Vocabulary:\t");
                    for (int j = 0; j < vocab.length; ++j) {
                        sb.append(vocab[j]);
                        if (j >= vocab.length - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(CR);
                }
                sb.append(CR);
            }
        }
        this.setText(sb.toString());
        this.setCaretPosition(0);
    }
}

