/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.jdom.Attribute;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.simplesequencing.ADLObjectivesView;
import uk.ac.reload.editor.simplesequencing.InnerTable;
import uk.ac.reload.editor.simplesequencing.SSTableModelListener;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingTabsPane;
import uk.ac.reload.editor.simplesequencing.TextRenderer;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSADLObjectiveTableListener
extends SSTableModelListener {
    private Object[] _tempTableOccupants;
    private JButton _addMapInfo;
    private Element _objective;
    private InnerTable innerTable;
    private Element _mapInfo;
    private ADLObjectivesView mView;

    public SSADLObjectiveTableListener(JTable tableModel, ADLObjectivesView view) {
        this._SSTableModel = tableModel;
        this.mView = view;
    }

    @Override
    public void passContentPackageEtc(ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement) {
        super.passContentPackageEtc(contentPackage, element, schemaElement);
        Element adlObjectives = this.getADLObjectivesElement();
        List children = adlObjectives.getChildren("objective", IMSDocumentHandler.ADLSEQ_NAMESPACE_13);
        for (Object obj : children) {
            Element adlObjective = (Element)obj;
            this.populateTableRow(adlObjective, adlObjective.getChild("mapInfo", IMSDocumentHandler.ADLSEQ_NAMESPACE_13));
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Element adlObjective = this.addADLObjective();
        this.populateTableRow(adlObjective, this._mapInfo);
        this.clearObjectiveData();
    }

    private void populateTableRow(Element objective, Element mapInfo) {
        this._tempTableOccupants = new Object[4];
        this._tempTableOccupants[0] = objective.getAttribute("objectiveID").getValue();
        StringBuilder mapInfoString = new StringBuilder();
        this.createMapInfoString(mapInfoString, mapInfo);
        JScrollPane scroller = this.createMapInfoScrollArea(mapInfoString.toString());
        this._tempTableOccupants[1] = scroller;
        this._deleteButton = new JButton("Delete");
        this._deleteButton.addActionListener(new SSTableModelListener.SSTableRemoveRowListener(this, objective, ((DefaultTableModel)this._SSTableModel.getModel()).getRowCount()));
        this._addMapInfo = new JButton("<html>Add<br> MapInfo</html>");
        this._addMapInfo.addActionListener(new addMapInfoActionListner(this.innerTable, objective));
        this._tempTableOccupants[this._tempTableOccupants.length - 1] = this._deleteButton;
        this._tempTableOccupants[this._tempTableOccupants.length - 2] = this._addMapInfo;
        ((DefaultTableModel)this._SSTableModel.getModel()).addRow(this._tempTableOccupants);
    }

    private JScrollPane createMapInfoScrollArea(String mapInfo) {
        this.innerTable = new InnerTable(1, 1);
        TableColumn col = this.innerTable.getColumnModel().getColumn(0);
        col.setCellRenderer(new TextRenderer());
        this.innerTable.setValueAt(mapInfo, 0, 0);
        int lineCount = 2;
        int found = mapInfo.indexOf("\n", 0);
        if (found >= 0) {
            String sub = mapInfo.substring(0, found);
            int subLen = sub.length();
            int subLineCount = (int)Math.ceil(subLen / 20);
            lineCount = subLineCount >= lineCount ? (lineCount += subLineCount + 1) : (lineCount += subLineCount);
            for (int k = 0; k < mapInfo.length(); ++k) {
                found = mapInfo.indexOf("\n", k);
                if (found < 0) continue;
                ++lineCount;
                k = found + 2;
            }
            if (lineCount * 12 > this._SSTableModel.getRowHeight()) {
                this.innerTable.setRowHeight(lineCount * 12);
            } else {
                this.innerTable.setRowHeight(this._SSTableModel.getRowHeight());
            }
        } else {
            this.innerTable.setRowHeight(this._SSTableModel.getRowHeight());
        }
        JTableHeader innerTableHeader = new JTableHeader();
        innerTableHeader.setPreferredSize(new Dimension(0, 0));
        this.innerTable.setTableHeader(innerTableHeader);
        JScrollPane scroll = new JScrollPane(this.innerTable);
        return scroll;
    }

    private void createMapInfoString(StringBuilder mapInfoString, Element mapInfo) {
        for (Object obj : mapInfo.getAttributes()) {
            Attribute atr = (Attribute)obj;
            mapInfoString.append(atr.getName());
            mapInfoString.append(": ");
            mapInfoString.append(atr.getValue());
            mapInfoString.append("\r\n");
        }
    }

    private Element getADLObjectivesElement() {
        Element adlObjectives;
        Element sequencingElement = SimpleSequencingTabsPane.findSequencingElement(this._element);
        if (sequencingElement == null) {
            sequencingElement = new Element("sequencing", IMSDocumentHandler.IMSSS_NAMESPACE_10);
            this._contentPackage.addElement(this, this._element, sequencingElement, false);
        }
        if ((adlObjectives = sequencingElement.getChild("ADLobjectives", IMSDocumentHandler.ADLSEQ_NAMESPACE_13)) == null && (adlObjectives = sequencingElement.getChild("objectives", IMSDocumentHandler.ADLSEQ_NAMESPACE_13)) == null) {
            adlObjectives = new Element("ADLobjectives", IMSDocumentHandler.ADLSEQ_NAMESPACE_13);
            this._contentPackage.addElement(this, sequencingElement, adlObjectives, false);
        }
        return adlObjectives;
    }

    private Element addADLObjective() {
        Element adlObjectives = this.getADLObjectivesElement();
        Element adlObjective = new Element("objective", IMSDocumentHandler.ADLSEQ_NAMESPACE_13);
        adlObjective.setAttribute("objectiveID", this.mView.getObjectiveId());
        this._contentPackage.addElement(this, adlObjectives, adlObjective, false);
        this._objective = adlObjective;
        this.addMapInfo(adlObjective);
        return adlObjective;
    }

    private Element addMapInfo(Element adlObjective) {
        Element mapInfo = new Element("mapInfo", IMSDocumentHandler.ADLSEQ_NAMESPACE_13);
        mapInfo.setAttribute("targetObjectiveID", this.mView.getTargetObjectiveId());
        mapInfo.setAttribute("readRawScore", Boolean.toString(this.mView.getReadRawScore()));
        mapInfo.setAttribute("readMinScore", Boolean.toString(this.mView.getReadMinScore()));
        mapInfo.setAttribute("readMaxScore", Boolean.toString(this.mView.getReadMaxScore()));
        mapInfo.setAttribute("readCompletionStatus", Boolean.toString(this.mView.getReadCompletionStatus()));
        mapInfo.setAttribute("readProgressMeasure", Boolean.toString(this.mView.getReadProgressMeasure()));
        mapInfo.setAttribute("writeRawScore", Boolean.toString(this.mView.getWriteRawScore()));
        mapInfo.setAttribute("writeMinScore", Boolean.toString(this.mView.getWriteMinScore()));
        mapInfo.setAttribute("writeMaxScore", Boolean.toString(this.mView.getWriteMaxScore()));
        mapInfo.setAttribute("writeCompletionStatus", Boolean.toString(this.mView.getWriteCompletionStatus()));
        mapInfo.setAttribute("writeProgressMeasure", Boolean.toString(this.mView.getWriteProgressMeasure()));
        this._contentPackage.addElement(this, adlObjective, mapInfo, false);
        this._mapInfo = mapInfo;
        this.clearMapInfo();
        return mapInfo;
    }

    private void clearObjectiveData() {
        this.mView.setObjectiveId("");
        this.mView.setObjectiveMapInfo(false);
        this.clearMapInfo();
    }

    private void clearMapInfo() {
        this.mView.setTargetObjectiveId("");
        this.mView.setReadRawScore(false);
        this.mView.setReadMaxScore(false);
        this.mView.setReadMinScore(false);
        this.mView.setReadCompletionStatus(false);
        this.mView.setReadProgressMeasure(false);
        this.mView.setWriteRawScore(false);
        this.mView.setWriteMaxScore(false);
        this.mView.setWriteMinScore(false);
        this.mView.setWriteCompletionStatus(false);
        this.mView.setWriteProgressMeasure(false);
    }

    private class addMapInfoActionListner
    implements ActionListener {
        private InnerTable mMapInfoString;
        private Element mObjective;
        private int mCount = 1;

        public addMapInfoActionListner(InnerTable mapInfoString, Element objective) {
            this.mMapInfoString = mapInfoString;
            this.mObjective = objective;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringBuilder mapInfoSB = new StringBuilder();
            SSADLObjectiveTableListener.this.createMapInfoString(mapInfoSB, SSADLObjectiveTableListener.this.addMapInfo(this.mObjective));
            this.mMapInfoString.setValueAt(mapInfoSB, this.mCount++, 0);
        }
    }
}

