/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.SCORM1_3SequencingEditorDialog;
import uk.ac.reload.editor.simplesequencing.ADLObjectivesView;
import uk.ac.reload.editor.simplesequencing.SSADLObjectiveTable;
import uk.ac.reload.editor.simplesequencing.SSADLObjectiveTableListener;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingTabsPane;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSADLObjectivesPanel
extends JPanel
implements ADLObjectivesView {
    public static final String OBJECTIVE = "objective";
    public static final String OBJECTIVE_I_D = "objectiveID";
    public static final String WRITE_PROGRESS_MEASURE = "writeProgressMeasure";
    public static final String WRITE_COMPLETION_STATUS = "writeCompletionStatus";
    public static final String WRITE_MAX_SCORE = "writeMaxScore";
    public static final String WRITE_MIN_SCORE = "writeMinScore";
    public static final String WRITE_RAW_SCORE = "writeRawScore";
    public static final String READ_PROGRESS_MEASURE = "readProgressMeasure";
    public static final String READ_COMPLETION_STATUS = "readCompletionStatus";
    public static final String READ_MAX_SCORE = "readMaxScore";
    public static final String READ_MIN_SCORE = "readMinScore";
    public static final String READ_RAW_SCORE = "readRawScore";
    public static final String TARGET_OBJECTIVE_I_D = "targetObjectiveID";
    public static final String MAP_INFO = "mapInfo";
    public static final String ADLOBJECTIVES = "ADLobjectives";
    private ContentPackage _contentPackage;
    private Element _element;
    private JComboBox objectiveID;
    private JTextArea targetObjectiveID;
    private JCheckBox objectiveMapInfo;
    private JCheckBox writeProgressMeasure;
    private JCheckBox writeCompletionStatus;
    private JCheckBox writeMaxScore;
    private JCheckBox writeMinScore;
    private JCheckBox writeRawScore;
    private JCheckBox readProgressMeasure;
    private JCheckBox readCompletionStatus;
    private JCheckBox readMaxScore;
    private JCheckBox readMinScore;
    private JCheckBox readRawScore;
    private JPanel panel_0 = null;
    private JLabel targetObjectiveIDLabel;
    private SSADLObjectiveTable _SSADLObjectivesTable;
    private SSADLObjectiveTableListener _SSADLObjectiveTableListener;
    public static int TABLEWIDTH = SCORM1_3SequencingEditorDialog.WIDTH - 50;
    public static int TABLEHEIGHT = SCORM1_3SequencingEditorDialog.HEIGHT - 425;
    private ReloadSchemaElement _schemaElement;
    private Namespace mIMSSequencing = Namespace.getNamespace("imsss", "http://www.imsglobal.org/xsd/imsss");

    public SSADLObjectivesPanel(ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement) {
        this._contentPackage = contentPackage;
        this._element = element;
        this._schemaElement = schemaElement;
        this.initGUI();
    }

    private void initGUI() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.panel_0 = new JPanel();
        GridBagLayout g = new GridBagLayout();
        this.panel_0.setLayout(g);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 17;
        JPanel info = new JPanel();
        JLabel introText = new JLabel("<html><font color='blue'>Each activity / item with objectives must have one and only one Primary Objective. The Primary Objective identifies the objective<br> that contributes to the Rollup associated with the activity / item. However, multiple Objectives (on Objective tab) are allowed.</font></html>");
        info.add(introText);
        this.panel_0.add((Component)info, constraints);
        ++constraints.gridy;
        ++constraints.gridy;
        constraints.insets = new Insets(0, 50, 0, 0);
        this.objectiveID = new JComboBox();
        this.populateObjectiveIds(this.objectiveID);
        JPanel panel_1_3 = new JPanel();
        constraints.insets = new Insets(0, 0, 0, 0);
        panel_1_3.add(new JLabel("Objective ID (required if mapping info)"));
        panel_1_3.add(this.objectiveID);
        this.panel_0.add((Component)panel_1_3, constraints);
        ++constraints.gridy;
        this.targetObjectiveID = new JTextArea(1, 20);
        JPanel panel_1_5 = new JPanel();
        constraints.insets = new Insets(0, 50, 0, 0);
        JScrollPane ptoidScrollPane = new JScrollPane();
        ptoidScrollPane.setPreferredSize(new Dimension(110, 20));
        ptoidScrollPane.setVerticalScrollBarPolicy(21);
        ptoidScrollPane.setHorizontalScrollBarPolicy(31);
        ptoidScrollPane.setViewportView(this.targetObjectiveID);
        this.targetObjectiveIDLabel = new JLabel("Target Objective ID, required to Map Objective Info.");
        panel_1_5.add(this.targetObjectiveIDLabel);
        panel_1_5.add(this.targetObjectiveID);
        this.panel_0.add((Component)panel_1_5, constraints);
        ++constraints.gridy;
        GridLayout gl = new GridLayout();
        gl.setColumns(4);
        gl.setRows(4);
        JPanel panel_0_1 = new JPanel(gl);
        this.writeProgressMeasure = new JCheckBox(WRITE_PROGRESS_MEASURE, false);
        panel_0_1.add(this.writeProgressMeasure);
        this.writeRawScore = new JCheckBox(WRITE_RAW_SCORE, false);
        panel_0_1.add(this.writeRawScore);
        this.readMinScore = new JCheckBox(READ_MIN_SCORE, false);
        panel_0_1.add(this.readMinScore);
        this.writeCompletionStatus = new JCheckBox(WRITE_COMPLETION_STATUS, false);
        panel_0_1.add(this.writeCompletionStatus);
        this.readProgressMeasure = new JCheckBox(READ_PROGRESS_MEASURE, false);
        panel_0_1.add(this.readProgressMeasure);
        this.readRawScore = new JCheckBox(READ_RAW_SCORE, false);
        panel_0_1.add(this.readRawScore);
        this.writeMaxScore = new JCheckBox(WRITE_MAX_SCORE, false);
        panel_0_1.add(this.writeMaxScore);
        this.readCompletionStatus = new JCheckBox(READ_COMPLETION_STATUS, false);
        panel_0_1.add(this.readCompletionStatus);
        this.writeMinScore = new JCheckBox(WRITE_MIN_SCORE, false);
        panel_0_1.add(this.writeMinScore);
        this.readMaxScore = new JCheckBox(READ_MAX_SCORE, false);
        panel_0_1.add(this.readMaxScore);
        constraints.insets = new Insets(0, 0, 0, 0);
        this.panel_0.add((Component)panel_0_1, constraints);
        ++constraints.gridy;
        this._SSADLObjectivesTable = new SSADLObjectiveTable(TABLEWIDTH, TABLEHEIGHT);
        JScrollPane tableScrollPane = new JScrollPane(this._SSADLObjectivesTable);
        tableScrollPane.setPreferredSize(new Dimension(TABLEWIDTH, TABLEHEIGHT));
        JPanel buttonPanel = new JPanel();
        JButton addButton = new JButton("Add Objective");
        this._SSADLObjectiveTableListener = new SSADLObjectiveTableListener(this._SSADLObjectivesTable, this);
        this._SSADLObjectiveTableListener.passContentPackageEtc(this._contentPackage, this._element, this._schemaElement);
        addButton.addActionListener(this._SSADLObjectiveTableListener);
        buttonPanel.add(addButton);
        buttonPanel.add(new JLabel("ADL Objectives applied to the selected item or aggregation are displayed in the table below."));
        this.panel_0.add((Component)buttonPanel, constraints);
        ++constraints.gridy;
        this.panel_0.add((Component)tableScrollPane, constraints);
        this.add(this.panel_0);
    }

    private void populateObjectiveIds(JComboBox field) {
        Element sequence = SimpleSequencingTabsPane.findSequencingElement(this._element);
        if (sequence == null) {
            return;
        }
        Element objectives = sequence.getChild("objectives", this.mIMSSequencing);
        if (objectives == null) {
            return;
        }
        List children = objectives.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (Object obj : children) {
            Element element = (Element)obj;
            field.addItem(element.getAttribute(OBJECTIVE_I_D).getValue());
        }
    }

    @Override
    public String getObjectiveId() {
        return this.objectiveID.getSelectedItem().toString();
    }

    @Override
    public boolean getObjectiveMapInfo() {
        return this.objectiveMapInfo.isSelected();
    }

    @Override
    public boolean getReadCompletionStatus() {
        return this.readCompletionStatus.isSelected();
    }

    @Override
    public boolean getReadMaxScore() {
        return this.readMaxScore.isSelected();
    }

    @Override
    public boolean getReadMinScore() {
        return this.readMinScore.isSelected();
    }

    @Override
    public boolean getReadProgressMeasure() {
        return this.readProgressMeasure.isSelected();
    }

    @Override
    public boolean getReadRawScore() {
        return this.readRawScore.isSelected();
    }

    @Override
    public String getTargetObjectiveId() {
        return this.targetObjectiveID.getText();
    }

    @Override
    public boolean getWriteCompletionStatus() {
        return this.writeCompletionStatus.isSelected();
    }

    @Override
    public boolean getWriteMaxScore() {
        return this.writeMaxScore.isSelected();
    }

    @Override
    public boolean getWriteProgressMeasure() {
        return this.writeProgressMeasure.isSelected();
    }

    @Override
    public boolean getWriteRawScore() {
        return this.writeRawScore.isSelected();
    }

    @Override
    public void setObjectiveId(String objectiveId) {
        this.objectiveID.setSelectedItem(objectiveId);
    }

    @Override
    public void setObjectiveMapInfo(boolean objectiveMapInfo) {
        this.objectiveMapInfo.setSelected(objectiveMapInfo);
    }

    @Override
    public void setReadCompletionStatus(boolean readCompletionStatus) {
        this.readCompletionStatus.setSelected(readCompletionStatus);
    }

    @Override
    public void setReadMaxScore(boolean readMaxScore) {
        this.readMaxScore.setSelected(readMaxScore);
    }

    @Override
    public void setReadMinScore(boolean readMinScore) {
        this.readMinScore.setSelected(readMinScore);
    }

    @Override
    public void setReadProgressMeasure(boolean readProgressMeasure) {
        this.readProgressMeasure.setSelected(readProgressMeasure);
    }

    @Override
    public void setReadRawScore(boolean readRawScore) {
        this.readRawScore.setSelected(readRawScore);
    }

    @Override
    public void setTargetObjectiveId(String objectiveId) {
        this.targetObjectiveID.setText(objectiveId);
    }

    @Override
    public void setWriteCompletionStatus(boolean writeCompletionStatus) {
        this.writeCompletionStatus.setSelected(writeCompletionStatus);
    }

    @Override
    public void setWriteMaxScore(boolean writeMaxScore) {
        this.writeMaxScore.setSelected(writeMaxScore);
    }

    @Override
    public void setWriteProgressMeasure(boolean writeProgressMeasure) {
        this.writeProgressMeasure.setSelected(writeProgressMeasure);
    }

    @Override
    public void setWriteRawScore(boolean writeRawScore) {
        this.writeRawScore.setSelected(writeRawScore);
    }

    @Override
    public boolean getWriteMinScore() {
        return this.writeMinScore.isSelected();
    }

    @Override
    public void setWriteMinScore(boolean readMinScore) {
        this.writeMinScore.setSelected(readMinScore);
    }
}

