/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.simplesequencing.InnerTable;
import uk.ac.reload.editor.simplesequencing.SSTableModel;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingSchemaController;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSAddConditionListener
extends AbstractAction {
    private InnerTable _innerTable;
    private SSTableModel _outerTable;
    private ContentPackage _contentPackage;
    private Element _parentElement;
    private ReloadSchemaElement _schemaElement;
    private JList _conditions;
    private JTextArea _referencedObjective;
    private JTextArea _measureThreshold;
    private int count;
    private String RO;
    private String MT;
    private String _conditionValues;
    private Object[] _manifestConditions;

    public SSAddConditionListener() {
    }

    public SSAddConditionListener(InnerTable table, SSTableModel outerTable, JList conditions, JTextArea referencedObj, JTextArea measureThreshold, ContentPackage contentPackage, Element parentElement, ReloadSchemaElement schemaElement) {
        this._innerTable = table;
        this._outerTable = outerTable;
        this._conditions = conditions;
        this._referencedObjective = referencedObj;
        this._measureThreshold = measureThreshold;
        this._contentPackage = contentPackage;
        this._parentElement = parentElement;
        this._schemaElement = schemaElement;
        this.RO = null;
        this.MT = null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.getValidEntries()) {
            for (int k = 0; k < this._manifestConditions.length; ++k) {
                Element _condition = new Element("ruleCondition", this._schemaElement.getNamespace());
                String operatorValue = "noOp";
                String con = this._manifestConditions[k].toString();
                if (con.indexOf("not_") >= 0) {
                    operatorValue = "not";
                    this._manifestConditions[k] = con.substring(4, con.length());
                }
                _condition.setAttribute("operator", operatorValue);
                if (this.MT != null && this.MT.length() > 0) {
                    _condition.setAttribute("measureThreshold", this.MT);
                }
                if (this.RO != null && this.RO.length() > 0) {
                    _condition.setAttribute("referencedObjective", this.RO);
                }
                _condition.setAttribute("condition", this._manifestConditions[k].toString());
                this._contentPackage.addElement(this, this._parentElement, _condition, false);
            }
            this.count = this._innerTable.getRowCount() + 1;
            int row = this._innerTable.getRowCount() - 1;
            boolean emptyRowFound = false;
            if (this.count == 2 && ((String)this._innerTable.getValueAt(0, 0) == null || ((String)this._innerTable.getValueAt(0, 0)).length() < 0)) {
                this.count = 1;
                emptyRowFound = true;
            }
            if (emptyRowFound) {
                this._innerTable.setValueAt(this._conditionValues, 0, 0);
                this._innerTable.setValueAt("Referenced Objective:\n" + this.RO, 0, 1);
                this._innerTable.setValueAt("MeasureThreshold:\n" + this.MT, 0, 2);
            } else {
                ((DefaultTableModel)this._innerTable.getModel()).addRow(new Object[]{this._conditionValues, "Referenced Objective:\n" + this.RO, "MeasureThreshold:\n" + this.MT});
            }
            this._innerTable.setRowHeight(SSTableModel.ROWHEIGHT);
            if (this._outerTable != null) {
                this._outerTable.moveColumn(1, 1);
            }
        }
    }

    boolean getValidEntries() {
        block11: {
            this.RO = null;
            this.MT = null;
            try {
                this.RO = this._referencedObjective.getText().trim();
            }
            catch (NullPointerException NPE) {
                // empty catch block
            }
            try {
                this.MT = this._measureThreshold.getText().trim();
                if (this.MT == null || this.MT.length() <= 0) break block11;
                Double value = new Double(0.0);
                try {
                    value = new Double(Double.parseDouble(this.MT));
                }
                catch (NumberFormatException NFE) {
                    JOptionPane.showMessageDialog(null, "<html><b>Measure Threshold</b> is invalid. Please select a value for <b>Measure Threshold</b> that is in the range [-1, 1] then <b>Add Rule.</b></html>");
                    return false;
                }
                Double lowerLimit = new Double(-1.0);
                Double upperLimit = new Double(1.0);
                if (value.compareTo(upperLimit) > 0 || value.compareTo(lowerLimit) < 0) {
                    JOptionPane.showMessageDialog(null, "<html><b>Measure Threshold</b> is invalid. Please select a value for <b>Measure Threshold</b> that is in the range [-1, 1] then <b>Add Rule.</b></html>");
                    return false;
                }
            }
            catch (NullPointerException NPE) {
                // empty catch block
            }
        }
        Object[] selectedValues = this._conditions.getSelectedValues();
        this._conditionValues = new String();
        this._manifestConditions = new Object[selectedValues.length];
        for (int j = 0; j < selectedValues.length; ++j) {
            String conditionVal;
            this._conditionValues = this._conditionValues + selectedValues[j].toString();
            if (j != selectedValues.length - 1) {
                this._conditionValues = this._conditionValues + ", ";
            }
            if ((conditionVal = SimpleSequencingSchemaController.getFriendlyName("condition/#" + selectedValues[j].toString())) == null) {
                conditionVal = selectedValues[j].toString();
            }
            this._manifestConditions[j] = conditionVal;
        }
        if (this._conditionValues == null || this._conditionValues.length() < 3) {
            JOptionPane.showMessageDialog(null, "<html>A <b>Rule</b> requires that a <b>Condition</b> be selected. Please select a <b>Condition</b> to include, then <b>Add Rule<b>.");
            return false;
        }
        return true;
    }
}

