/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSCompletionThreshold
extends JPanel {
    private static final String PROGRESS_WEIGHT = "progressWeight";
    private static final String MIN_PROGRESS_MEASURE = "minProgressMeasure";
    private static final String COMPLETED_BY_MEASURE = "completedByMeasure";
    private static final String COMPLETION_THRESHOLD = "completionThreshold";
    private ContentPackage _contentPackage;
    private Element _element;
    private ReloadSchemaElement _schemaElement;
    private Namespace _nameSpace = Namespace.getNamespace("adlcp", "http://www.adlnet.org/xsd/adlcp_v1p3");
    private JCheckBox _completedByMeasure;
    private JTextField _minProgressMeasure;
    private JTextField _progressWeight;
    private JLabel _minProgressMeasureLabel;
    private JLabel _progressWeightLabel;
    private JLabel _completionThresholdLabel;

    public SSCompletionThreshold(ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement) {
        this.setLayout(new BoxLayout(this, 1));
        this._completionThresholdLabel = new JLabel();
        this._completionThresholdLabel.setText("ADL Completon Threshold");
        this._completionThresholdLabel.setAlignmentX(0.0f);
        this.add(this._completionThresholdLabel);
        JPanel panel = new JPanel();
        panel.setAlignmentX(0.0f);
        panel.setAlignmentY(0.0f);
        BoxLayout layout = new BoxLayout(panel, 0);
        panel.setLayout(layout);
        ActionListener eventSink = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCompletionThreshold.this.saveValues();
            }
        };
        FocusListener focusEventSink = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                SSCompletionThreshold.this.saveValues();
            }
        };
        this._contentPackage = contentPackage;
        this._element = element;
        this._schemaElement = schemaElement;
        this._completedByMeasure = new JCheckBox();
        this._completedByMeasure.setText("Completed By Measure");
        this._completedByMeasure.addActionListener(eventSink);
        panel.add(this._completedByMeasure);
        this._minProgressMeasureLabel = new JLabel();
        this._minProgressMeasureLabel.setText("Minimum Progress Measure");
        panel.add(this._minProgressMeasureLabel);
        this._minProgressMeasure = new JTextField();
        this._minProgressMeasure.addFocusListener(focusEventSink);
        panel.add(this._minProgressMeasure);
        this._progressWeightLabel = new JLabel();
        this._progressWeightLabel.setText("Progress Weight");
        panel.add(this._progressWeightLabel);
        this._progressWeight = new JTextField();
        this._progressWeight.addFocusListener(focusEventSink);
        panel.add(this._progressWeight);
        this.add(panel);
        this.populateValues();
    }

    private void populateValues() {
        Element completionThresholdElement = this.getCompletionThresholdElement();
        if (completionThresholdElement != null) {
            this._completedByMeasure.setSelected("true".equals(completionThresholdElement.getAttribute(COMPLETED_BY_MEASURE).getValue()));
            this._minProgressMeasure.setText(completionThresholdElement.getAttribute(MIN_PROGRESS_MEASURE).getValue());
            this._progressWeight.setText(completionThresholdElement.getAttribute(PROGRESS_WEIGHT).getValue());
        } else {
            this._completedByMeasure.setSelected(false);
            this._minProgressMeasure.setText("1.0");
            this._progressWeight.setText("1.0");
        }
    }

    private Element getCompletionThresholdElement() {
        return this.getCompletionThresholdElement(false);
    }

    private Element getCompletionThresholdElement(boolean shouldCreate) {
        Element completionThresholdElement = this._element.getChild(COMPLETION_THRESHOLD, this._nameSpace);
        if (completionThresholdElement == null && shouldCreate) {
            completionThresholdElement = new Element(COMPLETION_THRESHOLD, this._nameSpace);
            this._contentPackage.addElement(this, this._element, completionThresholdElement, false);
            this.writeValues(completionThresholdElement);
        }
        return completionThresholdElement;
    }

    private void saveValues() {
        this.writeValues(this.getCompletionThresholdElement(true));
    }

    private void writeValues(Element completionThresholdElement) {
        if (completionThresholdElement != null) {
            completionThresholdElement.setAttribute(COMPLETED_BY_MEASURE, Boolean.toString(this._completedByMeasure.isSelected()));
            completionThresholdElement.setAttribute(MIN_PROGRESS_MEASURE, this._minProgressMeasure.getText());
            completionThresholdElement.setAttribute(PROGRESS_WEIGHT, this._progressWeight.getText());
        }
    }
}

