/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import org.jdom.Attribute;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.SCORM1_3SchemaController;
import uk.ac.reload.editor.contentpackaging.SCORM1_3SequencingEditorDialog;
import uk.ac.reload.editor.simplesequencing.InnerTable;
import uk.ac.reload.editor.simplesequencing.SSConditionRuleTableListener;
import uk.ac.reload.editor.simplesequencing.SSRuleConditionTable;
import uk.ac.reload.editor.simplesequencing.SSTableModelListener;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingSchemaController;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSConditionRulePanel
extends JPanel {
    private SCORM1_3SchemaController _schemaController;
    private ContentPackage _contentPackage;
    private Element _element;
    private ReloadSchemaElement _schemaElement;
    private JComboBox action;
    private JComboBox condition;
    private JList condition2;
    private JComboBox trueORfalse;
    private JButton addButton;
    private JTable _SSTableModel;
    private JTextArea referencedObjective;
    private JTextArea measureThreshold;
    private GridBagConstraints constraints;
    private SSTableModelListener _SSConditionRuleTableListener;
    private SSRuleConditionTable _SSRuleConditionTable;
    private String[] preExistingValues;
    private Element _referenceElement;
    private String conditions;
    public static int TABLEWIDTH = SCORM1_3SequencingEditorDialog.WIDTH - 35;
    public static int TABLEHEIGHT = SCORM1_3SequencingEditorDialog.HEIGHT - 350;

    public SSConditionRulePanel() {
    }

    public SSConditionRulePanel(Element referenceElement, String[] conditionAction, ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement) {
        this._referenceElement = referenceElement;
        this._contentPackage = contentPackage;
        this._element = element;
        this._schemaElement = schemaElement;
        this._schemaController = (SCORM1_3SchemaController)this._contentPackage.getReloadSchemaController();
        JPanel master = new JPanel();
        JPanel panel_1 = new JPanel();
        master.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.insets = new Insets(5, 0, 5, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 17;
        JPanel panel_2 = new JPanel();
        String[] _condition = new String[]{"all", "any"};
        String[] _condition2 = new String[]{"satisfied", "not_satisfied", "objectiveStatusKnown", "not_objectiveStatusKnown", "objectiveMeasureKnown", "not_objectiveMeasureKnown", "objectiveMeasureGreaterThan", "not_objectiveMeasureGreaterThan", "objectiveMeasureLessThan", "not_objectiveMeasureLessThan", "completed", "not_completed", "activityProgressKnown", "not_activityProgressKnown", "attempted", "not_attempted", "attemptLimitExceeded", "not_attemptLimitExceeded", "timeLimitExceeded", "not_timeLimitExceeded", "outsideAvailableTimeRange", "not_outsideAvailableTimeRange", "always", "not_always"};
        for (int i = 0; i < _condition2.length; ++i) {
            String friendlyName = SimpleSequencingSchemaController.getFriendlyName("sequencingRule/#" + _condition2[i]);
            if (friendlyName == null) continue;
            _condition2[i] = friendlyName;
        }
        String[] rollupTrueOrFalse = new String[]{"true", "not true"};
        this.action = new JComboBox<String>(conditionAction);
        this.condition = new JComboBox<String>(_condition);
        this.condition2 = new JList<String>(_condition2);
        this.trueORfalse = new JComboBox<String>(rollupTrueOrFalse);
        panel_1.add(new JLabel("<html><b>Rule: &nbsp&nbsp</b></html>"));
        panel_1.add(this.action);
        panel_1.add(new JLabel(" if "));
        panel_1.add(this.condition);
        panel_1.add(new JLabel("<html> of the <font color='blue'>*conditions</font> selected below are true.</html>"));
        panel_2.add(new JLabel("<html><font color='blue'>*Conditions: </font></html>"));
        JScrollPane conditionScrollPane = new JScrollPane(this.condition2);
        conditionScrollPane.setPreferredSize(new Dimension(445, 60));
        panel_2.add(conditionScrollPane);
        JPanel panel_3 = new JPanel();
        panel_3.setLayout(new GridBagLayout());
        GridBagConstraints panel_3Constraints = new GridBagConstraints();
        panel_3Constraints.gridx = 0;
        panel_3Constraints.gridy = 0;
        panel_3Constraints.weightx = 1.0;
        panel_3Constraints.weighty = 1.0;
        panel_3Constraints.anchor = 17;
        JPanel panel_35 = new JPanel();
        panel_35.add(new JLabel("Referenced Objective: "));
        this.referencedObjective = new JTextArea();
        JScrollPane roScrollPane = new JScrollPane();
        roScrollPane.setPreferredSize(new Dimension(100, 20));
        roScrollPane.setVerticalScrollBarPolicy(21);
        roScrollPane.setHorizontalScrollBarPolicy(31);
        roScrollPane.setViewportView(this.referencedObjective);
        panel_35.add(roScrollPane);
        panel_3.add((Component)panel_35, panel_3Constraints);
        panel_3Constraints.insets = new Insets(0, 5, 0, 0);
        ++panel_3Constraints.gridy;
        panel_3.add((Component)new JLabel("<html><font color='#666666'>*Note: If a rule for an activity does not explicitly<br> reference an objective by an identifier, the rule<br> references the objective that contributes to<br> rollup for an activity by default.</font></html>"), panel_3Constraints);
        panel_2.add(panel_3);
        JPanel panel_4 = new JPanel();
        panel_4.add(new JLabel("Measure Threshold (for measure-based condition evaluations): "));
        this.measureThreshold = new JTextArea();
        JScrollPane mtScrollPane = new JScrollPane();
        mtScrollPane.setPreferredSize(new Dimension(75, 20));
        mtScrollPane.setVerticalScrollBarPolicy(21);
        mtScrollPane.setHorizontalScrollBarPolicy(31);
        mtScrollPane.setViewportView(this.measureThreshold);
        panel_4.add(mtScrollPane);
        panel_4.add(new JLabel("<html><font color='#666666'>*Note: Measure Threshold must be in range [-1, 1]</font></html>"));
        master.add((Component)panel_1, this.constraints);
        ++this.constraints.gridy;
        master.add((Component)panel_2, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridx = 0;
        master.add((Component)panel_4, this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridx = 0;
        this.constraints.anchor = 17;
        this.addButton = new JButton("Add Rule");
        this._SSRuleConditionTable = new SSRuleConditionTable(TABLEWIDTH, TABLEHEIGHT);
        JScrollPane scrollPane = new JScrollPane(this._SSRuleConditionTable);
        scrollPane.setPreferredSize(new Dimension(TABLEWIDTH, TABLEHEIGHT));
        Object[] objects = new Object[]{this.action, " if ", this.condition, " of the following conditions are true."};
        this._SSConditionRuleTableListener = new SSConditionRuleTableListener(this._referenceElement, this._SSRuleConditionTable, objects, this.referencedObjective, this.measureThreshold, this.condition2);
        this._SSConditionRuleTableListener.passContentPackageEtc(this._contentPackage, this._element, this._schemaElement);
        this.addButton.addActionListener(this._SSConditionRuleTableListener);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(new JLabel("<html>(Click to add the above rule.) &nbsp &nbsp Sequencing Rules applied to the selected item or aggregation are displayed in the table below.</html>"));
        master.add((Component)buttonPanel, this.constraints);
        ++this.constraints.gridy;
        master.add((Component)scrollPane, this.constraints);
        this.add(master);
    }

    public ContentPackage getContentPackage() {
        return this._contentPackage;
    }

    private JPanel createMultiLinedPanel(Component[] components) {
        JPanel panel_0 = new JPanel();
        for (int i = 0; i < components.length; ++i) {
            panel_0.add(components[i], this.constraints);
            this.constraints.gridy += 3;
            this.constraints.gridx = 0;
        }
        return panel_0;
    }

    public synchronized void updateTableWithPreviousValues(Element element, SSConditionRulePanel pre, SSConditionRulePanel post, SSConditionRulePanel exit) {
        String elementName = element.getName();
        if (elementName.equals("preConditionRule")) {
            Object[] values = this.buildRule(element, (SSConditionRuleTableListener)pre.getListener());
            pre.getListener().addExistingRule(element, values);
        } else if (elementName.equals("postConditionRule")) {
            Object[] values = this.buildRule(element, (SSConditionRuleTableListener)post.getListener());
            post.getListener().addExistingRule(element, values);
        } else if (elementName.equals("exitConditionRule")) {
            Object[] values = this.buildRule(element, (SSConditionRuleTableListener)exit.getListener());
            exit.getListener().addExistingRule(element, values);
        }
    }

    private SSTableModelListener getListener() {
        return this._SSConditionRuleTableListener;
    }

    public Object[] buildRule(Element element, SSConditionRuleTableListener listener) {
        this.preExistingValues = new String[6];
        InnerTable innerTable = null;
        JScrollPane jsp = null;
        Object jb = null;
        Element conditionsElement = null;
        if (listener != null && !element.getChildren().isEmpty()) {
            List children_1 = element.getChildren();
            for (int i = 0; i < children_1.size(); ++i) {
                Attribute att;
                Element childElement = (Element)children_1.get(i);
                String childName = childElement.getName();
                if (childName.equals("ruleAction") && (att = childElement.getAttribute("action")) != null) {
                    this.preExistingValues[0] = SimpleSequencingSchemaController.getFriendlyName("sequencingRule/#" + att.getValue());
                    continue;
                }
                if (!childName.equals("ruleConditions")) continue;
                conditionsElement = (Element)children_1.get(i);
                att = childElement.getAttribute("conditionCombination");
                if (att != null) {
                    this.preExistingValues[1] = att.getValue();
                    if (this.preExistingValues[1] == null) {
                        this.preExistingValues[1] = "any";
                    }
                } else {
                    this.preExistingValues[1] = "any";
                }
                List children = childElement.getChildren();
                for (int j = 0; j < children.size(); ++j) {
                    childElement = (Element)children.get(j);
                    this.preExistingValues[3] = null;
                    childName = childElement.getName();
                    this.preExistingValues[2] = null;
                    if (!childName.equals("ruleCondition")) continue;
                    att = childElement.getAttribute("operator");
                    if (att != null && (att.getValue() == null || !att.getValue().equals("noOp")) && att.getValue() != null && att.getValue().equals("not")) {
                        this.preExistingValues[2] = "not_";
                    }
                    if ((att = childElement.getAttribute("condition")) != null) {
                        String friendlyName = null;
                        friendlyName = this.preExistingValues[2] != null ? SimpleSequencingSchemaController.getFriendlyName("sequencingRule/#" + this.preExistingValues[2] + att.getValue()) : SimpleSequencingSchemaController.getFriendlyName("sequencingRule/#" + att.getValue());
                        this.preExistingValues[3] = friendlyName;
                    }
                    this.preExistingValues[4] = " ";
                    this.preExistingValues[5] = " ";
                    Attribute RO_att = childElement.getAttribute("referencedObjective");
                    Attribute MT_att = childElement.getAttribute("measureThreshold");
                    if (RO_att != null && RO_att.getValue() != null) {
                        this.preExistingValues[4] = RO_att.getValue();
                    }
                    if (MT_att != null && MT_att.getValue() != null) {
                        this.preExistingValues[5] = MT_att.getValue();
                    }
                    if (innerTable == null && this.preExistingValues[3] != null) {
                        innerTable = listener.initializeInnerTable(this.preExistingValues[3].toString(), this.preExistingValues[4], this.preExistingValues[5]);
                        continue;
                    }
                    if (innerTable == null || this.preExistingValues[3] == null) continue;
                    Object[] values = new Object[]{this.preExistingValues[3], "Referenced Objective:\n" + this.preExistingValues[4], "Measure Threshold:\n" + this.preExistingValues[5]};
                    ((DefaultTableModel)innerTable.getModel()).addRow(values);
                }
            }
            String sentence = this.preExistingValues[0] + " if " + this.preExistingValues[1] + " of the following conditions are true.";
            jsp = new JScrollPane(innerTable);
            Object[] values = new Object[]{sentence, jsp, listener.getAddConditionButton(conditionsElement)};
            return values;
        }
        return null;
    }

    public void addRule() {
    }
}

