/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.simplesequencing.InnerTable;
import uk.ac.reload.editor.simplesequencing.SSAddConditionListener;
import uk.ac.reload.editor.simplesequencing.SSTableModel;
import uk.ac.reload.editor.simplesequencing.SSTableModelListener;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingTabsPane;
import uk.ac.reload.editor.simplesequencing.TextRenderer;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSConditionRuleTableListener
extends SSTableModelListener {
    private JTextArea _referencedObjective;
    private JTextArea _measureThreshold;
    private Element _referenceElement;
    private JButton _addConditionButton;
    private InnerTable innerTable;
    private JScrollPane scroll;
    private SSAddConditionListener _addConditionListener;

    public SSConditionRuleTableListener() {
    }

    public SSConditionRuleTableListener(Element referenceElement, JTable tableModel, Object[] sentenceObjects, JTextArea referencedObjective, JTextArea measureThreshold, JList conditions) {
        super(tableModel, sentenceObjects, conditions);
        this._referenceElement = referenceElement;
        this._referencedObjective = referencedObjective;
        this._measureThreshold = measureThreshold;
    }

    @Override
    public void passContentPackageEtc(ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement) {
        super.passContentPackageEtc(contentPackage, element, schemaElement);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String MT;
        String RO;
        block13: {
            this._Rule = new Element(this._referenceElement.getName(), this._schemaElement.getNamespace());
            this._Conditions = new Element("ruleConditions", this._schemaElement.getNamespace());
            this._Action = new Element("ruleAction", this._schemaElement.getNamespace());
            this._Condition = new Element("ruleCondition", this._schemaElement.getNamespace());
            super.actionPerformed(event);
            RO = null;
            MT = null;
            try {
                RO = this._referencedObjective.getText().trim();
            }
            catch (NullPointerException NPE) {
                // empty catch block
            }
            try {
                MT = this._measureThreshold.getText().trim();
                if (MT == null || MT.length() <= 0) break block13;
                Double value = new Double(0.0);
                try {
                    value = new Double(Double.parseDouble(MT));
                }
                catch (NumberFormatException NFE) {
                    JOptionPane.showMessageDialog(null, "<html><b>Measure Threshold</b> is invalid. Please select a value for <b>Measure Threshold</b> that is in the range [-1, 1] then <b>Add Rule.</b></html>");
                    return;
                }
                Double lowerLimit = new Double(-1.0);
                Double upperLimit = new Double(1.0);
                if (value.compareTo(upperLimit) > 0 || value.compareTo(lowerLimit) < 0) {
                    JOptionPane.showMessageDialog(null, "<html><b>Measure Threshold</b> is invalid. Please select a value for <b>Measure Threshold</b> that is in the range [-1, 1] then <b>Add Rule.</b></html>");
                    return;
                }
            }
            catch (NullPointerException NPE) {
                // empty catch block
            }
        }
        if (this._conditionValues == null || this._conditionValues.length() < 3) {
            JOptionPane.showMessageDialog(null, "<html>A <b>Rule</b> requires that a <b>Condition</b> be selected. Please select a <b>Condition</b> to include, then <b>Add Rule<b>.");
        } else {
            for (int k = 0; k < this._manifestConditions.length; ++k) {
                this._Condition = new Element("ruleCondition", this._schemaElement.getNamespace());
                String operatorValue = "noOp";
                String con = this._manifestConditions[k].toString();
                if (con.indexOf("not_") >= 0) {
                    operatorValue = "not";
                    this._manifestConditions[k] = con.substring(4, con.length());
                }
                this._Condition.setAttribute("operator", operatorValue);
                if (MT != null && MT.length() > 0) {
                    this._Condition.setAttribute("measureThreshold", MT);
                }
                if (RO != null && RO.length() > 0) {
                    this._Condition.setAttribute("referencedObjective", RO);
                }
                this._Condition.setAttribute("condition", this._manifestConditions[k].toString());
                this._Conditions.addContent(this._Condition);
            }
            this.initializeInnerTable(this._conditionValues, RO, MT);
            this.scroll = new JScrollPane(this.innerTable);
            this.addRule();
            ((DefaultTableModel)this._SSTableModel.getModel()).addRow(new Object[]{this._sentence, this.scroll, this.getAddConditionButton(this._Conditions), this._deleteButton});
        }
    }

    private void addRule() {
        this._Rule.addContent(this._Conditions);
        this._Rule.addContent(this._Action);
        Element _sequencingRules = new Element("sequencingRules", this._schemaElement.getNamespace());
        Element sequencingElement = SimpleSequencingTabsPane.findSequencingElement(this._element);
        if (sequencingElement != null) {
            Element potentialParent = sequencingElement.getChild("sequencingRules", this._schemaElement.getNamespace());
            if (potentialParent != null) {
                this._contentPackage.addElement(this, potentialParent, this._Rule, false);
            } else {
                _sequencingRules.addContent(this._Rule);
                this._contentPackage.addElement(this, sequencingElement, _sequencingRules, false);
            }
        } else {
            Element _sequencing = new Element("sequencing", this._schemaElement.getNamespace());
            _sequencingRules.addContent(this._Rule);
            _sequencing.addContent(_sequencingRules);
            this._contentPackage.addElement(this, this._element, _sequencing, false);
        }
    }

    public JButton getAddConditionButton(Element element) {
        this._addConditionButton = new JButton("<html>Add<br>Condition</html>");
        this._addConditionListener = new SSAddConditionListener(this.innerTable, (SSTableModel)this._SSTableModel, this._conditions, this._referencedObjective, this._measureThreshold, this._contentPackage, element, this._schemaElement);
        this._addConditionButton.addActionListener(this._addConditionListener);
        return this._addConditionButton;
    }

    public SSAddConditionListener getAddConditionListener() {
        return this._addConditionListener;
    }

    public InnerTable initializeInnerTable(String conditionValues, String RO, String MT) {
        this.innerTable = new InnerTable(0, 0);
        ((DefaultTableModel)this.innerTable.getModel()).addColumn(" ");
        ((DefaultTableModel)this.innerTable.getModel()).addColumn(" ");
        ((DefaultTableModel)this.innerTable.getModel()).addColumn(" ");
        JTableHeader innerTableHeader = new JTableHeader();
        innerTableHeader.setPreferredSize(new Dimension(0, 0));
        this.innerTable.setTableHeader(innerTableHeader);
        TableColumn col = this.innerTable.getColumnModel().getColumn(0);
        col.setCellRenderer(new TextRenderer());
        col = this.innerTable.getColumnModel().getColumn(1);
        col.setCellRenderer(new TextRenderer());
        col = this.innerTable.getColumnModel().getColumn(2);
        col.setCellRenderer(new TextRenderer());
        ((DefaultTableModel)this.innerTable.getModel()).addRow(new Object[]{conditionValues, "Referenced Objective:\n" + RO, "MeasureThreshold:\n" + MT});
        this.innerTable.setRowHeight(this._SSTableModel.getRowHeight());
        return this.innerTable;
    }
}

