/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.jdom.Attribute;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.SCORM1_3SequencingEditorDialog;
import uk.ac.reload.editor.simplesequencing.SSControlModeTableModel;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingTabsPane;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSControlModePanel
extends JPanel {
    protected GridBagConstraints constraints;
    private ContentPackage _contentPackage;
    private Element _element;
    private ReloadSchemaElement _schemaElement;
    private JTable controlModeTableModel;
    private JButton updateButton;
    private static int TABLEWIDTH = SCORM1_3SequencingEditorDialog.WIDTH - 50;
    private static int TABLEHEIGHT = SCORM1_3SequencingEditorDialog.HEIGHT - 100;
    private static int NUMROWS = 6;

    public SSControlModePanel(ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement) {
        super(new GridLayout(1, 0));
        this._contentPackage = contentPackage;
        this._element = element;
        this._schemaElement = schemaElement;
        int height = TABLEHEIGHT;
        if (SSControlModeTableModel.ROWHEIGHT * NUMROWS + 25 < height) {
            height = SSControlModeTableModel.ROWHEIGHT * NUMROWS + 25;
        }
        this.controlModeTableModel = new SSControlModeTableModel(TABLEWIDTH, height, this);
        JScrollPane scrollPane = new JScrollPane(this.controlModeTableModel);
        scrollPane.setPreferredSize(new Dimension(TABLEWIDTH, height));
        JPanel panel_0 = new JPanel();
        panel_0.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.insets = new Insets(0, 10, 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 17;
        JPanel panel_1 = new JPanel();
        panel_1.add(new JLabel("<html><b>Present my children using the control modes selected below: </b></html>"));
        panel_0.add((Component)panel_1, this.constraints);
        ++this.constraints.gridy;
        this.constraints.anchor = 17;
        panel_0.add((Component)scrollPane, this.constraints);
        this.add(panel_0);
    }

    public synchronized void updateTableWithPreviousValues(Element element) {
        String elementName = element.getName();
        if (elementName.equals("controlMode")) {
            Attribute att = element.getAttribute("choice");
            if (att != null && att.getValue().equalsIgnoreCase("false")) {
                ((JCheckBox)this.controlModeTableModel.getValueAt(0, 2)).setSelected(false);
            }
            if ((att = element.getAttribute("choiceExit")) != null && att.getValue().equalsIgnoreCase("false")) {
                ((JCheckBox)this.controlModeTableModel.getValueAt(1, 2)).setSelected(false);
            }
            if ((att = element.getAttribute("flow")) != null && att.getValue().equalsIgnoreCase("true")) {
                ((JCheckBox)this.controlModeTableModel.getValueAt(2, 2)).setSelected(true);
            }
            if ((att = element.getAttribute("forwardOnly")) != null && att.getValue().equalsIgnoreCase("true")) {
                ((JCheckBox)this.controlModeTableModel.getValueAt(3, 2)).setSelected(true);
            }
            if ((att = element.getAttribute("useCurrentAttemptObjectiveInfo")) != null && att.getValue().equalsIgnoreCase("false")) {
                ((JCheckBox)this.controlModeTableModel.getValueAt(4, 2)).setSelected(false);
            }
            if ((att = element.getAttribute("useCurrentAttemptProgressInfo")) != null && att.getValue().equalsIgnoreCase("false")) {
                ((JCheckBox)this.controlModeTableModel.getValueAt(5, 2)).setSelected(false);
            }
        }
    }

    public void updateManifest() {
        Object[][] controlModeVals = ((SSControlModeTableModel)this.controlModeTableModel).getBooleanValues();
        String attName = null;
        boolean isChecked = true;
        Element parent = this._element;
        Element toBeReturned = null;
        Element sequencing = SimpleSequencingTabsPane.findSequencingElement(this._element);
        Element child = null;
        if (sequencing != null) {
            child = sequencing.getChild("controlMode", this._schemaElement.getNamespace());
            if (child == null) {
                child = new Element("controlMode", this._schemaElement.getNamespace());
                parent = sequencing;
                toBeReturned = child;
            }
        } else {
            sequencing = new Element("sequencing", this._schemaElement.getNamespace());
            child = new Element("controlMode", this._schemaElement.getNamespace());
            sequencing.addContent(child);
            toBeReturned = sequencing;
        }
        if (child != null) {
            for (int i = 0; i < controlModeVals.length; ++i) {
                for (int j = 0; j < controlModeVals[i].length; ++j) {
                    if (controlModeVals[i][j] instanceof String) {
                        attName = (String)controlModeVals[i][j];
                        continue;
                    }
                    if (!(controlModeVals[i][j] instanceof JCheckBox)) continue;
                    isChecked = ((JCheckBox)controlModeVals[i][j]).isSelected();
                }
                if (attName != null && attName.length() > 0 && isChecked) {
                    child.setAttribute(attName, "true");
                }
                if (attName == null || attName.length() <= 0 || isChecked) continue;
                child.setAttribute(attName, "false");
            }
            if (toBeReturned != null) {
                this._contentPackage.addElement(this, parent, toBeReturned, true);
            } else {
                this._contentPackage.changedElement(this, child);
            }
        }
    }
}

