/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.jdom.Attribute;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.simplesequencing.InnerTable;
import uk.ac.reload.editor.simplesequencing.SSADLObjectivesPanel;
import uk.ac.reload.editor.simplesequencing.SSAddMapInfoListener;
import uk.ac.reload.editor.simplesequencing.SSObjectivePanel;
import uk.ac.reload.editor.simplesequencing.SSPrimaryObjectivePanel;
import uk.ac.reload.editor.simplesequencing.SSTableModel;
import uk.ac.reload.editor.simplesequencing.TextRenderer;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSObjectivesPanel
extends JPanel {
    private ContentPackage _contentPackage;
    private Element _element;
    private ReloadSchemaElement _schemaElement;
    private SSPrimaryObjectivePanel _SSPrimaryObjectivePanel;
    private SSObjectivePanel _SSObjectivePanel;
    private SSADLObjectivesPanel _SSADLObjectivesPanel;
    private Object[] preExistingValues;
    private InnerTable innerTable;
    private ArrayList mapInfoObjects;
    private String rule;

    public SSObjectivesPanel(ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement, boolean fourthEditon) {
        this._contentPackage = contentPackage;
        this._element = element;
        this._schemaElement = schemaElement;
        this._SSPrimaryObjectivePanel = new SSPrimaryObjectivePanel(this._contentPackage, this._element, this._schemaElement);
        this._SSObjectivePanel = new SSObjectivePanel(this._contentPackage, this._element, this._schemaElement);
        if (fourthEditon) {
            this._SSADLObjectivesPanel = new SSADLObjectivesPanel(contentPackage, element, schemaElement);
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Primary Objective", this._SSPrimaryObjectivePanel);
        tabbedPane.add("Objective", this._SSObjectivePanel);
        if (fourthEditon) {
            tabbedPane.add("ADL Objective", this._SSADLObjectivesPanel);
        }
        this.add(tabbedPane);
    }

    public synchronized void updateTableWithPreviousValues(Element element) {
        this.preExistingValues = new Object[5];
        this.mapInfoObjects = new ArrayList();
        this.rule = null;
        this.buildRule(element);
        if (this.rule == null) {
            return;
        }
        if (this.rule.equals("primary")) {
            this.preExistingValues[3] = this.populateInnerTable(this._SSPrimaryObjectivePanel.getTableModel());
        } else if (this.rule.equals("secondary")) {
            this.preExistingValues[3] = this.populateInnerTable(this._SSObjectivePanel.getTableModel());
        }
        JButton _addMapInfo = new JButton("<html>&nbsp&nbsp Add<br> MapInfo</html>");
        if (this.rule.equals("primary")) {
            ArrayList primaryObjectiveArray = this._SSPrimaryObjectivePanel.getMapInfoObjects();
            _addMapInfo.addActionListener(new SSAddMapInfoListener(this.innerTable, null, primaryObjectiveArray, this._contentPackage, element, this._schemaElement));
            this.preExistingValues[4] = _addMapInfo;
            this._SSPrimaryObjectivePanel.getListener().addExistingRule(element, this.preExistingValues);
        } else if (this.rule.equals("secondary")) {
            ArrayList objectiveArray = this._SSObjectivePanel.getMapInfoObjects();
            _addMapInfo.addActionListener(new SSAddMapInfoListener(this.innerTable, null, objectiveArray, this._contentPackage, element, this._schemaElement));
            this.preExistingValues[4] = _addMapInfo;
            this._SSObjectivePanel.getListener().addExistingRule(element, this.preExistingValues);
        }
    }

    public void buildRule(Element element) {
        String elementName = element.getName();
        if ((elementName.equals("primaryObjective") || elementName.equals("objective")) && !element.getNamespacePrefix().equals(IMSDocumentHandler.ADLSEQ_NAMESPACE_PREFIX)) {
            this.rule = elementName.equals("primaryObjective") ? "primary" : "secondary";
            Attribute parentAtt = element.getAttribute("satisfiedByMeasure");
            if (parentAtt != null) {
                this.preExistingValues[1] = parentAtt.getValue();
            }
            if ((parentAtt = element.getAttribute("objectiveID")) != null) {
                this.preExistingValues[0] = parentAtt.getValue();
            }
        }
        if (element != null && !element.getChildren().isEmpty()) {
            List children = element.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Element childElement = (Element)children.get(i);
                if (childElement.getNamespacePrefix().equals(IMSDocumentHandler.ADLSEQ_NAMESPACE_PREFIX)) continue;
                String childName = childElement.getName();
                if (childName.equals("minNormalizedMeasure")) {
                    if (((String)this.preExistingValues[1]).equalsIgnoreCase("true")) {
                        this.preExistingValues[2] = childElement.getText().trim();
                    }
                } else if (childName.equals("mapInfo")) {
                    String mapInfo = null;
                    Attribute att = childElement.getAttribute("targetObjectiveID");
                    if (att == null) {
                        return;
                    }
                    mapInfo = "1. " + att.getValue() + "\n";
                    att = childElement.getAttribute("readSatisfiedStatus");
                    if (att == null || !att.getValue().equalsIgnoreCase("false")) {
                        mapInfo = mapInfo + "       Read Satisfied Status\n";
                    }
                    att = childElement.getAttribute("readNormalizedMeasure");
                    if (att == null || !att.getValue().equalsIgnoreCase("false")) {
                        mapInfo = mapInfo + "       Read Normalized Measure\n";
                    }
                    att = childElement.getAttribute("writeSatisfiedStatus");
                    if (att != null && att.getValue().equalsIgnoreCase("true")) {
                        mapInfo = mapInfo + "       Write Satisfied Status\n";
                    }
                    if ((att = childElement.getAttribute("writeNormalizedMeasure")) != null && att.getValue().equalsIgnoreCase("true")) {
                        mapInfo = mapInfo + "       Write Normalized Measure\n";
                    }
                    this.mapInfoObjects.add(mapInfo);
                }
                if (childName.equals("primaryObjective")) {
                    this.rule = "primary";
                } else if (childName.equals("object")) {
                    this.rule = "secondary";
                }
                this.buildRule(childElement);
            }
        }
    }

    private JScrollPane populateInnerTable(SSTableModel outerTable) {
        if (this.mapInfoObjects.size() <= 0) {
            String blankString = " \n";
            this.mapInfoObjects.add(blankString);
            this.innerTable = new InnerTable(1, 1);
        } else {
            this.innerTable = new InnerTable(this.mapInfoObjects.size(), 1);
        }
        TableColumn col = this.innerTable.getColumnModel().getColumn(0);
        col.setCellRenderer(new TextRenderer());
        for (int i = 0; i < this.mapInfoObjects.size(); ++i) {
            String mapInfo = (String)this.mapInfoObjects.get(i);
            this.innerTable.setValueAt(mapInfo, i, 0);
            int lineCount = 2;
            int found = mapInfo.indexOf("\n", 0);
            String sub = mapInfo.substring(0, found);
            int subLen = sub.length();
            int subLineCount = (int)Math.ceil(subLen / 20);
            lineCount = subLineCount >= lineCount ? (lineCount += subLineCount + 1) : (lineCount += subLineCount);
            for (int k = 0; k < mapInfo.length(); ++k) {
                found = mapInfo.indexOf("\n", k);
                if (found < 0) continue;
                ++lineCount;
                k = found + 2;
            }
            if (lineCount * 12 > outerTable.getRowHeight()) {
                this.innerTable.setRowHeight(i, lineCount * 12);
                continue;
            }
            this.innerTable.setRowHeight(i, outerTable.getRowHeight());
        }
        JTableHeader innerTableHeader = new JTableHeader();
        innerTableHeader.setPreferredSize(new Dimension(0, 0));
        this.innerTable.setTableHeader(innerTableHeader);
        JScrollPane scroll = new JScrollPane(this.innerTable);
        return scroll;
    }
}

