/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSPresentationPanel
extends JPanel {
    private static final String LMS_UI_HIDE_RULES_MESSAGE = "Please select the LMS UI Hide Rules you want to apply to your SCO.";
    private static final String PRESENTATION = "presentation";
    private static final String NAVIGATION_INTERFACE = "navigationInterface";
    private static final String HIDE_LMS_UI = "hideLMSUI";
    private String[] validLMSUIHideValues = new String[]{"abandon", "continue", "exit", "previous", "suspendAll", "exitAll", "abandonAll"};
    private ContentPackage _contentPackage;
    private Element _element;
    private Element _navigationInterfaceElement;
    private ReloadSchemaElement _schemaElement;
    private Namespace _nameSpace = Namespace.getNamespace("adlnav", "http://www.adlnet.org/xsd/adlnav_v1p3");

    public SSPresentationPanel(ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement) {
        this._contentPackage = contentPackage;
        this._element = element;
        this._schemaElement = schemaElement;
        if (this.IsValidPresentationElement()) {
            this.Initialize();
        }
    }

    public boolean IsValidPresentationElement() {
        return this._element.getName().equals(PRESENTATION) || ((ReloadSchemaElement)this._schemaElement.getParent()).getChild(PRESENTATION, this._nameSpace) != null;
    }

    private void createPresentationElement() {
        if (this.canAddPresentationElement()) {
            Element presentationElement = new Element(PRESENTATION, this._nameSpace);
            this._navigationInterfaceElement = new Element(NAVIGATION_INTERFACE, this._nameSpace);
            this._contentPackage.addElement(this, presentationElement, this._navigationInterfaceElement, false);
            this._contentPackage.addElement(this, this._element, presentationElement, false);
        }
    }

    private boolean canAddPresentationElement() {
        return this._element.getChild(PRESENTATION, this._nameSpace) == null;
    }

    private void Initialize() {
        this.createHideLMSUIRules();
    }

    private Element getNavigationInterfaceElement() {
        if (this._navigationInterfaceElement == null) {
            this.createPresentationElement();
            Element presentationElement = this._element.getChild(PRESENTATION, this._nameSpace);
            this._navigationInterfaceElement = presentationElement.getChild(NAVIGATION_INTERFACE, this._nameSpace);
        }
        return this._navigationInterfaceElement;
    }

    private void createHideLMSUIRules() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setAlignmentX(1.0f);
        panel.setAlignmentY(0.0f);
        hideLMSUIRuleActionListner eventSink = new hideLMSUIRuleActionListner();
        JLabel rulesInfo = new JLabel();
        rulesInfo.setText(LMS_UI_HIDE_RULES_MESSAGE);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.5;
        c.gridwidth = this.validLMSUIHideValues.length;
        panel.add((Component)rulesInfo, c);
        int count = 0;
        for (String validValue : this.validLMSUIHideValues) {
            c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = count++;
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.gridy = 1;
            JCheckBox check = new JCheckBox();
            check.setText(validValue);
            if (!this.canAddPresentationElement()) {
                check.setSelected(this.isHideLMSUIValueSelected(validValue));
            }
            check.addActionListener(eventSink);
            panel.add((Component)check, c);
        }
        this.add(panel);
    }

    private boolean isHideLMSUIValueSelected(String value) {
        Element navigationInterfaceElement = this.getNavigationInterfaceElement();
        for (Object temp : navigationInterfaceElement.getChildren()) {
            Element currentElement = (Element)temp;
            if (!currentElement.getText().equals(value)) continue;
            return true;
        }
        return false;
    }

    private class hideLMSUIRuleActionListner
    implements ActionListener {
        private hideLMSUIRuleActionListner() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Element navigationInterfaceElement = SSPresentationPanel.this.getNavigationInterfaceElement();
            JCheckBox currentCheckBox = (JCheckBox)e.getSource();
            if (currentCheckBox.isSelected()) {
                Element hideLMSUIRule = new Element(SSPresentationPanel.HIDE_LMS_UI, SSPresentationPanel.this._nameSpace);
                hideLMSUIRule.setText(currentCheckBox.getText());
                SSPresentationPanel.this._contentPackage.addElement(this, navigationInterfaceElement, hideLMSUIRule, false);
            } else {
                for (Object temp : navigationInterfaceElement.getChildren()) {
                    Element currentElement = (Element)temp;
                    if (!currentCheckBox.getText().equals(currentElement.getText())) continue;
                    SSPresentationPanel.this._contentPackage.removeElement(this, currentElement);
                    break;
                }
            }
            SSPresentationPanel.this._navigationInterfaceElement = null;
            navigationInterfaceElement = SSPresentationPanel.this.getNavigationInterfaceElement();
            if (navigationInterfaceElement.getChildren().isEmpty()) {
                SSPresentationPanel.this._contentPackage.removeElement(this, navigationInterfaceElement.getParentElement());
            }
        }
    }
}

