/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.SCORM1_3SequencingEditorDialog;
import uk.ac.reload.editor.simplesequencing.SSObjectivesTable;
import uk.ac.reload.editor.simplesequencing.SSPrimaryObjectiveTableListener;
import uk.ac.reload.editor.simplesequencing.SSTableModel;
import uk.ac.reload.editor.simplesequencing.SSTableModelListener;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSPrimaryObjectivePanel
extends JPanel {
    protected GridBagConstraints constraints;
    private ContentPackage _contentPackage;
    private Element _element;
    private ReloadSchemaElement _schemaElement;
    private JTextArea minNormalizedMeasure;
    private JTextArea primaryObjectiveID;
    private JTextArea primaryTargetObjectiveID;
    private JCheckBox primaryObjectiveSatisfiedByMeasure;
    private JCheckBox primaryObjectiveMapInfo;
    private JCheckBox readSatisfiedStatus;
    private JCheckBox readNormalizedMeasure;
    private JCheckBox writeSatisfiedStatus;
    private JCheckBox writeNormalizedMeasure;
    private JPanel panel_0 = null;
    private JLabel minNormalizedMeasureLabel;
    private JLabel targetObjectiveIDLabel;
    private SSObjectivesTable _SSObjectivesTable;
    private SSPrimaryObjectiveTableListener _SSPrimaryObjectiveTableListener;
    public static int TABLEWIDTH = SCORM1_3SequencingEditorDialog.WIDTH - 50;
    public static int TABLEHEIGHT = SCORM1_3SequencingEditorDialog.HEIGHT - 425;

    public SSPrimaryObjectivePanel(ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement) {
        this._contentPackage = contentPackage;
        this._element = element;
        this._schemaElement = schemaElement;
        this.panel_0 = new JPanel();
        GridBagLayout g = new GridBagLayout();
        this.panel_0.setLayout(g);
        this.constraints = new GridBagConstraints();
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 17;
        JPanel info = new JPanel();
        info.add(new JLabel("<html><font color='blue'>Each activity / item with objectives must have one and only one Primary Objective. The Primary Objective identifies the objective<br> that contributes to the Rollup associated with the activity / item. However, multiple Objectives (on Objective tab) are allowed.</font></html>"));
        this.panel_0.add((Component)info, this.constraints);
        ++this.constraints.gridy;
        this.primaryObjectiveSatisfiedByMeasure = new JCheckBox("Objective Satisfied by Measure", false);
        this.primaryObjectiveSatisfiedByMeasure.addActionListener(new SatisfiedByMeasureListener());
        this.panel_0.add((Component)this.primaryObjectiveSatisfiedByMeasure, this.constraints);
        ++this.constraints.gridy;
        this.minNormalizedMeasure = new JTextArea();
        this.minNormalizedMeasure.setEnabled(false);
        JPanel panel_1_2 = new JPanel();
        this.constraints.insets = new Insets(0, 50, 0, 0);
        JScrollPane mnmScrollPane = new JScrollPane();
        mnmScrollPane.setPreferredSize(new Dimension(60, 20));
        mnmScrollPane.setVerticalScrollBarPolicy(21);
        mnmScrollPane.setHorizontalScrollBarPolicy(31);
        mnmScrollPane.setViewportView(this.minNormalizedMeasure);
        panel_1_2.add(mnmScrollPane);
        this.minNormalizedMeasureLabel = new JLabel("Minimum Satisfaction Measure Normalized Between -1 and 1");
        this.minNormalizedMeasureLabel.setEnabled(false);
        panel_1_2.add(this.minNormalizedMeasureLabel);
        this.panel_0.add((Component)panel_1_2, this.constraints);
        ++this.constraints.gridy;
        this.primaryObjectiveID = new JTextArea(1, 20);
        JPanel panel_1_3 = new JPanel();
        this.constraints.insets = new Insets(0, 0, 0, 0);
        JScrollPane poidScrollPane = new JScrollPane();
        poidScrollPane.setPreferredSize(new Dimension(110, 20));
        poidScrollPane.setVerticalScrollBarPolicy(21);
        poidScrollPane.setHorizontalScrollBarPolicy(31);
        poidScrollPane.setViewportView(this.primaryObjectiveID);
        panel_1_3.add(poidScrollPane);
        panel_1_3.add(new JLabel("Objective ID (required if mapping info)"));
        this.panel_0.add((Component)panel_1_3, this.constraints);
        ++this.constraints.gridy;
        this.primaryObjectiveMapInfo = new JCheckBox("Map Objective Info. to Global Variable");
        this.primaryObjectiveMapInfo.addActionListener(new MapInfoListener());
        this.panel_0.add((Component)this.primaryObjectiveMapInfo, this.constraints);
        ++this.constraints.gridy;
        this.primaryTargetObjectiveID = new JTextArea(1, 20);
        this.primaryTargetObjectiveID.setEnabled(false);
        JPanel panel_1_5 = new JPanel();
        this.constraints.insets = new Insets(0, 50, 0, 0);
        JScrollPane ptoidScrollPane = new JScrollPane();
        ptoidScrollPane.setPreferredSize(new Dimension(110, 20));
        ptoidScrollPane.setVerticalScrollBarPolicy(21);
        ptoidScrollPane.setHorizontalScrollBarPolicy(31);
        ptoidScrollPane.setViewportView(this.primaryTargetObjectiveID);
        panel_1_5.add(ptoidScrollPane);
        this.targetObjectiveIDLabel = new JLabel("Target Objective ID, required to Map Objective Info.");
        this.targetObjectiveIDLabel.setEnabled(false);
        panel_1_5.add(this.targetObjectiveIDLabel);
        this.panel_0.add((Component)panel_1_5, this.constraints);
        ++this.constraints.gridy;
        this.readSatisfiedStatus = new JCheckBox("Read Satisfied Status", true);
        this.readSatisfiedStatus.setEnabled(false);
        this.panel_0.add((Component)this.readSatisfiedStatus, this.constraints);
        ++this.constraints.gridy;
        this.readNormalizedMeasure = new JCheckBox("Read Normalized Measure", true);
        this.readNormalizedMeasure.setEnabled(false);
        this.panel_0.add((Component)this.readNormalizedMeasure, this.constraints);
        ++this.constraints.gridy;
        this.writeSatisfiedStatus = new JCheckBox("Write Satisfied Status", false);
        this.writeSatisfiedStatus.setEnabled(false);
        this.panel_0.add((Component)this.writeSatisfiedStatus, this.constraints);
        ++this.constraints.gridy;
        this.writeNormalizedMeasure = new JCheckBox("Write Normalized Measure", false);
        this.writeNormalizedMeasure.setEnabled(false);
        this.panel_0.add((Component)this.writeNormalizedMeasure, this.constraints);
        ++this.constraints.gridy;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        ArrayList<JComponent> mapInfoObjects = new ArrayList<JComponent>();
        mapInfoObjects.add(this.primaryTargetObjectiveID);
        mapInfoObjects.add(this.readSatisfiedStatus);
        mapInfoObjects.add(this.readNormalizedMeasure);
        mapInfoObjects.add(this.writeSatisfiedStatus);
        mapInfoObjects.add(this.writeNormalizedMeasure);
        Object[] tableOccupants = new Object[]{this.primaryObjectiveID, this.primaryObjectiveSatisfiedByMeasure, this.minNormalizedMeasure, mapInfoObjects};
        this._SSObjectivesTable = new SSObjectivesTable(TABLEWIDTH, TABLEHEIGHT);
        JScrollPane tableScrollPane = new JScrollPane(this._SSObjectivesTable);
        tableScrollPane.setPreferredSize(new Dimension(TABLEWIDTH, TABLEHEIGHT));
        JPanel buttonPanel = new JPanel();
        JButton addButton = new JButton("Add Objective");
        this._SSPrimaryObjectiveTableListener = new SSPrimaryObjectiveTableListener(this._SSObjectivesTable, tableOccupants);
        this._SSPrimaryObjectiveTableListener.passContentPackageEtc(this._contentPackage, this._element, this._schemaElement);
        addButton.addActionListener(this._SSPrimaryObjectiveTableListener);
        buttonPanel.add(addButton);
        buttonPanel.add(new JLabel("Primary Objectives applied to the selected item or aggregation are displayed in the table below."));
        this.panel_0.add((Component)buttonPanel, this.constraints);
        ++this.constraints.gridy;
        this.panel_0.add((Component)tableScrollPane, this.constraints);
        this.add(this.panel_0);
    }

    public ArrayList getMapInfoObjects() {
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        result.add(this.primaryTargetObjectiveID);
        result.add(this.readSatisfiedStatus);
        result.add(this.readNormalizedMeasure);
        result.add(this.writeSatisfiedStatus);
        result.add(this.writeNormalizedMeasure);
        return result;
    }

    public SSTableModelListener getListener() {
        return this._SSPrimaryObjectiveTableListener;
    }

    public SSTableModel getTableModel() {
        return this._SSObjectivesTable;
    }

    private class MapInfoListener
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent event) {
            if (SSPrimaryObjectivePanel.this.primaryObjectiveMapInfo.isSelected()) {
                SSPrimaryObjectivePanel.this.primaryTargetObjectiveID.setEnabled(true);
                SSPrimaryObjectivePanel.this.targetObjectiveIDLabel.setEnabled(true);
                SSPrimaryObjectivePanel.this.readSatisfiedStatus.setEnabled(true);
                SSPrimaryObjectivePanel.this.readNormalizedMeasure.setEnabled(true);
                SSPrimaryObjectivePanel.this.writeSatisfiedStatus.setEnabled(true);
                SSPrimaryObjectivePanel.this.writeNormalizedMeasure.setEnabled(true);
            } else {
                SSPrimaryObjectivePanel.this.primaryTargetObjectiveID.setEnabled(false);
                SSPrimaryObjectivePanel.this.targetObjectiveIDLabel.setEnabled(false);
                SSPrimaryObjectivePanel.this.readSatisfiedStatus.setEnabled(false);
                SSPrimaryObjectivePanel.this.readNormalizedMeasure.setEnabled(false);
                SSPrimaryObjectivePanel.this.writeSatisfiedStatus.setEnabled(false);
                SSPrimaryObjectivePanel.this.writeNormalizedMeasure.setEnabled(false);
            }
        }
    }

    private class SatisfiedByMeasureListener
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent event) {
            if (SSPrimaryObjectivePanel.this.primaryObjectiveSatisfiedByMeasure.isSelected()) {
                SSPrimaryObjectivePanel.this.minNormalizedMeasure.setEnabled(true);
                SSPrimaryObjectivePanel.this.minNormalizedMeasureLabel.setEnabled(true);
            } else {
                SSPrimaryObjectivePanel.this.minNormalizedMeasure.setEnabled(false);
                SSPrimaryObjectivePanel.this.minNormalizedMeasureLabel.setEnabled(false);
            }
        }
    }
}

