/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdom.Attribute;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.widgets.ReloadObjMeasureWeightField;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.SCORM1_3SequencingEditorDialog;
import uk.ac.reload.editor.simplesequencing.SSRollupRuleConditionTable;
import uk.ac.reload.editor.simplesequencing.SSRollupTableModelListener;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingSchemaController;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingTabsPane;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSRollupPanel
extends JPanel {
    private ContentPackage _contentPackage;
    private Element _element;
    private ReloadSchemaElement _schemaElement;
    private JComboBox action;
    private JComboBox condition;
    private JComboBox childActivitySet;
    private JList condition2;
    private JComboBox children;
    private JCheckBox objectiveSatisfied;
    private JCheckBox progressCompletion;
    private ReloadObjMeasureWeightField objectiveMeasureWeight;
    private JTextArea preCondition;
    private JComboBox trueORfalse;
    private GridBagConstraints constraints;
    private JPanel panel_0;
    private JLabel newLabel;
    private JButton addButton;
    private String rule;
    private String[] preExistingValues;
    private SSRollupRuleConditionTable _SSRollupRuleConditionTable;
    public static int TABLEWIDTH = SCORM1_3SequencingEditorDialog.WIDTH - 50;
    public static int TABLEHEIGHT = (SCORM1_3SequencingEditorDialog.HEIGHT - 310) / 2;
    private SSRollupTableModelListener _SSRollupTableModelListener;
    private rulesRollUpConsiderationsPanel mRollupConsiderationPanel;

    public SSRollupPanel(ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement) {
        this._contentPackage = contentPackage;
        this._element = element;
        this._schemaElement = schemaElement;
        this.constraints = new GridBagConstraints();
        this.panel_0 = new JPanel();
        this.panel_0.setLayout(new GridBagLayout());
        this.constraints.insets = new Insets(5, 5, 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 17;
        String[] rollupAction = new String[]{"satisfied", "not satisfied", "completed", "incomplete"};
        String[] rollupCondition = new String[]{"any", "all"};
        String[] rollupChildActivitySet = new String[]{"all", "any", "none", "0"};
        String[] rollupCondition2 = new String[]{"satisfied", "not_satisfied", "objectiveStatusKnown", "not_objectiveStatusKnown", "objectiveMeasureKnown", "not_objectiveMeasureKnown", "completed", "not_completed", "activityProgressKnown", "not_activityProgressKnown", "attempted", "not_attempted", "attemptLimitExceeded", "not_attemptLimitExceeded", "timeLimitExceeded", "not_timeLimitExceeded", "outsideAvailableTimeRange", "not_outsideAvailableTimeRange"};
        for (int i = 0; i < rollupCondition2.length; ++i) {
            String friendlyName = SimpleSequencingSchemaController.getFriendlyName("rollupRule/#" + rollupCondition2[i]);
            if (friendlyName == null) continue;
            rollupCondition2[i] = friendlyName;
        }
        String[] rollupTrueOrFalse = new String[]{"true", "not true"};
        this.action = new JComboBox<String>(rollupAction);
        this.condition = new JComboBox<String>(rollupCondition);
        this.childActivitySet = new JComboBox<String>(rollupChildActivitySet);
        this.childActivitySet.setEditable(true);
        this.childActivitySet.setToolTipText("<html>You may enter a number or choose from the list.<br>To specify a percentage, enter a value in the range [0, 1].</html>");
        this.condition2 = new JList<String>(rollupCondition2);
        this.trueORfalse = new JComboBox<String>(rollupTrueOrFalse);
        this.objectiveSatisfied = new JCheckBox("Objective Satisfied", true);
        this.objectiveSatisfied.addActionListener(new RollupRulesAttListener("rollupObjectiveSatisfied"));
        this.progressCompletion = new JCheckBox("Progress Completion", true);
        this.progressCompletion.addActionListener(new RollupRulesAttListener("rollupProgressCompletion"));
        this.objectiveMeasureWeight = new ReloadObjMeasureWeightField(6);
        this.objectiveMeasureWeight.setText("1.0000");
        JPanel panel_0_1 = new JPanel();
        panel_0_1.add(new JLabel("Rollup the following: "));
        panel_0_1.add(this.objectiveSatisfied);
        panel_0_1.add(this.progressCompletion);
        JPanel measureWeight = new JPanel();
        measureWeight.add(this.objectiveMeasureWeight);
        this.newLabel = new JLabel("Objective Measure Weight (range: [0.0000, 1.0000])");
        measureWeight.add(this.newLabel);
        panel_0_1.add(measureWeight);
        JPanel panel_1_0 = new JPanel();
        panel_1_0.add(new JLabel("<html><b>Rule: &nbsp &nbsp</b> I am </html>"));
        panel_1_0.add(this.action);
        panel_1_0.add(new JLabel(" when "));
        panel_1_0.add(this.condition);
        panel_1_0.add(new JLabel("<html> of the <font color='blue'>*conditions</font> selected below are true with regard to "));
        panel_1_0.add(this.childActivitySet);
        panel_1_0.add(new JLabel(" of my children."));
        JPanel panel_2 = new JPanel();
        panel_2.add(new JLabel("<html><font color='blue'>*Conditions </font>to include: </html>"));
        JScrollPane conditionScrollPane = new JScrollPane(this.condition2);
        conditionScrollPane.setPreferredSize(new Dimension(200, 50));
        panel_2.add(conditionScrollPane);
        this._SSRollupRuleConditionTable = new SSRollupRuleConditionTable(TABLEWIDTH, TABLEHEIGHT);
        JScrollPane scrollPane = new JScrollPane(this._SSRollupRuleConditionTable);
        scrollPane.setPreferredSize(new Dimension(TABLEWIDTH, TABLEHEIGHT));
        Object[] objects = new Object[]{"I am ", this.action, " when ", this.condition, " of the following conditions are true with regard to ", this.childActivitySet, " of my children."};
        this._SSRollupTableModelListener = new SSRollupTableModelListener(this._SSRollupRuleConditionTable, objects, this.condition2, this.childActivitySet);
        this._SSRollupTableModelListener.passContentPackageEtc(this._contentPackage, this._element, this._schemaElement);
        this.addButton = new JButton("Add Rule");
        this.addButton.addActionListener(this._SSRollupTableModelListener);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(new JLabel("<html>(Click to add the above rule.) &nbsp &nbsp Rollup Rules applied to the selected item or aggregation are displayed in the table below.</html>"));
        this.panel_0.add((Component)panel_0_1, this.constraints);
        this.constraints.gridy += 5;
        this.panel_0.add((Component)panel_1_0, this.constraints);
        ++this.constraints.gridy;
        this.panel_0.add((Component)panel_2, this.constraints);
        ++this.constraints.gridy;
        this.panel_0.add((Component)buttonPanel, this.constraints);
        ++this.constraints.gridy;
        this.panel_0.add((Component)scrollPane, this.constraints);
        this.mRollupConsiderationPanel = new rulesRollUpConsiderationsPanel();
        this.add(this.panel_0);
        this.add(this.mRollupConsiderationPanel);
    }

    public void selectNonTableValues(Element element) {
        String elementName = element.getName();
        if (elementName.equals("rollupRules")) {
            List atts = element.getAttributes();
            for (int i = 0; i < atts.size(); ++i) {
                String value;
                if (((Attribute)atts.get(i)).getName().equals("rollupObjectiveSatisfied")) {
                    value = ((Attribute)atts.get(i)).getValue();
                    if (value.equalsIgnoreCase("false")) {
                        this.objectiveSatisfied.setSelected(false);
                        continue;
                    }
                    if (!value.equalsIgnoreCase("true")) continue;
                    this.objectiveSatisfied.setSelected(true);
                    continue;
                }
                if (((Attribute)atts.get(i)).getName().equals("rollupProgressCompletion")) {
                    value = ((Attribute)atts.get(i)).getValue();
                    if (value.equalsIgnoreCase("false")) {
                        this.progressCompletion.setSelected(false);
                        continue;
                    }
                    if (!value.equalsIgnoreCase("true")) continue;
                    this.progressCompletion.setSelected(true);
                    continue;
                }
                if (!((Attribute)atts.get(i)).getName().equals("objectiveMeasureWeight") || (value = ((Attribute)atts.get(i)).getValue()) == null) continue;
                this.objectiveMeasureWeight.setText(value);
            }
        }
    }

    public synchronized void updateTableWithPreviousValues(Element element) {
        this.preExistingValues = new String[4];
        this.rule = null;
        this.buildRule(element);
        if (this.preExistingValues[0] != null && this.preExistingValues[1] != null && this.preExistingValues[3] != null && this.preExistingValues[2] != null) {
            Object path = null;
            for (int i = 0; i < this.preExistingValues.length; ++i) {
                String friendlyName = SimpleSequencingSchemaController.getFriendlyName("rollupRule/#" + this.preExistingValues[i]);
                if (friendlyName == null) continue;
                this.preExistingValues[i] = friendlyName;
            }
            String sentence = "I am " + this.preExistingValues[0] + " when " + this.preExistingValues[1] + " of the following conditions are true with regard to " + this.preExistingValues[3] + " of my children.";
            Object[] values = new Object[]{sentence, this.preExistingValues[2]};
            this._SSRollupTableModelListener.addExistingRule(element, values);
        }
    }

    public void buildRule(Element element) {
        String elementName = element.getName();
        if (elementName.equals("rollupRule")) {
            Attribute parentAtt = element.getAttribute("childActivitySet");
            if (parentAtt != null) {
                String val = parentAtt.getValue();
                if (val.equals("atLeastCount")) {
                    val = element.getAttribute("minimumCount").getValue();
                } else if (val.equals("atLeastPercent")) {
                    val = element.getAttribute("minimumPercent").getValue();
                }
                this.preExistingValues[3] = val;
            } else {
                this.preExistingValues[3] = "all";
            }
        }
        if (element != null && !element.getChildren().isEmpty()) {
            List children_1 = element.getChildren();
            for (int i = 0; i < children_1.size(); ++i) {
                Attribute att;
                Element childElement = (Element)children_1.get(i);
                String childName = childElement.getName();
                if (childName.equals("rollupAction") && (att = childElement.getAttribute("action")) != null) {
                    this.preExistingValues[0] = SimpleSequencingSchemaController.getFriendlyName("rollupRule/#" + att.getValue());
                    continue;
                }
                if (!childName.equals("rollupConditions")) continue;
                att = childElement.getAttribute("conditionCombination");
                if (att != null) {
                    this.preExistingValues[1] = att.getValue();
                    if (this.preExistingValues[1] == null) {
                        this.preExistingValues[1] = "any";
                    }
                } else {
                    this.preExistingValues[1] = "any";
                }
                List children = childElement.getChildren();
                boolean first = true;
                for (int j = 0; j < children.size(); ++j) {
                    childElement = (Element)children.get(j);
                    childName = childElement.getName();
                    String pev = null;
                    if (!childName.equals("rollupCondition")) continue;
                    att = childElement.getAttribute("operator");
                    if (att != null && (att.getValue() == null || !att.getValue().equals("noOp")) && att.getValue() != null && att.getValue().equals("not")) {
                        pev = "not_";
                    }
                    if ((att = childElement.getAttribute("condition")) == null) continue;
                    String friendlyName = null;
                    friendlyName = pev != null ? SimpleSequencingSchemaController.getFriendlyName("rollupRule/#" + pev + att.getValue()) : SimpleSequencingSchemaController.getFriendlyName("rollupRule/#" + att.getValue());
                    if (friendlyName == null) {
                        friendlyName = att.getValue();
                    }
                    if (first) {
                        this.preExistingValues[2] = friendlyName;
                        first = false;
                        continue;
                    }
                    this.preExistingValues[2] = this.preExistingValues[2] + ", " + friendlyName;
                }
            }
        }
    }

    void addPanelWithConstraints(Component[] components) {
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        for (int i = 0; i < components.length; ++i) {
            this.panel_0.add(components[i], this.constraints);
            this.constraints.gridy += 3;
            this.constraints.gridx = 0;
        }
    }

    public void updateMeasureWeight() {
        String check = this.objectiveMeasureWeight.getText();
        if (check == null || check.length() <= 0) {
            check = "1.0000";
        }
        Element _rollupRules = new Element("rollupRules", this._schemaElement.getNamespace());
        _rollupRules.setAttribute("objectiveMeasureWeight", check);
        Element sequencingElement = SimpleSequencingTabsPane.findSequencingElement(this._element);
        if (sequencingElement != null) {
            Element tempRollupRules = sequencingElement.getChild("rollupRules", this._schemaElement.getNamespace());
            if (tempRollupRules != null) {
                tempRollupRules.setAttribute("objectiveMeasureWeight", check);
                this._contentPackage.changedElement(this, tempRollupRules);
            } else {
                this._contentPackage.addElement(this, sequencingElement, _rollupRules, false);
            }
        } else {
            Element _sequencing = new Element("sequencing", this._schemaElement.getNamespace());
            _sequencing.addContent(_rollupRules);
            this._contentPackage.addElement(this, this._element, _sequencing, false);
        }
    }

    private class rulesRollUpConsiderationsPanel
    extends JPanel
    implements ActionListener {
        private static final String MEASURE_SATISFACTION_IF_ACTIVE = "measureSatisfactionIfActive";
        private static final String REQUIRED_FOR_INCOMPLETE = "requiredForIncomplete";
        private static final String REQUIRED_FOR_COMPLETED = "requiredForCompleted";
        private static final String REQUIRED_FOR_NOT_SATISFIED = "requiredForNotSatisfied";
        private static final String REQUIRED_FOR_SATISFIED = "requiredForSatisfied";
        private static final String ROLLUP_CONSIDERATIONS = "rollupConsiderations";
        private String[] mValidValues;
        private JCheckBox mAddRulesConsideration;
        private JCheckBox mMeasureSatisfactionIfActive;
        private JComboBox mRequiredForSatisfied;
        private JComboBox mRequiredForNotSatisfied;
        private JComboBox mRequiredForCompleted;
        private JComboBox mRequiredForIncomplete;

        private void setActionListner() {
            ActionListener listner = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    rulesRollUpConsiderationsPanel.this.SaveConsiderations();
                }
            };
            this.mRequiredForSatisfied.addActionListener(listner);
            this.mRequiredForNotSatisfied.addActionListener(listner);
            this.mRequiredForCompleted.addActionListener(listner);
            this.mRequiredForIncomplete.addActionListener(listner);
            this.mMeasureSatisfactionIfActive.addActionListener(listner);
        }

        public rulesRollUpConsiderationsPanel() {
            super(new GridBagLayout());
            this.mValidValues = new String[]{"always", "ifAttempted", "ifNotSkipped", "ifNotSuspended"};
            this.mAddRulesConsideration = new JCheckBox();
            this.mMeasureSatisfactionIfActive = new JCheckBox();
            this.mRequiredForSatisfied = new JComboBox();
            this.mRequiredForNotSatisfied = new JComboBox();
            this.mRequiredForCompleted = new JComboBox();
            this.mRequiredForIncomplete = new JComboBox();
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)this.mAddRulesConsideration, c);
            this.setEnabledForAttributePanel(false);
            this.mMeasureSatisfactionIfActive.setText("Measure Satisfaction If Active");
            this.PopulateDropdowns();
            c.gridx = 0;
            c.gridy = 1;
            this.add((Component)this.mMeasureSatisfactionIfActive, c);
            c.gridx = 1;
            c.gridy = 1;
            JLabel text = new JLabel();
            text.setText("Required For Satisfied");
            this.add((Component)text, c);
            c.gridx = 2;
            c.gridy = 1;
            this.add((Component)this.mRequiredForSatisfied, c);
            c.gridx = 3;
            c.gridy = 1;
            text = new JLabel();
            text.setText("Required For Not Satisfied");
            this.add((Component)text, c);
            c.gridx = 4;
            c.gridy = 1;
            this.add((Component)this.mRequiredForNotSatisfied, c);
            c.gridx = 0;
            c.gridy = 2;
            text = new JLabel();
            text.setText("Required For Completed");
            this.add((Component)text, c);
            c.gridx = 1;
            c.gridy = 2;
            this.add((Component)this.mRequiredForCompleted, c);
            c.gridx = 2;
            c.gridy = 2;
            text = new JLabel();
            text.setText("Required For Incomplete");
            this.add((Component)text, c);
            c.gridx = 3;
            c.gridy = 2;
            this.add((Component)this.mRequiredForIncomplete, c);
            this.mAddRulesConsideration.setText("Add Rules Rollup Consideration");
            this.mAddRulesConsideration.addActionListener(this);
            this.setInitialState();
            this.setActionListner();
        }

        private void setInitialState() {
            Element tempRollupRules = this.getRollupRulesElement();
            if (tempRollupRules != null) {
                this.mAddRulesConsideration.setSelected(true);
                String measuerSatisfactionIfActive = tempRollupRules.getAttributeValue(MEASURE_SATISFACTION_IF_ACTIVE);
                boolean selected = Boolean.valueOf(measuerSatisfactionIfActive);
                this.mMeasureSatisfactionIfActive.setSelected(selected);
                this.mRequiredForSatisfied.setSelectedItem(tempRollupRules.getAttributeValue(REQUIRED_FOR_SATISFIED));
                this.mRequiredForNotSatisfied.setSelectedItem(tempRollupRules.getAttributeValue(REQUIRED_FOR_NOT_SATISFIED));
                this.mRequiredForCompleted.setSelectedItem(tempRollupRules.getAttributeValue(REQUIRED_FOR_COMPLETED));
                this.mRequiredForIncomplete.setSelectedItem(tempRollupRules.getAttributeValue(REQUIRED_FOR_INCOMPLETE));
                this.setEnabledForAttributePanel(true);
            }
        }

        private Element getRollupRulesElement() {
            Element tempRollupRules = null;
            Element sequencingElement = SimpleSequencingTabsPane.findSequencingElement(SSRollupPanel.this._element);
            if (sequencingElement != null) {
                tempRollupRules = sequencingElement.getChild(ROLLUP_CONSIDERATIONS, IMSDocumentHandler.ADLSEQ_NAMESPACE_13);
            }
            return tempRollupRules;
        }

        private void PopulateDropdowns() {
            for (String option : this.mValidValues) {
                this.mRequiredForSatisfied.addItem(option);
                this.mRequiredForNotSatisfied.addItem(option);
                this.mRequiredForCompleted.addItem(option);
                this.mRequiredForIncomplete.addItem(option);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabledForAttributePanel(this.mAddRulesConsideration.isSelected());
        }

        private void setEnabledForAttributePanel(boolean enabled) {
            this.mMeasureSatisfactionIfActive.setEnabled(enabled);
            this.mRequiredForSatisfied.setEnabled(enabled);
            this.mRequiredForNotSatisfied.setEnabled(enabled);
            this.mRequiredForCompleted.setEnabled(enabled);
            this.mRequiredForIncomplete.setEnabled(enabled);
        }

        private void SaveConsiderations() {
            Element sequencingElement = SimpleSequencingTabsPane.findSequencingElement(SSRollupPanel.this._element);
            if (sequencingElement != null) {
                Element tempRollupRules = this.getRollupRulesElement();
                if (tempRollupRules != null) {
                    this.populateConsiderationsFromUI(tempRollupRules);
                    SSRollupPanel.this._contentPackage.changedElement(this, tempRollupRules);
                } else {
                    Element considerationsElement = this.getRollupRulesConsiderationsElement();
                    SSRollupPanel.this._contentPackage.addElement(this, sequencingElement, considerationsElement, false);
                }
            } else {
                Element _sequencing = new Element("sequencing", SSRollupPanel.this._schemaElement.getNamespace());
                Element considerationsElement = this.getRollupRulesConsiderationsElement();
                _sequencing.addContent(considerationsElement);
                SSRollupPanel.this._contentPackage.addElement(this, SSRollupPanel.this._element, _sequencing, false);
            }
        }

        public Element getRollupRulesConsiderationsElement() {
            Element considerationsElement = new Element(ROLLUP_CONSIDERATIONS, IMSDocumentHandler.ADLSEQ_NAMESPACE_13);
            this.populateConsiderationsFromUI(considerationsElement);
            return considerationsElement;
        }

        private void populateConsiderationsFromUI(Element considerationsElement) {
            considerationsElement.setAttribute(REQUIRED_FOR_SATISFIED, this.mRequiredForSatisfied.getSelectedItem().toString());
            considerationsElement.setAttribute(REQUIRED_FOR_NOT_SATISFIED, this.mRequiredForNotSatisfied.getSelectedItem().toString());
            considerationsElement.setAttribute(REQUIRED_FOR_COMPLETED, this.mRequiredForCompleted.getSelectedItem().toString());
            considerationsElement.setAttribute(REQUIRED_FOR_INCOMPLETE, this.mRequiredForIncomplete.getSelectedItem().toString());
            considerationsElement.setAttribute(MEASURE_SATISFACTION_IF_ACTIVE, Boolean.toString(this.mMeasureSatisfactionIfActive.isSelected()));
        }
    }

    public class RollupRulesAttListener
    extends AbstractAction {
        private String _attributeName;

        public RollupRulesAttListener(String attribute) {
            this._attributeName = attribute;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String attValue = "true";
            if (!(this._attributeName.equalsIgnoreCase("rollupObjectiveSatisfied") && SSRollupPanel.this.objectiveSatisfied.isSelected() || this._attributeName.equalsIgnoreCase("rollupProgressCompletion") && SSRollupPanel.this.progressCompletion.isSelected())) {
                attValue = "false";
            }
            if (this._attributeName.equalsIgnoreCase("rollupObjectiveSatisfied")) {
                Element _rollupRules = new Element("rollupRules", SSRollupPanel.this._schemaElement.getNamespace());
                _rollupRules.setAttribute("rollupObjectiveSatisfied", attValue);
                Element sequencingElement = SimpleSequencingTabsPane.findSequencingElement(SSRollupPanel.this._element);
                if (sequencingElement != null) {
                    Element tempRollupRules = sequencingElement.getChild("rollupRules", SSRollupPanel.this._schemaElement.getNamespace());
                    if (tempRollupRules != null) {
                        tempRollupRules.setAttribute("rollupObjectiveSatisfied", attValue);
                        SSRollupPanel.this._contentPackage.changedElement(this, tempRollupRules);
                    } else {
                        SSRollupPanel.this._contentPackage.addElement(this, sequencingElement, _rollupRules, false);
                    }
                } else {
                    Element _sequencing = new Element("sequencing", SSRollupPanel.this._schemaElement.getNamespace());
                    _sequencing.addContent(_rollupRules);
                    SSRollupPanel.this._contentPackage.addElement(this, SSRollupPanel.this._element, _sequencing, false);
                }
            } else if (this._attributeName.equalsIgnoreCase("rollupProgressCompletion")) {
                Element _rollupRules = new Element("rollupRules", SSRollupPanel.this._schemaElement.getNamespace());
                _rollupRules.setAttribute("rollupProgressCompletion", attValue);
                Element sequencingElement = SimpleSequencingTabsPane.findSequencingElement(SSRollupPanel.this._element);
                if (sequencingElement != null) {
                    Element tempRollupRules = sequencingElement.getChild("rollupRules", SSRollupPanel.this._schemaElement.getNamespace());
                    if (tempRollupRules != null) {
                        tempRollupRules.setAttribute("rollupProgressCompletion", attValue);
                        SSRollupPanel.this._contentPackage.changedElement(this, tempRollupRules);
                    } else {
                        SSRollupPanel.this._contentPackage.addElement(this, sequencingElement, _rollupRules, false);
                    }
                } else {
                    Element _sequencing = new Element("sequencing", SSRollupPanel.this._schemaElement.getNamespace());
                    _sequencing.addContent(_rollupRules);
                    SSRollupPanel.this._contentPackage.addElement(this, SSRollupPanel.this._element, _sequencing, false);
                }
            }
        }
    }
}

