/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.simplesequencing.SSTableModelListener;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingTabsPane;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SSRollupTableModelListener
extends SSTableModelListener {
    private JComboBox _forValidityCheck;

    public SSRollupTableModelListener(JTable tableModel, Object[] sentenceObjects, JList conditions, JComboBox forValidityCheck) {
        super(tableModel, sentenceObjects, conditions);
        this._forValidityCheck = forValidityCheck;
    }

    @Override
    public void passContentPackageEtc(ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement) {
        super.passContentPackageEtc(contentPackage, element, schemaElement);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this._Rule = new Element("rollupRule", this._schemaElement.getNamespace());
        this._Conditions = new Element("rollupConditions", this._schemaElement.getNamespace());
        this._Action = new Element("rollupAction", this._schemaElement.getNamespace());
        this._Condition = new Element("rollupCondition", this._schemaElement.getNamespace());
        super.actionPerformed(event);
        String check = this._forValidityCheck.getSelectedItem().toString().trim();
        if (!(check.equals("all") || check.equals("any") || check.equals("none"))) {
            String validString;
            double num = -1.0;
            try {
                num = Double.parseDouble(check);
            }
            catch (NumberFormatException NFE) {
                JOptionPane.showMessageDialog(null, "<html>The number of <b>children</b> to include when evaluating the <b>conditions</b><br>is invalid. Valid choices are &quot all &quot, &quot any &quot, &quot none &quot, a number that is<br> either a percentage in the range [0, 1], or a non-negative integer.</html>");
                return;
            }
            if (Double.isNaN(num) || num < 0.0) {
                JOptionPane.showMessageDialog(null, "<html>The number of <b>children</b> to include when evaluating the <b>conditions</b><br>is invalid. Valid choices are &quot all &quot, &quot any &quot, &quot none &quot, a number that is<br> either a percentage in the range [0, 1], or a non-negative integer.</html>");
                return;
            }
            String numString = Double.toString(num);
            int decimalLoc = numString.indexOf(".");
            if (decimalLoc > 0) {
                double numBeforeDecimal = Double.parseDouble(numString.substring(0, decimalLoc));
                Integer integer = new Integer(numString.substring(decimalLoc + 1));
                if (numBeforeDecimal > 0.0 && integer > 0) {
                    JOptionPane.showMessageDialog(null, "<html>The number of <b>children</b> to include when evaluating the <b>conditions</b><br>is invalid. Valid choices are &quot all &quot , &quot any &quot, a number that is<br> either a percentage in the range [0, 1], or a non-negative integer.</html>");
                    return;
                }
                if (!numString.substring(0, decimalLoc).equals("0")) {
                    this._forValidityCheck.setSelectedItem(numString.substring(0, decimalLoc));
                }
            }
            if ((validString = this._forValidityCheck.getSelectedItem().toString()).indexOf(".") >= 0) {
                this._Rule.setAttribute("childActivitySet", "atLeastPercent");
                this._Rule.setAttribute("minimumPercent", validString);
            } else if (validString.equals("0")) {
                this._Rule.setAttribute("childActivitySet", "none");
            } else {
                this._Rule.setAttribute("childActivitySet", "atLeastCount");
                this._Rule.setAttribute("minimumCount", validString);
            }
        } else {
            this._Rule.setAttribute("childActivitySet", check);
        }
        if (this._conditionValues == null || this._conditionValues.length() < 3) {
            JOptionPane.showMessageDialog(null, "<html>A <b>Rule</b> requires that a <b>Condition</b> be selected. Please select a <b>Condition</b> to include, then <b>Add Rule<b>.");
        } else {
            for (int k = 0; k < this._manifestConditions.length; ++k) {
                this._Condition = new Element("rollupCondition", this._schemaElement.getNamespace());
                String operatorValue = "noOp";
                String con = this._manifestConditions[k].toString();
                if (con.indexOf("not_") >= 0) {
                    operatorValue = "not";
                    this._manifestConditions[k] = con.substring(4, con.length());
                }
                this._Condition.setAttribute("operator", operatorValue);
                this._Condition.setAttribute("condition", this._manifestConditions[k].toString());
                this._Conditions.addContent(this._Condition);
            }
            this.addRule();
            ((DefaultTableModel)this._SSTableModel.getModel()).addRow(new Object[]{this._sentence, this._conditionValues, this._deleteButton});
        }
    }

    private void addRule() {
        this._Rule.addContent(this._Conditions);
        this._Rule.addContent(this._Action);
        Element _Rules = new Element("rollupRules", this._schemaElement.getNamespace());
        Element sequencingElement = SimpleSequencingTabsPane.findSequencingElement(this._element);
        if (sequencingElement != null) {
            Element potentialParent = sequencingElement.getChild("rollupRules", this._schemaElement.getNamespace());
            if (potentialParent != null) {
                this._contentPackage.addElement(this, potentialParent, this._Rule, false);
            } else {
                _Rules.addContent(this._Rule);
                this._contentPackage.addElement(this, sequencingElement, _Rules, false);
            }
        } else {
            Element _sequencing = new Element("sequencing", this._schemaElement.getNamespace());
            _Rules.addContent(this._Rule);
            _sequencing.addContent(_Rules);
            this._contentPackage.addElement(this, this._element, _sequencing, false);
        }
    }
}

