/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingSchemaController;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public abstract class SSTableModelListener
extends AbstractAction {
    protected ContentPackage _contentPackage;
    protected Element _element;
    protected ReloadSchemaElement _schemaElement;
    protected Object[] _sentenceObjects;
    protected JList _conditions;
    protected JTable _SSTableModel;
    protected JButton _deleteButton;
    protected JButton _addButton;
    protected String _conditionValues;
    protected Object[] _manifestConditions;
    protected String _sentence;
    protected Element _Rule;
    protected Element _Conditions;
    protected Element _Action;
    protected Element _Condition;

    public SSTableModelListener() {
    }

    public SSTableModelListener(JTable tableModel, Object[] sentenceObjects, JList conditions) {
        this._sentenceObjects = sentenceObjects;
        this._SSTableModel = tableModel;
        this._conditions = conditions;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this._sentence = new String();
        for (int i = 0; i < this._sentenceObjects.length; ++i) {
            if (this._sentenceObjects[i] instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)this._sentenceObjects[i];
                String thisValue = comboBox.getSelectedItem().toString().trim();
                this._sentence = this._sentence + thisValue;
                String lowerCaseValue = thisValue.toLowerCase();
                if (comboBox.getItemCount() == 2) {
                    this._Conditions.setAttribute("conditionCombination", thisValue);
                    continue;
                }
                if (comboBox.getItemCount() < 4 && comboBox.getItemCount() != 1 || comboBox.isEditable()) continue;
                String action = SimpleSequencingSchemaController.getFriendlyName((String)comboBox.getSelectedItem());
                if (action == null) {
                    action = (String)comboBox.getSelectedItem();
                }
                this._Action.setAttribute("action", action);
                continue;
            }
            if (this._sentenceObjects[i] instanceof JTextArea) {
                JTextArea textArea = (JTextArea)this._sentenceObjects[i];
                this._sentence = this._sentence + textArea.getText().trim();
                continue;
            }
            if (!(this._sentenceObjects[i] instanceof String)) continue;
            this._sentence = this._sentence + this._sentenceObjects[i];
        }
        this._deleteButton = new JButton("<html>Delete<br>Rule</html>");
        this._deleteButton.addActionListener(new SSTableRemoveRowListener(this._Rule, ((DefaultTableModel)this._SSTableModel.getModel()).getRowCount()));
        Object[] selectedValues = this._conditions.getSelectedValues();
        this._conditionValues = new String();
        this._manifestConditions = new Object[selectedValues.length];
        for (int j = 0; j < selectedValues.length; ++j) {
            String conditionVal;
            this._conditionValues = this._conditionValues + selectedValues[j].toString();
            if (j != selectedValues.length - 1) {
                this._conditionValues = this._conditionValues + ", ";
            }
            if ((conditionVal = SimpleSequencingSchemaController.getFriendlyName("condition/#" + selectedValues[j].toString())) == null) {
                conditionVal = selectedValues[j].toString();
            }
            this._manifestConditions[j] = conditionVal;
        }
    }

    public void passContentPackageEtc(ContentPackage contentPackage, Element element, ReloadSchemaElement schemaElement) {
        this._contentPackage = contentPackage;
        this._element = element;
        this._schemaElement = schemaElement;
    }

    public void updateTable() {
        int rowCount = ((DefaultTableModel)this._SSTableModel.getModel()).getRowCount();
        int columnCount = ((DefaultTableModel)this._SSTableModel.getModel()).getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                if (!(((DefaultTableModel)this._SSTableModel.getModel()).getValueAt(i, j) instanceof JButton)) continue;
                JButton jbutt = (JButton)((DefaultTableModel)this._SSTableModel.getModel()).getValueAt(i, j);
                ActionListener[] listeners = jbutt.getActionListeners();
                for (int k = 0; k < listeners.length; ++k) {
                    if (listeners[k] instanceof SSTableRemoveRowListener) {
                        ((SSTableRemoveRowListener)listeners[k]).updateRow(i);
                    }
                    this._SSTableModel.moveColumn(j, j);
                }
            }
        }
    }

    public void addExistingRule(Element added, Object[] objects) {
        this._deleteButton = new JButton("<html>Delete<br>Rule</html>");
        this._deleteButton.addActionListener(new SSTableRemoveRowListener(added, ((DefaultTableModel)this._SSTableModel.getModel()).getRowCount()));
        ((DefaultTableModel)this._SSTableModel.getModel()).addRow(objects);
        ((DefaultTableModel)this._SSTableModel.getModel()).setValueAt(this._deleteButton, ((DefaultTableModel)this._SSTableModel.getModel()).getRowCount() - 1, ((DefaultTableModel)this._SSTableModel.getModel()).getColumnCount() - 1);
    }

    private void addRule() {
    }

    public class SSTableRemoveRowListener
    extends AbstractAction {
        private int _row;
        private Element _elementToRemove;

        public SSTableRemoveRowListener(Element element, int row) {
            this._row = row;
            this._elementToRemove = element;
        }

        public void updateRow(int newRowNum) {
            this._row = newRowNum;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int choice = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete this rule?");
            if (choice == 0) {
                Element parent = this._elementToRemove.getParentElement();
                SSTableModelListener.this._contentPackage.removeElement(this, this._elementToRemove);
                List children = parent.getChildren();
                if (children.size() <= 0) {
                    SSTableModelListener.this._contentPackage.removeElement(this, parent);
                }
                ((DefaultTableModel)SSTableModelListener.this._SSTableModel.getModel()).removeRow(this._row);
                SSTableModelListener.this.updateTable();
            }
        }
    }
}

