/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.simplesequencing;

import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.SCORM1_3Package;
import uk.ac.reload.editor.simplesequencing.SSConditionRulePanel;
import uk.ac.reload.editor.simplesequencing.SSControlModePanel;
import uk.ac.reload.editor.simplesequencing.SSItemsProperties;
import uk.ac.reload.editor.simplesequencing.SSObjectivesPanel;
import uk.ac.reload.editor.simplesequencing.SSRollupPanel;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingSchemaController;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SimpleSequencingTabsPane
extends JTabbedPane {
    ChangeListener _changeListener;
    private SSRollupPanel _SSRollupPanel;
    private SSConditionRulePanel _SSPreConditionRulePanel;
    private SSConditionRulePanel _SSPostConditionRulePanel;
    private SSConditionRulePanel _SSExitConditionRulePanel;
    private SSControlModePanel _SSControlModePanel;
    private SSObjectivesPanel _SSObjectivesPanel;
    private SSItemsProperties _SSItemsProperties;
    private Element _element;
    private ReloadSchemaElement _schemaElement;
    private ContentPackage _contentPackage;

    public SimpleSequencingTabsPane(ContentPackage contentPackage, Element itemElement, ReloadSchemaElement schema_itemElement) {
        this._contentPackage = contentPackage;
        this._element = itemElement;
        this._schemaElement = schema_itemElement;
        String[] preConditionAction = new String[]{"skip", "disabled", "hiddenFromChoice", "stopForwardTraversal"};
        for (int i = 0; i < preConditionAction.length; ++i) {
            String friendlyName = SimpleSequencingSchemaController.getFriendlyName("sequencingRule/#" + preConditionAction[i]);
            if (friendlyName == null) continue;
            preConditionAction[i] = friendlyName;
        }
        String[] exitConditionAction = new String[]{"exit"};
        for (int j = 0; j < exitConditionAction.length; ++j) {
            String friendlyName = SimpleSequencingSchemaController.getFriendlyName("sequencingRule/#" + exitConditionAction[j]);
            if (friendlyName == null) continue;
            exitConditionAction[j] = friendlyName;
        }
        String[] postConditionAction = new String[]{"exitParent", "exitAll", "retry", "retryAll", "continue", "previous"};
        for (int k = 0; k < postConditionAction.length; ++k) {
            String friendlyName = SimpleSequencingSchemaController.getFriendlyName("sequencingRule/#" + postConditionAction[k]);
            if (friendlyName == null) continue;
            postConditionAction[k] = friendlyName;
        }
        this._SSPreConditionRulePanel = new SSConditionRulePanel(new Element("preConditionRule", this._schemaElement.getNamespace()), preConditionAction, this._contentPackage, this._element, this._schemaElement);
        this._SSPostConditionRulePanel = new SSConditionRulePanel(new Element("postConditionRule", this._schemaElement.getNamespace()), postConditionAction, this._contentPackage, this._element, this._schemaElement);
        this._SSExitConditionRulePanel = new SSConditionRulePanel(new Element("exitConditionRule", this._schemaElement.getNamespace()), exitConditionAction, this._contentPackage, this._element, this._schemaElement);
        this._SSRollupPanel = new SSRollupPanel(this._contentPackage, this._element, this._schemaElement);
        this._SSControlModePanel = new SSControlModePanel(this._contentPackage, this._element, this._schemaElement);
        boolean fourthEditon = false;
        if (contentPackage instanceof SCORM1_3Package && ((SCORM1_3Package)contentPackage).isFourthEdition()) {
            this._SSItemsProperties = new SSItemsProperties(this._contentPackage, this._element, this._schemaElement);
            fourthEditon = true;
        }
        this._SSObjectivesPanel = new SSObjectivesPanel(this._contentPackage, this._element, this._schemaElement, fourthEditon);
        this.addTab("PreCondition Rules", this._SSPreConditionRulePanel);
        this.addTab("PostCondition Rules", this._SSPostConditionRulePanel);
        this.addTab("ExitCondition Rules", this._SSExitConditionRulePanel);
        this.addTab("Rollup Rules", this._SSRollupPanel);
        this.addTab("Control Mode", this._SSControlModePanel);
        this.addTab("Objectives", this._SSObjectivesPanel);
        if (this._SSItemsProperties != null && this._SSItemsProperties.IsValidPresentationElement()) {
            this.addTab("Item Properties", this._SSItemsProperties);
        }
        this.updateTablesWithExistingValues(this._element);
    }

    public void updateTablesWithExistingValues(Element element) {
        if (element != null && !element.getChildren().isEmpty()) {
            List children = element.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Element childElement = (Element)children.get(i);
                String childName = childElement.getName();
                if (!childName.equalsIgnoreCase("sequencing")) continue;
                this.findSSValues(childElement);
            }
        }
    }

    public void cleanUp() {
        this._SSRollupPanel.updateMeasureWeight();
    }

    public static Element findSequencingElement(Element element) {
        if (element != null && !element.getChildren().isEmpty()) {
            List children = element.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Element childElement = (Element)children.get(i);
                String childName = childElement.getName();
                if (!childName.equalsIgnoreCase("sequencing")) continue;
                return childElement;
            }
        }
        return null;
    }

    public void findSSValues(Element element) {
        if (element != null && !element.getChildren().isEmpty()) {
            List children = element.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Element childElement = (Element)children.get(i);
                String childName = childElement.getName();
                if (childName.equalsIgnoreCase("preConditionRule") || childName.equalsIgnoreCase("postConditionRule") || childName.equalsIgnoreCase("exitConditionRule")) {
                    SSConditionRulePanel conditionRulePanel = new SSConditionRulePanel();
                    conditionRulePanel.updateTableWithPreviousValues(childElement, this._SSPreConditionRulePanel, this._SSPostConditionRulePanel, this._SSExitConditionRulePanel);
                } else if (childName.equalsIgnoreCase("rollupRules")) {
                    this._SSRollupPanel.selectNonTableValues(childElement);
                } else if (childName.equalsIgnoreCase("rollupRule")) {
                    this._SSRollupPanel.updateTableWithPreviousValues(childElement);
                } else if (childName.equalsIgnoreCase("primaryObjective") || childName.equalsIgnoreCase("objective")) {
                    this._SSObjectivesPanel.updateTableWithPreviousValues(childElement);
                } else if (childName.equalsIgnoreCase("controlMode")) {
                    this._SSControlModePanel.updateTableWithPreviousValues(childElement);
                }
                this.findSSValues(childElement);
            }
        }
    }

    public boolean submitChanges() {
        return true;
    }
}

