/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.util.DweezilZipException;
import uk.ac.reload.dweezil.util.ZipUtils;

public class IMSDocumentHandler {
    public static String IMSMD_110 = "imsmd_110";
    public static String IMSMD_120 = "imsmd_120";
    public static String IMSMD_121 = "imsmd_121";
    public static String IMSMD_122 = "imsmd_122";
    public static String LOM_10 = "lom_10";
    public static final String LOM_HC_10 = "lom_hc_10";
    public static final String LOM_ADLR_10 = "lom_ADLR_10";
    public static String IMSCP_111 = "imscp_111";
    public static String IMSCP_112 = "imscp_112";
    public static String IMSCP_113 = "imscp_113";
    public static String ADLCP_120_112 = "adlcp_120_112";
    public static String ADLCP_120_113 = "adlcp_120_113";
    public static String ADLCP_130_3RD = "adlcp_130_3rd";
    public static String ADLCP_130_4th = "adlcp_130_4th";
    public static String IMSSS_100 = "imsss_100";
    public static String IMSMD_NAMESPACE_PREFIX = "imsmd";
    public static String LOM_NAMESPACE_PREFIX = "lom";
    public static String HEALTHCARE_LOM_NAMESPACE_PREFIX = "hx";
    public static String HEALTHCARE_LOM_ADDRESS_NAMESPACE_PREFIX = "a";
    public static String ADLR_NAMESPACE_PREFIX = "adlr";
    public static String LOM_NAMESPACE_URI_10 = "http://ltsc.ieee.org/xsd/LOM";
    public static String HEALTHCARE_LOM_NAMESPACE_URI_10 = "http://ns.medbiq.org/lom/extend/v1/";
    public static String HEALTHCARE_LOM_ADDRESS_NAMESPACE_URI_10 = "http://ns.medbiq.org/address/v1/";
    public static String ADLR_NAMESPACE_URI = "http://ltsc.ieee.org/xsd/LOM";
    public static Namespace LOM_NAMESPACE_10 = Namespace.getNamespace(LOM_NAMESPACE_PREFIX, LOM_NAMESPACE_URI_10);
    public static Namespace ADLR_NAMESPACE = Namespace.getNamespace(ADLR_NAMESPACE_PREFIX, ADLR_NAMESPACE_URI);
    public static String IMSMD_NAMESPACE_URI_122 = "http://www.imsglobal.org/xsd/imsmd_v1p2";
    public static String IMSMD_NAMESPACE_URI_121 = "http://www.imsglobal.org/xsd/imsmd_rootv1p2p1";
    public static String IMSMD_NAMESPACE_URI_121A = "http://www.imsproject.org/xsd/imsmd_rootv1p2p1";
    public static String IMSMD_NAMESPACE_URI_12A = "http://www.imsproject.org/xsd/imsmd_rootv1p2";
    public static String IMSMD_NAMESPACE_URI_12B = "http://www.imsglobal.org/xsd/imsmd_rootv1p2";
    public static String IMSMD_NAMESPACE_URI_12C = "http://www.imsproject.org/xsd/ims_md_rootv1p2";
    public static String IMSMD_NAMESPACE_URI_11 = "http://www.imsproject.org/xsd/ims_md_rootv1p1";
    public static String IMSMD_NAMESPACE_URI_112 = "http://www.imsproject.org/xsd/imsmd_rootv1p1p2";
    public static String[] MD_NAMESPACE_URIS = new String[]{LOM_NAMESPACE_URI_10, IMSMD_NAMESPACE_URI_122, IMSMD_NAMESPACE_URI_121};
    public static String IMSCP_NAMESPACE_PREFIX = "imscp";
    public static String IMSCP_NAMESPACE_URI_113 = "http://www.imsglobal.org/xsd/imscp_v1p1";
    public static String IMSCP_NAMESPACE_URI_113A = "http://www.imsproject.org/xsd/imscp_rootv1p1p3";
    public static String IMSCP_NAMESPACE_URI_112 = "http://www.imsproject.org/xsd/imscp_rootv1p1p2";
    public static String IMSCP_NAMESPACE_URI_112A = "http://www.imsglobal.org/xsd/imscp_rootv1p1p2";
    public static String IMSCP_NAMESPACE_URI_111A = "http://www.imsglobal.org/xsd/imscproot_v1p1";
    public static String IMSCP_NAMESPACE_URI_111B = "http://www.imsglobal.org/xsd/imscp_rootv1p1";
    public static String IMSCP_NAMESPACE_URI_111C = "http://www.imsproject.org/xsd/ims_cp_rootv1p1";
    public static Namespace IMSCP_NAMESPACE_13 = Namespace.getNamespace(IMSCP_NAMESPACE_PREFIX, IMSCP_NAMESPACE_URI_113);
    public static String[] IMSCP_NAMESPACE_URIS = new String[]{IMSCP_NAMESPACE_URI_113, IMSCP_NAMESPACE_URI_112};
    public static final String MANIFEST_NAME = "imsmanifest.xml";
    public static String ADLCP_NAMESPACE_PREFIX = "adlcp";
    public static String ADLSEQ_NAMESPACE_PREFIX = "adlseq";
    public static String ADLNAV_NAMESPACE_PREFIX = "adlnav";
    public static String ADLCP_NAMESPACE_URI_12 = "http://www.adlnet.org/xsd/adlcp_rootv1p2";
    public static Namespace ADLCP_NAMESPACE_12 = Namespace.getNamespace("adlcp", ADLCP_NAMESPACE_URI_12);
    public static String ADLCP_NAMESPACE_URI_13 = "http://www.adlnet.org/xsd/adlcp_v1p3";
    public static Namespace ADLCP_NAMESPACE_13 = Namespace.getNamespace(ADLCP_NAMESPACE_PREFIX, ADLCP_NAMESPACE_URI_13);
    public static String ADLSEQ_NAMESPACE_URI_13 = "http://www.adlnet.org/xsd/adlseq_v1p3";
    public static Namespace ADLSEQ_NAMESPACE_13 = Namespace.getNamespace(ADLSEQ_NAMESPACE_PREFIX, ADLSEQ_NAMESPACE_URI_13);
    public static String ADLNAV_NAMESPACE_URI_13 = "http://www.adlnet.org/xsd/adlnav_v1p3";
    public static Namespace ADLNAV_NAMESPACE_13 = Namespace.getNamespace(ADLNAV_NAMESPACE_PREFIX, ADLNAV_NAMESPACE_URI_13);
    public static String[] ADLCP_NAMESPACE_URIS = new String[]{ADLCP_NAMESPACE_URI_12, ADLCP_NAMESPACE_URI_13, ADLSEQ_NAMESPACE_URI_13, ADLNAV_NAMESPACE_URI_13};
    public static String IMSSS_NAMESPACE_PREFIX = "imsss";
    public static String IMSSS_NAMESPACE_URI_10 = "http://www.imsglobal.org/xsd/imsss";
    public static Namespace IMSSS_NAMESPACE_10 = Namespace.getNamespace(IMSSS_NAMESPACE_PREFIX, IMSSS_NAMESPACE_URI_10);
    public static String[] IMSSS_NAMESPACE_URIS = new String[]{IMSSS_NAMESPACE_URI_10};
    public static Namespace XSI_Namespace = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    public static Namespace XSI_NamespaceOLD = Namespace.getNamespace("xsi", "http://www.w3.org/2000/10/XMLSchema-instance");
    public static String XSI_SchemaLocation = "schemaLocation";
    static String[] _namespaceURIs = new String[]{LOM_NAMESPACE_URI_10, LOM_10, IMSMD_NAMESPACE_URI_122, IMSMD_122, IMSMD_NAMESPACE_URI_121, IMSMD_121, IMSMD_NAMESPACE_URI_12A, IMSMD_120, IMSMD_NAMESPACE_URI_12B, IMSMD_120, IMSMD_NAMESPACE_URI_12C, IMSMD_120, IMSCP_NAMESPACE_URI_113, IMSCP_113, IMSCP_NAMESPACE_URI_113A, IMSCP_113, IMSCP_NAMESPACE_URI_112, IMSCP_112, IMSCP_NAMESPACE_URI_112A, IMSCP_112, IMSCP_NAMESPACE_URI_111A, IMSCP_111, IMSCP_NAMESPACE_URI_111B, IMSCP_111, IMSCP_NAMESPACE_URI_111C, IMSCP_111, IMSSS_NAMESPACE_URI_10, IMSSS_100};
    public static String[] BOGUS_NAMESPACE_MAPPING = new String[]{IMSCP_NAMESPACE_URI_113A, IMSCP_NAMESPACE_URI_113, IMSCP_NAMESPACE_URI_112A, IMSCP_NAMESPACE_URI_112, IMSCP_NAMESPACE_URI_111A, IMSCP_NAMESPACE_URI_113, IMSCP_NAMESPACE_URI_111B, IMSCP_NAMESPACE_URI_113, IMSCP_NAMESPACE_URI_111C, IMSCP_NAMESPACE_URI_113, IMSMD_NAMESPACE_URI_12A, IMSMD_NAMESPACE_URI_122, IMSMD_NAMESPACE_URI_12B, IMSMD_NAMESPACE_URI_122, IMSMD_NAMESPACE_URI_12C, IMSMD_NAMESPACE_URI_122, IMSMD_NAMESPACE_URI_11, IMSMD_NAMESPACE_URI_122, IMSMD_NAMESPACE_URI_121A, IMSMD_NAMESPACE_URI_121, IMSMD_NAMESPACE_URI_112, IMSMD_NAMESPACE_URI_121};

    public static String getSchemaVersion(Document doc) {
        Namespace nsSCORM;
        Namespace ns = IMSDocumentHandler.getCorrectRootNamespace(doc);
        String schemaVersion = IMSDocumentHandler.getSchemaVersionFromNamespace(ns);
        if (schemaVersion != null && schemaVersion.startsWith("imscp") && (nsSCORM = IMSDocumentHandler.getDocumentNamespace(doc, ADLCP_NAMESPACE_PREFIX)) != null) {
            if (nsSCORM.getURI().equals(ADLCP_NAMESPACE_URI_13)) {
                Namespace searchSpace = Namespace.getNamespace("", IMSCP_NAMESPACE_URI_113);
                Element manifest = doc.getRootElement();
                Element metadata = manifest.getChild("metadata", searchSpace);
                Element schemaVersionElement = metadata.getChild("schemaversion", searchSpace);
                schemaVersion = schemaVersionElement.getText().contains("3rd") ? ADLCP_130_3RD : ADLCP_130_4th;
            } else if (nsSCORM.getURI().equals(ADLCP_NAMESPACE_URI_12)) {
                if (schemaVersion.equals(IMSCP_112)) {
                    schemaVersion = ADLCP_120_112;
                } else if (schemaVersion.equals(IMSCP_113)) {
                    schemaVersion = ADLCP_120_113;
                }
            } else {
                schemaVersion = null;
            }
        }
        return schemaVersion;
    }

    public static String getSchemaVersionFromNamespace(Namespace ns) {
        if (ns != null) {
            String nameSpaceURI = ns.getURI();
            for (int i = 0; i < _namespaceURIs.length; i += 2) {
                if (!nameSpaceURI.equalsIgnoreCase(_namespaceURIs[i])) continue;
                return _namespaceURIs[i + 1];
            }
        }
        return null;
    }

    public static Namespace getCorrectRootNamespace(Document doc) {
        Namespace ns = IMSDocumentHandler.getDocumentNamespace(doc);
        Element element = doc.getRootElement();
        if (element != null && ns != null) {
            String nameSpaceURI = ns.getURI();
            for (int i = 0; i < BOGUS_NAMESPACE_MAPPING.length; i += 2) {
                if (!nameSpaceURI.equalsIgnoreCase(BOGUS_NAMESPACE_MAPPING[i])) continue;
                Namespace newNamespace = Namespace.getNamespace(BOGUS_NAMESPACE_MAPPING[i + 1]);
                IMSDocumentHandler.replaceNamespaces(element, ns, newNamespace);
                System.out.println("Corrected namespace: " + ns.getURI() + " ----> " + newNamespace.getURI());
                return newNamespace;
            }
        }
        return ns;
    }

    public static void correctAdditionalNamespaces(Document doc) {
        Element element = doc.getRootElement();
        Vector<Namespace> v = new Vector<Namespace>();
        Iterator it = element.getAdditionalNamespaces().listIterator();
        while (it.hasNext()) {
            Namespace ns = (Namespace)it.next();
            v.add(ns);
        }
        for (Namespace ns : v) {
            IMSDocumentHandler.correctAdditionalNamespace(doc, ns);
        }
    }

    public static Namespace correctAdditionalNamespace(Document doc, Namespace ns) {
        if (doc != null && ns != null) {
            Element element = doc.getRootElement();
            String nameSpaceURI = ns.getURI();
            for (int i = 0; i < BOGUS_NAMESPACE_MAPPING.length; i += 2) {
                if (!nameSpaceURI.equalsIgnoreCase(BOGUS_NAMESPACE_MAPPING[i])) continue;
                Namespace newNamespace = Namespace.getNamespace(ns.getPrefix(), BOGUS_NAMESPACE_MAPPING[i + 1]);
                element.removeNamespaceDeclaration(ns);
                element.addNamespaceDeclaration(newNamespace);
                IMSDocumentHandler.replaceNamespaces(element, ns, newNamespace);
                System.out.println("Corrected namespace: " + ns.getURI() + " ----> " + newNamespace.getURI());
                return newNamespace;
            }
        }
        return ns;
    }

    public static void replaceNamespaces(Element element, Namespace oldNamespace, Namespace newNamespace) {
        if (element.getNamespace().getURI().equalsIgnoreCase(oldNamespace.getURI())) {
            element.setNamespace(newNamespace);
        }
        for (Element child : element.getChildren()) {
            IMSDocumentHandler.replaceNamespaces(child, oldNamespace, newNamespace);
        }
    }

    public static void correctLomElement(Element element) {
        if (element != null) {
            if (element.getName().equals("record")) {
                element.setName("lom");
                System.out.println("Corrected \"record\" ---> \"lom\" element");
            }
            for (Element child : element.getChildren()) {
                IMSDocumentHandler.correctLomElement(child);
            }
        }
    }

    public static String getSchemaLocation(Document doc, Namespace ns) {
        String namespaceURI;
        if (doc.hasRootElement() && ns != null && (namespaceURI = ns.getURI()) != null) {
            int index;
            Element root = doc.getRootElement();
            String str = root.getAttributeValue(XSI_SchemaLocation, XSI_Namespace);
            if (str == null) {
                str = root.getAttributeValue(XSI_SchemaLocation, XSI_NamespaceOLD);
            }
            if (str != null && (index = str.indexOf(namespaceURI)) != -1) {
                str = str.substring(index + namespaceURI.length());
                StringTokenizer t = new StringTokenizer(str, " ");
                try {
                    return t.nextToken();
                }
                catch (NoSuchElementException ex) {
                    return null;
                }
            }
        }
        return null;
    }

    public static Namespace getDocumentNamespace(Document doc) {
        Namespace ns = null;
        if (doc.hasRootElement()) {
            ns = doc.getRootElement().getNamespace();
        }
        return ns;
    }

    public static Namespace getDocumentNamespace(Document doc, String prefix) {
        Namespace ns = null;
        if (doc.hasRootElement()) {
            ns = doc.getRootElement().getNamespace(prefix);
        }
        return ns;
    }

    public static boolean isAcceptedMetadataNamespaceURI(String nameSpaceURI) {
        for (int i = 0; i < MD_NAMESPACE_URIS.length; ++i) {
            if (!nameSpaceURI.equals(MD_NAMESPACE_URIS[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean containsManifest(File zipFile) throws DweezilZipException {
        String manifestFile = ZipUtils.extractZipEntry(zipFile, MANIFEST_NAME);
        return manifestFile != null;
    }
}

