/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.dom;

import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.Element;

public class DomPath {
    public static String XMLPATHSEPARATOR = "/";
    public static String XMLATTSEPARATOR = "@";
    private String path;

    public DomPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String appendElementName(String elementName) {
        this.path = this.path + XMLPATHSEPARATOR + elementName;
        return this.path;
    }

    public String prependElementName(String elementName) {
        this.path = elementName + XMLPATHSEPARATOR + this.path;
        return this.path;
    }

    public String appendAttributeName(String attributeName) {
        this.path = this.path + XMLATTSEPARATOR + attributeName;
        return this.path;
    }

    public StringTokenizer getElements() {
        return new StringTokenizer(this.path, XMLPATHSEPARATOR);
    }

    public boolean isAttribute() {
        return this.path.indexOf(XMLATTSEPARATOR) != -1;
    }

    public String getAttributePart() {
        int index = this.path.indexOf(XMLATTSEPARATOR);
        if (index != -1) {
            return this.path.substring(index + 1);
        }
        return null;
    }

    public String getElementsPart() {
        int index = this.path.indexOf(XMLATTSEPARATOR);
        if (index != -1) {
            return this.path.substring(0, index);
        }
        return this.path;
    }

    public String getRootPart() {
        int index = this.path.indexOf(XMLPATHSEPARATOR);
        if (index != -1) {
            return this.path.substring(0, index);
        }
        return this.path;
    }

    public boolean equals(DomPath domPath) {
        return this.path.equals(domPath.getPath());
    }

    public boolean endsWith(DomPath domPath) {
        return this.path.endsWith(domPath.getPath());
    }

    public String toString() {
        return this.path;
    }

    public static DomPath getDomPath(Element element) {
        Element parent;
        String s = element.getName();
        while ((parent = element.getParentElement()) != null) {
            if (!parent.getNamespace().equals(element.getNamespace())) {
                s = element.getNamespacePrefix() + ":" + s;
            }
            s = parent.getName() + XMLPATHSEPARATOR + s;
            element = parent;
        }
        DomPath domPath = new DomPath(s);
        return domPath;
    }

    public static DomPath getDomPath(Attribute attribute) {
        DomPath domPath = DomPath.getDomPath(attribute.getParent());
        domPath.appendAttributeName(attribute.getQualifiedName());
        return domPath;
    }
}

