/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.dom;

import java.io.File;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.util.DweezilXMLException;
import uk.ac.reload.dweezil.util.XMLUtils;
import uk.ac.reload.moonunit.dom.ReloadDomException;

public abstract class ReloadDocument {
    protected Document _doc;
    protected boolean _dirty;
    protected File _file;

    public ReloadDocument() {
    }

    public ReloadDocument(File file, Document doc) {
        this._file = file;
        this._doc = doc;
    }

    public Document getDocument() {
        return this._doc;
    }

    public File getFile() {
        return this._file;
    }

    public void loadDocument(File file) throws DweezilXMLException {
        this._file = file;
        this._doc = XMLUtils.readXMLFile(file);
        this._dirty = false;
    }

    public void saveDocument() throws ReloadDomException {
        if (this._doc != null) {
            try {
                XMLUtils.write2XMLFile(this._doc, this._file);
            }
            catch (DweezilXMLException ex) {
                throw new ReloadDomException(ex);
            }
            this._dirty = false;
        }
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean isDirty) {
        this._dirty = isDirty;
    }

    public void saveAsDocument(File file) throws ReloadDomException {
        this._file = file;
        this.saveDocument();
    }

    public Element getRootElement() {
        if (this._doc != null && this._doc.hasRootElement()) {
            return this._doc.getRootElement();
        }
        return null;
    }

    public Namespace getSchemaNamespace() {
        Element root = this.getRootElement();
        if (root != null) {
            return root.getNamespace();
        }
        return null;
    }

    public boolean isDocumentNamespace(Element element) {
        Namespace ns = element.getNamespace();
        if (ns == null) {
            return false;
        }
        return ns == this.getSchemaNamespace();
    }

    public static boolean isMemberOfSameDocument(Element element1, Element element2) {
        Document doc1 = element1.getDocument();
        Document doc2 = element2.getDocument();
        if (doc1 == null || doc2 == null) {
            return false;
        }
        return doc1.equals(doc2);
    }
}

