/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.dom;

import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.undo.UndoHandler;
import uk.ac.reload.dweezil.undo.UndoableAction;
import uk.ac.reload.editor.contentpackaging.SCORM1_3Package;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.dom.DomPath;
import uk.ac.reload.moonunit.dom.ReloadDocument;
import uk.ac.reload.moonunit.dom.ReloadDocumentListener;
import uk.ac.reload.moonunit.dom.ReloadDocumentListenerEvent;
import uk.ac.reload.moonunit.dom.ReloadDomException;
import uk.ac.reload.moonunit.schema.ReloadSchema;
import uk.ac.reload.moonunit.schema.ReloadSchemaAttribute;
import uk.ac.reload.moonunit.schema.ReloadSchemaController;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;
import uk.ac.reload.moonunit.schema.ReloadVocabularyList;

public abstract class ReloadSchemaDocument
extends ReloadDocument {
    protected ReloadSchemaController _controller;
    protected UndoHandler _undoHandler;
    protected boolean rollupConditionAdded;
    private Vector _listeners = new Vector();

    public ReloadSchemaDocument() {
        this.rollupConditionAdded = false;
    }

    public ReloadSchemaDocument(File file, Document doc, ReloadSchemaController schemaController) {
        this._file = file;
        this._doc = doc;
        this._controller = schemaController;
        this.rollupConditionAdded = false;
    }

    public void setReloadSchemaController(ReloadSchemaController controller) {
        this._controller = controller;
    }

    public ReloadSchemaController getReloadSchemaController() {
        return this._controller;
    }

    @Override
    public void saveDocument() throws ReloadDomException {
        if (this._doc != null) {
            super.saveDocument();
            this.fireDocumentSaved();
        }
    }

    public abstract String getTargetRootElementName();

    public abstract String[] getComments();

    @Override
    public Namespace getSchemaNamespace() {
        Namespace ns = super.getSchemaNamespace();
        if (ns != null) {
            return ns;
        }
        return this.getTargetNamespace();
    }

    public Namespace getTargetNamespace() {
        ReloadSchema reloadSchema = this._controller.getReloadSchema();
        return Namespace.getNamespace(reloadSchema.getTargetNamespace());
    }

    public Element getElement(ReloadSchemaElement schemaElement) {
        return this.getElement(schemaElement.getDomPath());
    }

    public Element getElement(DomPath domPath) {
        Element element = this._doc.getRootElement();
        String rootName = domPath.getRootPart();
        StringTokenizer t = domPath.getElements();
        while (t.hasMoreElements()) {
            Namespace ns;
            String name = t.nextToken();
            if (name.equals(rootName)) continue;
            int idx = name.indexOf(58);
            if (idx >= 0) {
                String prefix = name.substring(0, idx);
                name = name.substring(idx + 1);
                ns = element.getNamespace(prefix);
            } else {
                ns = element.getNamespace();
            }
            if ((element = element.getChild(name, ns)) != null) continue;
            break;
        }
        return element;
    }

    protected void addComments(Document doc) {
        String[] comments = this.getComments();
        if (comments != null) {
            for (int i = 0; i < comments.length; ++i) {
                Comment comment = new Comment(comments[i]);
                doc.addContent(comment);
            }
        }
    }

    public void destroy() {
        this._listeners.clear();
        this._doc = null;
    }

    public Element addElementUnique(Object source, ReloadSchemaElement newSchemaElement, boolean doSelect) {
        if (newSchemaElement == null) {
            return null;
        }
        Element element = this._doc.getRootElement();
        ReloadSchemaElement schemaElement = newSchemaElement.getReloadSchema().getRootElement();
        DomPath domPath = newSchemaElement.getDomPath();
        String rootName = domPath.getRootPart();
        StringTokenizer t = domPath.getElements();
        while (t.hasMoreElements()) {
            Namespace ns;
            String name = t.nextToken();
            if (name.equals(rootName)) continue;
            int idx = name.indexOf(58);
            if (idx >= 0) {
                String prefix = name.substring(0, idx);
                name = name.substring(idx + 1);
                ns = element.getNamespace(prefix);
                if (ns == null && prefix.equals(IMSDocumentHandler.HEALTHCARE_LOM_NAMESPACE_PREFIX)) {
                    ns = Namespace.getNamespace(prefix, IMSDocumentHandler.HEALTHCARE_LOM_NAMESPACE_URI_10);
                }
            } else {
                ns = element.getNamespace();
            }
            schemaElement = schemaElement.getChild(name, ns);
            if (schemaElement == null) break;
            Element childElement = element.getChild(name, ns);
            if (childElement == null) {
                childElement = this.addElementBySchemaUndoable(source, element, schemaElement, doSelect);
            }
            element = childElement;
        }
        return element;
    }

    public Element addElementBySchemaUndoable(Object source, Element parentElement, ReloadSchemaElement newSchemaElement, boolean doSelect) {
        Element newElement = this.addElementBySchema(source, parentElement, newSchemaElement, doSelect);
        if (this._undoHandler != null && newElement != null) {
            UndoableAddAction addAction = new UndoableAddAction(parentElement, newElement);
            this._undoHandler.addUndoableAction(addAction);
        }
        return newElement;
    }

    public Element addElementBySchema(Object source, Element parentElement, ReloadSchemaElement newSchemaElement, boolean doSelect) {
        int i;
        String nsSchemaPrefix;
        boolean fourthEdition = false;
        if (this instanceof SCORM1_3Package && ((SCORM1_3Package)this).isFourthEdition()) {
            fourthEdition = true;
        }
        if (newSchemaElement == null) {
            return null;
        }
        Namespace ns = parentElement == null ? this.getSchemaNamespace() : ((nsSchemaPrefix = newSchemaElement.getNamespacePrefix()).equals("") ? parentElement.getNamespace() : newSchemaElement.getNamespace());
        Element newElement = new Element(newSchemaElement.getName(), ns);
        String defaultValue = this._controller.getDefaultValue(newSchemaElement);
        if (defaultValue != null) {
            newElement.setText(defaultValue);
        }
        if (newSchemaElement.hasAttributes()) {
            ReloadSchemaAttribute[] atts = newSchemaElement.getAttributes();
            for (i = 0; i < atts.length; ++i) {
                defaultValue = this._controller.getDefaultValue(atts[i]);
                String required = atts[i].getUse();
                String attName = atts[i].getName();
                if (defaultValue != null) {
                    Attribute att = atts[i].createAttribute();
                    att.setValue(defaultValue);
                    newElement.setAttribute(att);
                    continue;
                }
                if (attName.equals("identifier") || attName.equalsIgnoreCase("scormtype") || attName.equalsIgnoreCase("href") || required == null || parentElement == null || required.indexOf("required") < 0) continue;
                String v = this.getSpecialAttributeValue(parentElement, newSchemaElement, attName);
                if (v != null && v.length() > 0) {
                    Attribute att = atts[i].createAttribute();
                    att.setValue(v);
                    newElement.setAttribute(att);
                    continue;
                }
                this.removeElement(source, newElement);
                return null;
            }
        }
        if (parentElement != null) {
            int index = ReloadSchemaDocument.getInsertPositionOfElement(parentElement, newSchemaElement);
            this.addElementAtIndex(source, parentElement, newElement, index, doSelect);
        }
        ReloadSchemaElement[] schemaChildren = newSchemaElement.getChildren();
        for (i = 0; i < schemaChildren.length; ++i) {
            Element e;
            Element e2;
            ReloadSchemaElement child = schemaChildren[i];
            String name = child.getName();
            if (name.equals("schemaversion") && newElement.getName().equals("metadata") && parentElement.getName().equals("manifest")) {
                Element schemaversion = new Element(child.getName(), ns);
                e2 = this.addElementBySchema(source, newElement, child, doSelect);
                e2.setText(fourthEdition ? "2004 4th Edition" : "2004 3rd Edition");
                this.changedElement(this, e2);
                if (e2 == null) {
                    this.removeElement(source, newElement);
                    return null;
                }
            }
            if (name.equals("schema") && newElement.getName().equals("metadata") && parentElement.getName().equals("manifest")) {
                Element schema = new Element(child.getName(), ns);
                schema.setText("ADL SCORM");
                e2 = this.addElementBySchema(source, newElement, child, doSelect);
                if (e2 == null) {
                    this.removeElement(source, newElement);
                    return null;
                }
            }
            if (child.getMinOccurs() != 1 || newSchemaElement.getName().equals(IMSDocumentHandler.LOM_NAMESPACE_PREFIX) || source.toString().indexOf("Metadata") >= 0 || (e = this.addElementBySchema(source, newElement, child, doSelect)) != null) continue;
            this.removeElement(source, newElement);
            return null;
        }
        return newElement;
    }

    public Element addSSElementBySchema(Object source, Element parentElement, ReloadSchemaElement newSchemaElement) {
        int i;
        String nsSchemaPrefix;
        if (newSchemaElement == null) {
            return null;
        }
        Namespace ns = parentElement == null ? this.getSchemaNamespace() : ((nsSchemaPrefix = newSchemaElement.getNamespacePrefix()).equals("") ? parentElement.getNamespace() : newSchemaElement.getNamespace());
        Element newElement = new Element(newSchemaElement.getName(), ns);
        String defaultValue = this._controller.getDefaultValue(newSchemaElement);
        if (defaultValue != null) {
            newElement.setText(defaultValue);
        }
        if (newSchemaElement.hasAttributes()) {
            ReloadSchemaAttribute[] atts = newSchemaElement.getAttributes();
            for (i = 0; i < atts.length; ++i) {
                defaultValue = this._controller.getDefaultValue(atts[i]);
                String required = atts[i].getUse();
                String attName = atts[i].getName();
                if (attName.equals("identifier") || attName.equalsIgnoreCase("scormtype") || attName.equalsIgnoreCase("href") || required == null || parentElement == null || required.indexOf("required") < 0) continue;
                String v = this.getSpecialAttributeValue(parentElement, newSchemaElement, attName);
                if (v != null && v.length() > 0) {
                    Attribute att = atts[i].createAttribute();
                    att.setValue(v);
                    newElement.setAttribute(att);
                    continue;
                }
                this.removeElement(source, newElement);
                return null;
            }
        }
        if (parentElement != null) {
            int index = ReloadSchemaDocument.getInsertPositionOfElement(parentElement, newSchemaElement);
            this.addElementAtIndex(source, parentElement, newElement, index, false);
        }
        ReloadSchemaElement[] schemaChildren = newSchemaElement.getChildren();
        for (i = 0; i < schemaChildren.length; ++i) {
            Element e;
            ReloadSchemaElement child = schemaChildren[i];
            if (child.getMinOccurs() != 1 || (e = this.addElementBySchema(source, newElement, child, false)) != null) continue;
            this.removeElement(source, newElement);
            return null;
        }
        return newElement;
    }

    public String getSpecialAttributeValue(Element parentElement, ReloadSchemaElement newSchemaElement, String att) {
        String nsSchemaPrefix;
        String value = null;
        Namespace ns = parentElement == null ? this.getSchemaNamespace() : ((nsSchemaPrefix = newSchemaElement.getNamespacePrefix()).equals("") ? parentElement.getNamespace() : newSchemaElement.getNamespace());
        ReloadSchemaAttribute attribute = null;
        if (newSchemaElement.hasAttribute(att) && !newSchemaElement.hasAttribute("scormType")) {
            attribute = newSchemaElement.getAttribute(att, ns);
        }
        if (attribute != null) {
            String elementName;
            ReloadVocabularyList vl = attribute.getVocabularyList();
            Object[] list = null;
            if (vl != null) {
                list = vl.getList();
            }
            if ((elementName = newSchemaElement.getName()).equalsIgnoreCase("rollupCondition") || elementName.equalsIgnoreCase("rollupAction")) {
                elementName = "rollupRule";
            } else if (elementName.equalsIgnoreCase("ruleCondition") || elementName.equalsIgnoreCase("ruleAction")) {
                elementName = "rollupRule";
            }
            if (list != null) {
                Object object = JOptionPane.showInputDialog(null, "Please select a value for '" + attribute.getName() + "'.\n Otherwise '" + elementName + "' will not be added.\n", "Input", 1, null, list, list[0]);
                if (object == null) {
                    return null;
                }
                value = object.toString();
            } else {
                String object = JOptionPane.showInputDialog(null, "Please select a value for '" + attribute.getName() + "'.\n Otherwise '" + elementName + "' will not be added.\n", "Input", 1);
                if (object == null) {
                    return null;
                }
                value = object.toString();
                value.trim();
            }
        }
        return value;
    }

    public Element addElementUndoable(Object source, Element parentElement, Element childElement, boolean doSelect) {
        Element newElement = this.addElement(source, parentElement, childElement, doSelect);
        if (this._undoHandler != null && newElement != null) {
            UndoableAddAction addAction = new UndoableAddAction(parentElement, newElement);
            this._undoHandler.addUndoableAction(addAction);
        }
        return newElement;
    }

    public Element addElement(Object source, Element parentElement, Element childElement, boolean doSelect) {
        DomPath domPath = DomPath.getDomPath(parentElement);
        domPath.appendElementName(childElement.getName());
        ReloadSchemaElement schemaElement = (ReloadSchemaElement)this._controller.getReloadSchemaNode(domPath);
        int index = ReloadSchemaDocument.getInsertPositionOfElement(parentElement, schemaElement);
        return this.addElementAtIndex(source, parentElement, childElement, index, doSelect);
    }

    public synchronized Element addElementAtIndex(Object source, Element parentElement, Element newElement, int index, boolean doSelect) {
        List children = parentElement.getChildren();
        if (index < 0 || index > children.size()) {
            index = 0;
        }
        children.add(index, newElement);
        ReloadDocumentListenerEvent event = new ReloadDocumentListenerEvent(source, this, newElement, doSelect);
        this._dirty = true;
        this.fireElementAdded(event);
        return newElement;
    }

    public synchronized Element deleteElementUndoable(Object source, Element element) {
        Element parent = element.getParentElement();
        if (parent != null) {
            UndoableDeleteAction action = null;
            if (this._undoHandler != null) {
                action = new UndoableDeleteAction(parent, element);
            }
            this.removeElement(source, element);
            if (this._undoHandler != null && action != null) {
                this._undoHandler.addUndoableAction(action);
            }
        }
        return element;
    }

    public synchronized Element cutElementUndoable(Object source, Element element) {
        Element parent = element.getParentElement();
        if (parent != null) {
            UndoableCutAction action = null;
            if (this._undoHandler != null) {
                action = new UndoableCutAction(parent, element);
            }
            this.removeElement(source, element);
            if (this._undoHandler != null && action != null) {
                this._undoHandler.addUndoableAction(action);
            }
        }
        return element;
    }

    public synchronized Element removeElement(Object source, Element element) {
        Element parent = element.getParentElement();
        if (parent != null) {
            parent.removeContent(element);
            ReloadDocumentListenerEvent event = new ReloadDocumentListenerEvent(source, this, element, false);
            this._dirty = true;
            this.fireElementRemoved(event);
        }
        return element;
    }

    public Element moveElementUndoable(Object source, Element element, Element newParent, boolean doSelect) {
        Element oldParent = element.getParentElement();
        if (oldParent != null) {
            UndoableMoveAction action = null;
            if (this._undoHandler != null) {
                action = new UndoableMoveAction(oldParent, newParent, element);
            }
            this.removeElement(source, element);
            this.addElement(this, newParent, element, doSelect);
            if (this._undoHandler != null && action != null) {
                this._undoHandler.addUndoableAction(action);
            }
        }
        return element;
    }

    public Element copyElementUndoable(Object source, Element element, Element newParent, boolean doSelect) {
        Element newElement = (Element)element.clone();
        this.addElement(this, newParent, newElement, doSelect);
        if (this._undoHandler != null) {
            UndoableCopyAction action = new UndoableCopyAction(newParent, newElement);
            this._undoHandler.addUndoableAction(action);
        }
        return newElement;
    }

    public Element pasteElementUndoable(Object source, Element element, Element newParent, boolean doSelect) {
        Element newElement = (Element)element.clone();
        this.addElement(this, newParent, newElement, doSelect);
        if (this._undoHandler != null) {
            UndoablePasteAction action = new UndoablePasteAction(newParent, newElement);
            this._undoHandler.addUndoableAction(action);
        }
        return newElement;
    }

    public Element moveElementUp(Object source, Element element, boolean doSelect) {
        int index;
        List children;
        Element parent = element.getParentElement();
        if (parent != null && (children = parent.getChildren()).size() > 1 && (index = children.indexOf(element)) > 0) {
            this.removeElement(source, element);
            this.addElementAtIndex(source, parent, element, index - 1, doSelect);
        }
        return element;
    }

    public Element moveElementDown(Object source, Element element, boolean doSelect) {
        int index;
        List children;
        Element parent = element.getParentElement();
        if (parent != null && (children = parent.getChildren()).size() > 1 && (index = children.indexOf(element)) < children.size() - 1) {
            this.removeElement(source, element);
            this.addElementAtIndex(source, parent, element, index + 1, doSelect);
        }
        return element;
    }

    public void changedElement(Object source, Element element) {
        ReloadDocumentListenerEvent event = new ReloadDocumentListenerEvent(source, this, element, false);
        this._dirty = true;
        this.fireElementChanged(event);
    }

    public boolean canAddElement(Element parentElement, ReloadSchemaElement childSchemaElement) {
        if (childSchemaElement == null) {
            return true;
        }
        int max = childSchemaElement.getMaxOccurs();
        if (max == -1) {
            return true;
        }
        List list = parentElement.getChildren(childSchemaElement.getName(), childSchemaElement.getNamespace());
        return list.size() < max;
    }

    public boolean isAllowedChild(Element parentElement, Element childElement) {
        DomPath domPath = DomPath.getDomPath(parentElement);
        ReloadSchemaElement parentSchemaElement = (ReloadSchemaElement)this.getReloadSchemaController().getReloadSchemaNode(domPath);
        if (parentSchemaElement != null) {
            ReloadSchemaElement childSchemaElement = parentSchemaElement.getChild(childElement.getName(), childElement.getNamespace());
            if (childSchemaElement == null) {
                return false;
            }
            return this.canAddElement(parentElement, childSchemaElement);
        }
        return false;
    }

    public boolean canDeleteElement(Element element, ReloadSchemaElement schemaElement) {
        if (schemaElement == null) {
            return true;
        }
        Element parentElement = element.getParentElement();
        if (parentElement == null) {
            return false;
        }
        List list = parentElement.getChildren(schemaElement.getName(), schemaElement.getNamespace());
        return list.size() > schemaElement.getMinOccurs();
    }

    public boolean canCopyElement(Element element) {
        return false;
    }

    public boolean canCutElement(Element element, ReloadSchemaElement schemaElement) {
        return false;
    }

    public boolean canPasteFromClipboard(Element element) {
        return false;
    }

    public boolean canMoveElementUp(Element element) {
        Element previousSibling;
        int index;
        List children;
        Element parent = element.getParentElement();
        return parent != null && (children = parent.getChildren()).size() > 1 && (index = children.indexOf(element)) > 0 && (previousSibling = (Element)children.get(index - 1)).getName().equals(element.getName()) && previousSibling.getNamespace().equals(element.getNamespace());
    }

    public boolean canMoveElementDown(Element element) {
        Element nextSibling;
        int index;
        List children;
        Element parent = element.getParentElement();
        return parent != null && (children = parent.getChildren()).size() > 1 && (index = children.indexOf(element)) < children.size() - 1 && (nextSibling = (Element)children.get(index + 1)).getName().equals(element.getName()) && nextSibling.getNamespace().equals(element.getNamespace());
    }

    public Attribute addAttribute(Object source, Element parentElement, ReloadSchemaAttribute newSchemaAttribute) {
        if (parentElement == null || newSchemaAttribute == null) {
            return null;
        }
        Attribute att = newSchemaAttribute.createAttribute();
        if (att != null) {
            List list = parentElement.getAttributes();
            int index = ReloadSchemaDocument.getInsertPositionOfAttribute(parentElement, newSchemaAttribute);
            if (index < 0 || index > list.size()) {
                index = 0;
            }
            list.add(index, att);
        }
        return att;
    }

    public static int getIndexOfElement(Element element) {
        List children;
        int index = 0;
        Element parent = element.getParentElement();
        if (parent != null && (index = (children = parent.getChildren()).indexOf(element)) == -1) {
            index = 0;
        }
        return index;
    }

    public static int getInsertPositionOfElement(Element parentElement, ReloadSchemaElement newSchemaElement) {
        if (newSchemaElement == null) {
            return parentElement.getChildren().size();
        }
        if (parentElement.getChildren().size() == 0) {
            return 0;
        }
        int index = 0;
        String name = newSchemaElement.getName();
        ReloadSchemaElement parentSchemaElement = (ReloadSchemaElement)newSchemaElement.getParent();
        if (parentSchemaElement == null) {
            parentSchemaElement = newSchemaElement;
        }
        ReloadSchemaElement[] schemaChildren = parentSchemaElement.getChildren();
        List children = parentElement.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element element = (Element)children.get(i);
            String elementName = element.getName();
            int pos = parentSchemaElement.indexofChild(elementName);
            if (pos == -1) continue;
            for (int j = pos; j < schemaChildren.length; ++j) {
                if (!name.equals(schemaChildren[j].getName())) continue;
                index = i + 1;
            }
        }
        return index;
    }

    public static int getInsertPositionOfAttribute(Element parentElement, ReloadSchemaAttribute reloadSchemaAttribute) {
        int index = 0;
        List elementAtts = parentElement.getAttributes();
        if (elementAtts.size() == 0) {
            return 0;
        }
        String name = reloadSchemaAttribute.getName();
        ReloadSchemaElement parentSchemaElement = (ReloadSchemaElement)reloadSchemaAttribute.getParent();
        ReloadSchemaAttribute[] schemaAtts = parentSchemaElement.getAttributes();
        for (int i = 0; i < elementAtts.size(); ++i) {
            Attribute att = (Attribute)elementAtts.get(i);
            String attName = att.getName();
            int pos = parentSchemaElement.indexofAttribute(attName);
            if (pos != -1) {
                for (int j = pos; j < schemaAtts.length; ++j) {
                    if (!name.equals(schemaAtts[j].getName())) continue;
                    index = i + 1;
                }
                continue;
            }
            index = i + 1;
        }
        return index;
    }

    public synchronized void addReloadDocumentListener(ReloadDocumentListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.addElement(listener);
        }
    }

    public synchronized void removeReloadDocumentListener(ReloadDocumentListener listener) {
        this._listeners.removeElement(listener);
    }

    public void fireElementAdded(ReloadDocumentListenerEvent event) {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            ReloadDocumentListener listener = (ReloadDocumentListener)this._listeners.elementAt(i);
            listener.elementAdded(event);
        }
    }

    public void fireElementRemoved(ReloadDocumentListenerEvent event) {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            ReloadDocumentListener listener = (ReloadDocumentListener)this._listeners.elementAt(i);
            listener.elementRemoved(event);
        }
    }

    public void fireElementChanged(ReloadDocumentListenerEvent event) {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            ReloadDocumentListener listener = (ReloadDocumentListener)this._listeners.elementAt(i);
            listener.elementChanged(event);
        }
    }

    public void fireDocumentSaved() {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            ReloadDocumentListener listener = (ReloadDocumentListener)this._listeners.elementAt(i);
            listener.documentSaved(this);
        }
    }

    public void setUndoHandler(UndoHandler undoHandler) {
        this._undoHandler = undoHandler;
    }

    public UndoHandler getUndoHandler() {
        return this._undoHandler;
    }

    protected class UndoableMoveAction
    implements UndoableAction {
        Element oldParent;
        Element newParent;
        Element element;
        int oldIndex;
        int newIndex;
        String name;

        public UndoableMoveAction(Element oldParent, Element newParent, Element element) {
            this.oldParent = oldParent;
            this.newParent = newParent;
            this.element = element;
            this.oldIndex = ReloadSchemaDocument.getIndexOfElement(element);
            this.name = ReloadSchemaDocument.this._controller.getElementFriendlyName(DomPath.getDomPath(element));
            if (this.name == null) {
                this.name = element.getName();
            }
        }

        @Override
        public void undo() {
            this.newIndex = ReloadSchemaDocument.getIndexOfElement(this.element);
            ReloadSchemaDocument.this.removeElement(null, this.element);
            ReloadSchemaDocument.this.addElementAtIndex(null, this.oldParent, this.element, this.oldIndex, true);
        }

        @Override
        public void redo() {
            this.oldIndex = ReloadSchemaDocument.getIndexOfElement(this.element);
            ReloadSchemaDocument.this.removeElement(null, this.element);
            ReloadSchemaDocument.this.addElementAtIndex(null, this.newParent, this.element, this.newIndex, true);
        }

        @Override
        public String getName() {
            return "Move " + this.name;
        }
    }

    protected class UndoablePasteAction
    extends UndoableAddAction {
        public UndoablePasteAction(Element parent, Element element) {
            super(parent, element);
        }

        @Override
        public String getName() {
            return "Paste " + this.name;
        }
    }

    protected class UndoableCopyAction
    extends UndoableAddAction {
        public UndoableCopyAction(Element parent, Element element) {
            super(parent, element);
        }

        @Override
        public String getName() {
            return "Copy " + this.name;
        }
    }

    protected class UndoableAddAction
    implements UndoableAction {
        Element parent;
        Element element;
        int index;
        String name;

        public UndoableAddAction(Element parent, Element element) {
            this.parent = parent;
            this.element = element;
            this.index = ReloadSchemaDocument.getIndexOfElement(element);
            this.name = ReloadSchemaDocument.this._controller.getElementFriendlyName(DomPath.getDomPath(element));
            if (this.name == null) {
                this.name = element.getName();
            }
        }

        @Override
        public void undo() {
            this.index = ReloadSchemaDocument.getIndexOfElement(this.element);
            ReloadSchemaDocument.this.removeElement(null, this.element);
        }

        @Override
        public void redo() {
            ReloadSchemaDocument.this.addElementAtIndex(null, this.parent, this.element, this.index, true);
        }

        @Override
        public String getName() {
            return "Add " + this.name;
        }
    }

    protected class UndoableCutAction
    extends UndoableDeleteAction {
        public UndoableCutAction(Element parent, Element element) {
            super(parent, element);
        }

        @Override
        public String getName() {
            return "Cut " + this.name;
        }
    }

    protected class UndoableDeleteAction
    implements UndoableAction {
        Element parent;
        Element element;
        int index;
        String name;

        public UndoableDeleteAction(Element parent, Element element) {
            this.parent = parent;
            this.element = element;
            this.index = ReloadSchemaDocument.getIndexOfElement(element);
            this.name = ReloadSchemaDocument.this._controller.getElementFriendlyName(DomPath.getDomPath(element));
            if (this.name == null) {
                this.name = element.getName();
            }
        }

        @Override
        public void undo() {
            ReloadSchemaDocument.this.addElementAtIndex(null, this.parent, this.element, this.index, true);
        }

        @Override
        public void redo() {
            this.index = ReloadSchemaDocument.getIndexOfElement(this.element);
            ReloadSchemaDocument.this.removeElement(null, this.element);
        }

        @Override
        public String getName() {
            return "Delete " + this.name;
        }
    }
}

