/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.dom.contentpackaging;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.dom.ReloadDocument;

public class ContentPackageCore {
    public static final String MANIFEST = "manifest";
    public static final String ORGANIZATIONS = "organizations";
    public static final String RESOURCES = "resources";
    public static final String CONTENT = "content";
    public static final String DEFAULT = "default";
    public static final String ORGANIZATION = "organization";
    public static final String ITEM = "item";
    public static final String PARAMETERS = "parameters";
    public static final String RESOURCE = "resource";
    public static final String BASE = "base";
    public static final String FILE = "file";
    public static final String TYPE = "type";
    public static final String HREF = "href";
    public static final String METADATA = "metadata";
    public static final String IDENTIFIER = "identifier";
    public static final String IDENTIFIERREF = "identifierref";
    public static final String TITLE = "title";
    public static final String DEPENDENCY = "dependency";
    public static final String VERSION = "version";
    public static final String SCHEMA = "schema";
    public static final String SCHEMAVERSION = "schemaversion";
    public static final String SEQUENCING = "sequencing";
    public static final String PRESENTATION = "presentation";
    protected ReloadDocument _doc;

    public ContentPackageCore(ReloadDocument doc) {
        this._doc = doc;
    }

    public File getProjectFolder() {
        File file = this._doc.getFile();
        return file == null ? null : file.getParentFile();
    }

    public Element getReferencedElement(Element sourceElement) {
        Element manifest;
        String idref = sourceElement.getAttributeValue(IDENTIFIERREF);
        if (idref != null && (manifest = this.getParentManifestElement(sourceElement)) != null) {
            Element[] resources = this.getElementsInManifest(manifest, RESOURCE, this._doc.getSchemaNamespace());
            for (int i = 0; i < resources.length; ++i) {
                String id = resources[i].getAttributeValue(IDENTIFIER);
                if (id == null || !idref.equals(id)) continue;
                return resources[i];
            }
            Element[] submanifests = this.getElementsInManifest(manifest, MANIFEST, this._doc.getSchemaNamespace());
            for (int i = 0; i < submanifests.length; ++i) {
                String id = submanifests[i].getAttributeValue(IDENTIFIER);
                if (id == null || !idref.equals(id)) continue;
                return submanifests[i];
            }
        }
        return null;
    }

    public boolean isReferencingElement(Element element) {
        String idref = element.getAttributeValue(IDENTIFIERREF);
        return idref != null && !idref.equals("");
    }

    public String[] getReferencedIdentifersAllowed(Element element) {
        Vector<String> v = new Vector<String>();
        Element[] elements = this.getReferencedElementsAllowed(element);
        for (int i = 0; i < elements.length; ++i) {
            String id = elements[i].getAttributeValue(IDENTIFIER);
            if (id == null || id.equals("")) continue;
            v.add(id);
        }
        Object[] ids = new String[v.size()];
        v.copyInto(ids);
        return ids;
    }

    public Element[] getReferencedElementsAllowed(Element element) {
        Vector<Element> v = new Vector<Element>();
        Element manifest = this.getParentManifestElement(element);
        if (manifest != null) {
            String elementName = element.getName();
            Element[] resources = this.getElementsInManifest(manifest, RESOURCE, this._doc.getSchemaNamespace());
            for (int i = 0; i < resources.length; ++i) {
                String id = resources[i].getAttributeValue(IDENTIFIER);
                if (id == null || id.equals("")) continue;
                v.add(resources[i]);
            }
            if (elementName.equals(ITEM)) {
                Element[] submanifests = this.getElementsInManifest(manifest, MANIFEST, this._doc.getSchemaNamespace());
                for (int i = 0; i < submanifests.length; ++i) {
                    String id = submanifests[i].getAttributeValue(IDENTIFIER);
                    if (id == null || id.equals("")) continue;
                    v.add(submanifests[i]);
                }
            }
        }
        Object[] elements = new Element[v.size()];
        v.copyInto(elements);
        return elements;
    }

    public Element[] getElementsInManifest(Element manifestElement, String elementName, Namespace ns) {
        Vector v = new Vector();
        this._getElementsInManifest(manifestElement, v, elementName, ns);
        Object[] elements = new Element[v.size()];
        v.copyInto(elements);
        return elements;
    }

    protected void _getElementsInManifest(Element parent, Vector v, String elementName, Namespace ns) {
        for (Element child : parent.getChildren()) {
            if (child.getName().equals(elementName) && child.getNamespace().equals(ns)) {
                v.add(child);
            }
            this._getElementsInManifest(child, v, elementName, ns);
        }
    }

    public Element getParentManifestElement(Element element) {
        while (!element.getName().equals(MANIFEST)) {
            if ((element = element.getParentElement()) != null) continue;
            return null;
        }
        return element;
    }

    public Element getElementByIdentifier(Element parent, String identifier) {
        for (Element child : parent.getChildren()) {
            String id;
            if (!this._doc.isDocumentNamespace(child) || (id = child.getAttributeValue(IDENTIFIER)) == null || !id.equals(identifier)) continue;
            return child;
        }
        return null;
    }

    public Element[] getOrganizations(Element orgsElement) {
        Vector<Element> v = new Vector<Element>();
        for (Element orgElement : orgsElement.getChildren(ORGANIZATION, orgsElement.getNamespace())) {
            v.add(orgElement);
        }
        Object[] orgs = new Element[v.size()];
        v.copyInto(orgs);
        return orgs;
    }

    public Element[] getOrganizationsAllowed(Element orgsElement) {
        Vector<Element> v = new Vector<Element>();
        Element[] orgs = this.getOrganizations(orgsElement);
        for (int i = 0; i < orgs.length; ++i) {
            String id = orgs[i].getAttributeValue(IDENTIFIER);
            if (id == null || id.equals("")) continue;
            v.add(orgs[i]);
        }
        Object[] new_orgs = new Element[v.size()];
        v.copyInto(new_orgs);
        return new_orgs;
    }

    public Element getDefaultOrganization(Element orgsElement) {
        Element element = null;
        if (orgsElement != null && orgsElement.getName().equals(ORGANIZATIONS)) {
            String defOrg = orgsElement.getAttributeValue(DEFAULT);
            if (defOrg != null) {
                element = this.getElementByIdentifier(orgsElement, defOrg);
            }
            if (element == null) {
                element = orgsElement.getChild(ORGANIZATION, orgsElement.getNamespace());
            }
        }
        return element;
    }

    public Namespace getMetadataNamespace() {
        Namespace ns_ims = null;
        Namespace ns_lom = null;
        Element root = this._doc.getRootElement();
        if (root != null) {
            ns_ims = root.getNamespace(IMSDocumentHandler.IMSMD_NAMESPACE_PREFIX);
            ns_lom = root.getNamespace(IMSDocumentHandler.LOM_NAMESPACE_PREFIX);
            if (ns_ims == null && ns_lom == null) {
                for (Namespace nsTemp : root.getAdditionalNamespaces()) {
                    String nsURI = nsTemp.getURI();
                    if (!IMSDocumentHandler.isAcceptedMetadataNamespaceURI(nsURI)) continue;
                    return nsTemp;
                }
            }
        }
        if (ns_lom == null) {
            return ns_ims;
        }
        return ns_lom;
    }

    public boolean isMetadataRoot(String name) {
        return name.equals("lom");
    }

    public boolean isMetadataElement(String name) {
        return name.equals(METADATA);
    }

    public String getURL(Element element) {
        String href = this.getElementHREF(element);
        if (href != null) {
            String params = this.getParameters(element);
            try {
                File file = new File(this.getProjectFolder(), href);
                if (file.exists()) {
                    href = ReloadUtils.getLocalFileURL(file);
                    if (params != null) {
                        href = href + params;
                    }
                    return href;
                }
                URL url = new URL(href + (params == null ? "" : params));
                return url.toString();
            }
            catch (MalformedURLException ex) {
                try {
                    URL url = new URL("http://" + href + (params == null ? "" : params));
                    return url.toString();
                }
                catch (MalformedURLException ex1) {
                    return null;
                }
            }
        }
        return null;
    }

    public String getElementHREF(Element element) {
        String base;
        String name = element.getName();
        if ((name.equals(ITEM) || name.equals(DEPENDENCY)) && (element = this.getReferencedElement(element)) == null) {
            return null;
        }
        String href = element.getAttributeValue(HREF);
        if (href != null && (base = this.getElementBase(element)) != null) {
            href = base + href;
        }
        return href;
    }

    public String getElementBase(Element element) {
        String totalBase = "";
        do {
            String base;
            if ((base = element.getAttributeValue(BASE, Namespace.XML_NAMESPACE)) == null) continue;
            totalBase = base + totalBase;
            if (base.startsWith("/") || base.startsWith("http:")) break;
        } while ((element = element.getParentElement()) != null);
        return totalBase.equals("") ? null : totalBase;
    }

    public String getParameters(Element element) {
        char c;
        String params = element.getAttributeValue(PARAMETERS);
        if (params != null && !params.equals("") && (c = params.charAt(0)) != '?' && c != '#') {
            params = "?" + params;
        }
        return params;
    }

    public File getResourceFile(Element element) {
        File file;
        String href = this.getElementHREF(element);
        if (href != null && (file = new File(this.getProjectFolder(), href)).exists()) {
            return file;
        }
        return null;
    }

    public File[] getResourceFiles(Element manifestElement) {
        Vector v = new Vector();
        this._getResourceFiles(manifestElement, v);
        Object[] files = new File[v.size()];
        v.copyInto(files);
        return files;
    }

    protected void _getResourceFiles(Element manifestElement, Vector v) {
        Element submanifestElement;
        Element resourcesElement = manifestElement.getChild(RESOURCES, manifestElement.getNamespace());
        if (resourcesElement != null) {
            for (Element resourceElement : resourcesElement.getChildren(RESOURCE, resourcesElement.getNamespace())) {
                File file = this.getResourceFile(resourceElement);
                if (file != null && !v.contains(file)) {
                    v.add(file);
                }
                for (Element fileElement : resourceElement.getChildren(FILE, resourceElement.getNamespace())) {
                    File file2 = this.getResourceFile(fileElement);
                    if (file2 == null || v.contains(file2)) continue;
                    v.add(file2);
                }
            }
        }
        if ((submanifestElement = manifestElement.getChild(MANIFEST, manifestElement.getNamespace())) != null) {
            this._getResourceFiles(submanifestElement, v);
        }
    }

    public Element getResource(String href, Element resourcesElement) {
        for (Element resource : resourcesElement.getChildren(RESOURCE, resourcesElement.getNamespace())) {
            String tmp = resource.getAttributeValue(HREF);
            if (tmp == null || !tmp.equalsIgnoreCase(href)) continue;
            return resource;
        }
        return null;
    }

    public Element getResourcesElement(Element element) {
        if (element.getName().equals(RESOURCES)) {
            return element;
        }
        Element manifest = this.getParentManifestElement(element);
        return manifest == null ? null : manifest.getChild(RESOURCES, element.getNamespace());
    }
}

