/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.SchemaReader;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;
import uk.ac.reload.moonunit.schema.ReloadSchemaException;

public class ReloadSchema {
    protected Schema _castorSchema;
    private ReloadSchemaElement _root;
    private String _rootName;
    private static Hashtable _reloadSchemaTable = new Hashtable();

    public static ReloadSchema getReloadSchema(File fileSpec, String rootName) throws ReloadSchemaException {
        ReloadSchema reloadSchema = (ReloadSchema)_reloadSchemaTable.get(fileSpec);
        if (reloadSchema == null) {
            reloadSchema = new ReloadSchema(fileSpec, rootName);
            _reloadSchemaTable.put(fileSpec, reloadSchema);
        }
        return reloadSchema;
    }

    private ReloadSchema(File schemaFile, String rootName) throws ReloadSchemaException {
        try {
            this._castorSchema = this.loadCastorSchema(schemaFile);
        }
        catch (IOException ex) {
            throw new ReloadSchemaException(ex);
        }
        this._rootName = rootName;
        ElementDecl rootElementDecl = this._castorSchema.getElementDecl(this._rootName);
        this._root = new ReloadSchemaElement(rootElementDecl);
        this._root.setReloadSchema(this);
    }

    public ReloadSchemaElement getRootElement() {
        return this._root;
    }

    public String getRootElementName() {
        return this._rootName;
    }

    public String getTargetNamespace() {
        return this._castorSchema.getTargetNamespace();
    }

    public String getSchemaNamespace() {
        return this._castorSchema.getSchemaNamespace();
    }

    public String getSchemaLocation() {
        return this._castorSchema.getSchemaLocation();
    }

    public String getSchemaLocation(String namespaceURI) {
        Schema schema = this._castorSchema.getImportedSchema(namespaceURI);
        return schema == null ? null : schema.getSchemaLocation();
    }

    public String getSchemaName() {
        String path = this.getSchemaLocation();
        return new File(path).getName();
    }

    public String getSchemaName(String namespaceURI) {
        String path = this.getSchemaLocation(namespaceURI);
        return path == null ? null : new File(path).getName();
    }

    public String getNamespaceURI(String prefix) {
        return this._castorSchema.getNamespace(prefix);
    }

    protected Schema getCastorSchema() {
        return this._castorSchema;
    }

    protected Schema loadCastorSchema(File schemaFile) throws IOException {
        String url = schemaFile.toURL().toString();
        SchemaReader reader = new SchemaReader(url);
        return reader.read();
    }
}

