/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.jdom.Attribute;
import org.jdom.Namespace;
import uk.ac.reload.moonunit.dom.DomPath;
import uk.ac.reload.moonunit.schema.ReloadSchemaNode;
import uk.ac.reload.moonunit.schema.ReloadVocabularyList;

public class ReloadSchemaAttribute
extends ReloadSchemaNode {
    protected AttributeDecl _attDecl;

    public ReloadSchemaAttribute(AttributeDecl attDecl) {
        this._attDecl = attDecl;
    }

    @Override
    public String getName() {
        return this._attDecl.getName();
    }

    public String getUse() {
        return this._attDecl.getUse();
    }

    @Override
    public String getDefaultValue() {
        return this._attDecl.getDefaultValue();
    }

    @Override
    public String getNamespacePrefix() {
        int idx;
        String refname = this._attDecl.getReferenceName();
        if (refname != null && (idx = refname.indexOf(58)) >= 0) {
            String prefix = refname.substring(0, idx);
            if (prefix.equals("x")) {
                prefix = "xml";
            }
            return prefix;
        }
        return "";
    }

    @Override
    public Namespace getNamespace() {
        String nsPrefix = this.getNamespacePrefix();
        if (nsPrefix.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        String namespaceURI = this._attDecl.getSchema().getNamespace(nsPrefix);
        return Namespace.getNamespace(nsPrefix, namespaceURI);
    }

    @Override
    public ReloadVocabularyList getVocabularyList() {
        ReloadVocabularyList rvList = null;
        SimpleType simpleType = this._attDecl.getSimpleType();
        if (simpleType != null) {
            int type = simpleType.getTypeCode();
            switch (type) {
                case 11: {
                    rvList = new ReloadVocabularyList(this.getDomPath(), ReloadVocabularyList.TRUEFALSE_LISTNAME);
                    break;
                }
                default: {
                    Vector<String> v = null;
                    Enumeration e = simpleType.getFacets("enumeration");
                    while (e.hasMoreElements()) {
                        if (v == null) {
                            v = new Vector<String>();
                        }
                        Facet facet = (Facet)e.nextElement();
                        v.addElement(facet.getValue());
                    }
                    if (v == null) break;
                    Object[] s = new String[v.size()];
                    v.copyInto(s);
                    rvList = new ReloadVocabularyList(this.getDomPath(), ReloadVocabularyList.INTERNAL_LISTNAME);
                    rvList.setList((String[])s);
                }
            }
        }
        return rvList;
    }

    @Override
    public String getTypeName() {
        SimpleType simpleType = this._attDecl.getSimpleType();
        return simpleType == null ? "Not known" : simpleType.getName();
    }

    public Long getMaxLength() {
        Long def = new Long(0L);
        SimpleType simpleType = this._attDecl.getSimpleType();
        Long l = simpleType.getMaxLength();
        if (simpleType != null) {
            return l == null ? def : l;
        }
        return def;
    }

    public Long getMinLength() {
        Long def = new Long(0L);
        SimpleType simpleType = this._attDecl.getSimpleType();
        Long l = simpleType.getMinLength();
        if (simpleType != null) {
            return l == null ? def : l;
        }
        return def;
    }

    @Override
    public String getBaseTypeName() {
        SimpleType simpleType = this._attDecl.getSimpleType();
        if (simpleType != null) {
            XMLType baseType = simpleType.getBaseType();
            return baseType == null ? simpleType.getName() : baseType.getName();
        }
        return "Unknown BaseType";
    }

    public String getAtomicBaseTypeName() {
        String name = null;
        SimpleType simpleType = this._attDecl.getSimpleType();
        if (simpleType != null) {
            for (XMLType baseType = simpleType.getBaseType(); baseType != null; baseType = baseType.getBaseType()) {
                name = baseType.getName();
            }
            return name == null ? simpleType.getName() : name;
        }
        return "Unknown BaseType";
    }

    @Override
    public String getFacetValue(String facetName) {
        Facet facet;
        String val = null;
        SimpleType simpleType = this._attDecl.getSimpleType();
        if (simpleType != null && (facet = simpleType.getFacet(facetName)) != null) {
            val = facet.getValue();
        }
        return val;
    }

    public Attribute createAttribute() {
        Attribute att = null;
        String name = this.getName();
        if (this.isExternalNamespace()) {
            Namespace ns = this.getNamespace();
            att = new Attribute(name, "", ns);
        } else {
            att = new Attribute(name, "");
        }
        return att;
    }

    @Override
    public DomPath getDomPath() {
        DomPath domPath = this.getParent().getDomPath();
        Attribute att = this.createAttribute();
        domPath.appendAttributeName(att.getQualifiedName());
        return domPath;
    }
}

