/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.io.File;
import java.util.StringTokenizer;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.dom.DomPath;
import uk.ac.reload.moonunit.schema.ReloadSchema;
import uk.ac.reload.moonunit.schema.ReloadSchemaAttribute;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;
import uk.ac.reload.moonunit.schema.ReloadSchemaException;
import uk.ac.reload.moonunit.schema.ReloadSchemaHelper;
import uk.ac.reload.moonunit.schema.ReloadSchemaNode;
import uk.ac.reload.moonunit.schema.ReloadVocabulary;
import uk.ac.reload.moonunit.schema.ReloadVocabularyList;

public abstract class ReloadSchemaController {
    protected ReloadSchema _reloadSchema;
    protected File _schemaFile;
    protected ReloadSchemaHelper _schemaHelper;
    protected ReloadVocabulary _vocab;

    public ReloadSchemaController() {
    }

    public ReloadSchemaController(File fileSchema, File fileHelper, File fileVocab) throws ReloadSchemaException {
        this.loadSchema(fileSchema);
        this.loadSchemaHelper(fileHelper);
        this.loadVocab(fileVocab);
    }

    public void loadSchema(File schemaFile) throws ReloadSchemaException {
        this._schemaFile = schemaFile;
        this._reloadSchema = ReloadSchema.getReloadSchema(schemaFile, this.getRootElementName());
    }

    public void loadSchemaHelper(File fileHelper) throws ReloadSchemaException {
        this._schemaHelper = ReloadSchemaHelper.getReloadSchemaHelper(fileHelper);
    }

    public void loadVocab(File fileVocab) throws ReloadSchemaException {
        this._vocab = ReloadVocabulary.getReloadVocabulary(fileVocab);
    }

    public void setDefaultVocabLanguage(String lang) {
        if (this._vocab != null) {
            this._vocab.setDefaultLanguage("en");
        }
    }

    public ReloadSchemaNode getReloadSchemaNode(DomPath domPath) {
        ReloadSchemaAttribute schemaAttribute;
        String attName = null;
        if (domPath.isAttribute()) {
            attName = domPath.getAttributePart();
            domPath = new DomPath(domPath.getElementsPart());
        }
        ReloadSchemaElement schemaElement = this._reloadSchema.getRootElement();
        StringTokenizer t = domPath.getElements();
        while (t.hasMoreElements()) {
            String name = t.nextToken();
            if (name.equals(this._reloadSchema.getRootElementName())) continue;
            if (name.contains(":")) {
                String[] items = name.split(":");
                try {
                    String nameSpaceURI = items[0].equals(IMSDocumentHandler.HEALTHCARE_LOM_ADDRESS_NAMESPACE_PREFIX) ? IMSDocumentHandler.HEALTHCARE_LOM_ADDRESS_NAMESPACE_URI_10 : this._reloadSchema.getNamespaceURI(items[0]);
                    schemaElement = schemaElement.getChild(items[1], Namespace.getNamespace(items[0], nameSpaceURI));
                }
                catch (IllegalNameException ex) {}
            } else {
                schemaElement = schemaElement.getChild(name);
            }
            if (schemaElement != null) continue;
            break;
        }
        if (attName != null && (schemaAttribute = schemaElement.getAttribute(attName)) != null) {
            return schemaAttribute;
        }
        return schemaElement;
    }

    public String getElementHelperValue(DomPath domPath, String helperKey) {
        return this._schemaHelper == null ? null : this._schemaHelper.getHelperValue(domPath, helperKey);
    }

    public String getElementFriendlyName(DomPath domPath) {
        return this.getElementHelperValue(domPath, "fname");
    }

    public String getElementTip(DomPath domPath) {
        return this.getElementHelperValue(domPath, "tip");
    }

    public String getWidgetType(DomPath domPath) {
        return this.getElementHelperValue(domPath, "widget");
    }

    public abstract String getRootElementName();

    public ReloadVocabularyList getVocabularyList(ReloadSchemaNode schemaNode) {
        if (schemaNode == null) {
            return null;
        }
        ReloadVocabularyList rvList = null;
        if (this._vocab != null) {
            rvList = this._vocab.getVocabularyList(schemaNode);
        }
        if (rvList == null) {
            rvList = schemaNode.getVocabularyList();
        }
        return rvList;
    }

    public String getDefaultValue(ReloadSchemaNode schemaNode) {
        String def = null;
        ReloadVocabularyList rvList = this.getVocabularyList(schemaNode);
        if (rvList != null) {
            def = rvList.getDefaultValue();
        }
        if (def == null) {
            def = schemaNode.getDefaultValue();
        }
        return def;
    }

    public String getFacetValue(ReloadSchemaNode schemaNode, String facetName) {
        String value = this.getElementHelperValue(schemaNode.getDomPath(), facetName);
        if (value == null) {
            value = schemaNode.getFacetValue(facetName);
        }
        return value;
    }

    public ReloadSchema getReloadSchema() {
        return this._reloadSchema;
    }

    public File getSchemaFile() {
        return this._schemaFile;
    }

    public ReloadSchemaHelper getSchemaHelper() {
        return this._schemaHelper;
    }
}

