/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.jdom.Namespace;
import uk.ac.reload.moonunit.dom.DomPath;
import uk.ac.reload.moonunit.schema.ReloadSchema;
import uk.ac.reload.moonunit.schema.ReloadSchemaAttribute;
import uk.ac.reload.moonunit.schema.ReloadSchemaNode;
import uk.ac.reload.moonunit.schema.ReloadVocabularyList;

public class ReloadSchemaElement
extends ReloadSchemaNode {
    protected ElementDecl _elementDecl;
    protected Vector _children;
    protected Vector _attributes;

    public ReloadSchemaElement(ElementDecl elementDecl) {
        this._elementDecl = elementDecl;
        this._attributes = new Vector();
        this.addAttributes();
    }

    protected void addAttributes() {
        XMLType xmlType = this.getXMLType();
        if (xmlType instanceof ComplexType) {
            Enumeration e = ((ComplexType)xmlType).getAttributeDecls();
            while (e.hasMoreElements()) {
                AttributeDecl attDecl = (AttributeDecl)e.nextElement();
                ReloadSchemaAttribute att = new ReloadSchemaAttribute(attDecl);
                att.setParent(this);
                this._attributes.add(att);
            }
        }
    }

    public ReloadSchemaElement setReloadSchema(ReloadSchema reloadSchema) {
        this._parent = reloadSchema;
        return this;
    }

    @Override
    public String getName() {
        return this._elementDecl.getName();
    }

    @Override
    public String getNamespacePrefix() {
        int idx;
        String refname = this._elementDecl.getReferenceName();
        if (refname != null && (idx = refname.indexOf(58)) >= 0) {
            String prefix = refname.substring(0, idx);
            return prefix;
        }
        return "";
    }

    @Override
    public Namespace getNamespace() {
        String nsPrefix = this.getNamespacePrefix();
        String nsURI = this._elementDecl.getSchema().getNamespace(nsPrefix);
        return Namespace.getNamespace(nsPrefix, nsURI);
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public DomPath getDomPath() {
        if (this._parent instanceof ReloadSchemaElement) {
            ReloadSchemaElement parent = (ReloadSchemaElement)this._parent;
            DomPath domPath = parent.getDomPath();
            String name = this.getName();
            if (this.isExternalNamespace()) {
                name = this.getNamespacePrefix() + ":" + name;
            } else if (domPath.getPath().contains("hx")) {
                name = "hx:" + name;
            }
            domPath.appendElementName(name);
            return domPath;
        }
        return new DomPath(this.getName());
    }

    @Override
    public ReloadVocabularyList getVocabularyList() {
        ReloadVocabularyList rvList = null;
        XMLType xmlType = this.getXMLType();
        if (xmlType.isSimpleType()) {
            SimpleType simpleType = (SimpleType)xmlType;
            int type = simpleType.getTypeCode();
            switch (type) {
                case 11: {
                    rvList = new ReloadVocabularyList(this.getDomPath(), ReloadVocabularyList.TRUEFALSE_LISTNAME);
                    break;
                }
                default: {
                    Vector<String> v = null;
                    Enumeration e = simpleType.getFacets("enumeration");
                    while (e.hasMoreElements()) {
                        if (v == null) {
                            v = new Vector<String>();
                        }
                        Facet facet = (Facet)e.nextElement();
                        v.addElement(facet.getValue());
                    }
                    if (v == null) break;
                    Object[] s = new String[v.size()];
                    v.copyInto(s);
                    rvList = new ReloadVocabularyList(this.getDomPath(), ReloadVocabularyList.INTERNAL_LISTNAME);
                    rvList.setList((String[])s);
                }
            }
        }
        return rvList;
    }

    @Override
    public String getTypeName() {
        return this.getXMLType().getName();
    }

    @Override
    public String getBaseTypeName() {
        XMLType xmlType = this.getXMLType();
        XMLType baseType = xmlType.getBaseType();
        return baseType == null ? xmlType.getName() : baseType.getName();
    }

    public String getAtomicBaseTypeName() {
        String name = null;
        XMLType xmlType = this.getXMLType();
        if (xmlType != null) {
            for (XMLType baseType = xmlType.getBaseType(); baseType != null; baseType = baseType.getBaseType()) {
                name = baseType.getName();
            }
            return name == null ? xmlType.getName() : name;
        }
        return "Unknown BaseType";
    }

    public boolean isValue() {
        String baseTypeName = this.getAtomicBaseTypeName();
        if (baseTypeName == null) {
            return false;
        }
        return baseTypeName.equals("string") || baseTypeName.equals("int") || baseTypeName.equals("integer") || baseTypeName.equals("decimal");
    }

    public boolean isStringType() {
        String baseTypeName = this.getAtomicBaseTypeName();
        return baseTypeName != null && baseTypeName.equals("string");
    }

    public int getMinOccurs() {
        return this._elementDecl.getMinOccurs();
    }

    public int getMaxOccurs() {
        return this._elementDecl.getMaxOccurs();
    }

    @Override
    public String getDefaultValue() {
        return this._elementDecl.getDefaultValue();
    }

    protected XMLType getXMLType() {
        return this._elementDecl.getType();
    }

    public boolean isComplexType() {
        return this.getXMLType().isComplexType();
    }

    @Override
    public String getFacetValue(String facetName) {
        SimpleType simpleType;
        Facet facet;
        String val = null;
        XMLType xmlType = this.getXMLType();
        if (xmlType.isSimpleType() && (facet = (simpleType = (SimpleType)xmlType).getFacet(facetName)) != null) {
            val = facet.getValue();
        }
        return val;
    }

    public ReloadSchemaAttribute[] getAttributes() {
        Object[] atts = new ReloadSchemaAttribute[this._attributes.size()];
        this._attributes.copyInto(atts);
        return atts;
    }

    public ReloadSchemaAttribute getAttribute(String attName) {
        Namespace ns;
        int idx = attName.indexOf(58);
        if (idx >= 0) {
            String prefix = attName.substring(0, idx);
            attName = attName.substring(idx + 1);
            String nsURI = this._elementDecl.getSchema().getNamespace(prefix);
            ns = Namespace.getNamespace(prefix, nsURI);
        } else {
            ns = this.getNamespace();
        }
        return this.getAttribute(attName, ns);
    }

    public ReloadSchemaAttribute getAttribute(String attName, Namespace ns) {
        for (int i = 0; i < this._attributes.size(); ++i) {
            ReloadSchemaAttribute att = (ReloadSchemaAttribute)this._attributes.get(i);
            if (!att.getName().equals(attName) || !att.getNamespace().equals(ns)) continue;
            return att;
        }
        return null;
    }

    public ReloadSchemaAttribute getAttributeAtIndex(int index) {
        if (index >= this._attributes.size()) {
            return null;
        }
        return (ReloadSchemaAttribute)this._attributes.elementAt(index);
    }

    public boolean hasAttributes() {
        return !this._attributes.isEmpty();
    }

    public boolean hasAttribute(String attName) {
        if (this.hasAttributes()) {
            return this.indexofAttribute(attName) != -1;
        }
        return false;
    }

    public int indexofAttribute(ReloadSchemaAttribute att) {
        if (att == null) {
            return -1;
        }
        return this.indexofAttribute(att.getName());
    }

    public int indexofAttribute(String attName) {
        if (attName == null) {
            return -1;
        }
        for (int i = 0; i < this._attributes.size(); ++i) {
            ReloadSchemaAttribute att = (ReloadSchemaAttribute)this._attributes.get(i);
            if (!att.getName().equals(attName)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.getName();
    }

    public ReloadSchemaElement[] getChildren() {
        Vector v = this.buildChildren();
        Object[] elements = new ReloadSchemaElement[v.size()];
        v.copyInto(elements);
        return elements;
    }

    public ReloadSchemaElement[] getChildren(Namespace ns) {
        Vector<ReloadSchemaElement> v = new Vector<ReloadSchemaElement>();
        ReloadSchemaElement[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getNamespace() != ns) continue;
            v.add(children[i]);
        }
        Object[] elements = new ReloadSchemaElement[v.size()];
        v.copyInto(elements);
        return elements;
    }

    public int getChildCount() {
        Vector v = this.buildChildren();
        return v.size();
    }

    public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    public boolean hasChild(String childName) {
        return this.getChild(childName) != null;
    }

    public ReloadSchemaElement getChild(String childName) {
        Namespace ns;
        int idx = childName.indexOf(58);
        if (idx >= 0) {
            String prefix = childName.substring(0, idx);
            childName = childName.substring(idx + 1);
            String nsURI = this._elementDecl.getSchema().getNamespace(prefix);
            ns = Namespace.getNamespace(prefix, nsURI);
        } else {
            ns = this.getNamespace();
        }
        return this.getChild(childName, ns);
    }

    public ReloadSchemaElement getChild(String childName, Namespace ns) {
        for (ReloadSchemaElement child : this.buildChildren()) {
            if (!child.getName().equals(childName) || !child.getNamespace().equals(ns)) continue;
            return child;
        }
        return null;
    }

    public ReloadSchemaElement getChildAt(int index) {
        if (index >= this.getChildCount() || index < 0) {
            return null;
        }
        return (ReloadSchemaElement)this.buildChildren().get(index);
    }

    public int indexofChild(ReloadSchemaElement child) {
        if (child == null) {
            return -1;
        }
        return this.buildChildren().indexOf(child);
    }

    public int indexofChild(String childName) {
        if (childName == null) {
            return -1;
        }
        Vector v = this.buildChildren();
        for (int i = 0; i < v.size(); ++i) {
            ReloadSchemaElement element = (ReloadSchemaElement)v.elementAt(i);
            if (!element.getName().equals(childName)) continue;
            return i;
        }
        return -1;
    }

    public String[] getChildNames() {
        Vector v = this.buildChildren();
        String[] s = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            ReloadSchemaElement element = (ReloadSchemaElement)v.elementAt(i);
            s[i] = element.getName();
        }
        return s;
    }

    private Vector buildChildren() {
        if (this._children == null) {
            this._children = new Vector();
            XMLType xmlType = this.getXMLType();
            if (xmlType instanceof ComplexType) {
                ComplexType complexType = (ComplexType)xmlType;
                Enumeration cTypeBits = complexType.enumerate();
                block3: while (cTypeBits.hasMoreElements()) {
                    Structure structure = (Structure)cTypeBits.nextElement();
                    switch (structure.getStructureType()) {
                        case 10: {
                            this.buildChildGroup((Group)structure);
                            continue block3;
                        }
                    }
                    System.out.println("Other ComplexType Structure: " + structure.toString());
                }
            }
        }
        return this._children;
    }

    protected void buildChildGroup(Group group) {
        Enumeration groupMembers = group.enumerate();
        block6: while (groupMembers.hasMoreElements()) {
            Particle particle = (Particle)groupMembers.nextElement();
            switch (particle.getStructureType()) {
                case 8: {
                    this.addChildElementDecl((ElementDecl)particle);
                    continue block6;
                }
                case 16: {
                    continue block6;
                }
                case 10: {
                    continue block6;
                }
                case 24: {
                    continue block6;
                }
            }
            System.out.println("Group Particle: " + particle.toString());
        }
    }

    protected void addChildElementDecl(ElementDecl childElementDecl) {
        ReloadSchemaElement child = new ReloadSchemaElement(childElementDecl);
        child.setParent(this);
        this._children.add(child);
    }

    public boolean hasAncestor(ReloadSchemaElement schemaElement) {
        if (this._parent instanceof ReloadSchemaElement) {
            return ((ReloadSchemaElement)this._parent).getName().equals(schemaElement.getName()) ? true : ((ReloadSchemaElement)this._parent).hasAncestor(schemaElement);
        }
        return false;
    }
}

