/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.io.File;
import java.util.Hashtable;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilXMLException;
import uk.ac.reload.dweezil.util.XMLUtils;
import uk.ac.reload.moonunit.dom.DomPath;
import uk.ac.reload.moonunit.schema.ReloadSchemaException;

public class ReloadSchemaHelper {
    public static final String ELEMENT = "element";
    public static final String SCHEMA = "schema";
    public static final String PATH = "path";
    public static final String FNAME = "fname";
    public static final String TIP = "tip";
    public static final String WIDGET = "widget";
    public static final String MAXLENGTH = "maxLength";
    protected Document _docHelper;
    protected File _fileHelper;
    private static Hashtable _reloadSchemaHelperTable = new Hashtable();

    public static ReloadSchemaHelper getReloadSchemaHelper(File fileHelper) throws ReloadSchemaException {
        ReloadSchemaHelper reloadSchemaHelper = (ReloadSchemaHelper)_reloadSchemaHelperTable.get(fileHelper);
        if (reloadSchemaHelper == null) {
            reloadSchemaHelper = new ReloadSchemaHelper(fileHelper);
            _reloadSchemaHelperTable.put(fileHelper, reloadSchemaHelper);
        }
        return reloadSchemaHelper;
    }

    private ReloadSchemaHelper(File fileHelper) throws ReloadSchemaException {
        if (fileHelper == null) {
            throw new ReloadSchemaException("Helper file cannot be null");
        }
        this._fileHelper = fileHelper;
        try {
            this._docHelper = this.loadSchemaHelperFile(fileHelper);
        }
        catch (DweezilXMLException ex) {
            throw new ReloadSchemaException(ex);
        }
    }

    protected Document loadSchemaHelperFile(File helperFile) throws DweezilXMLException {
        return XMLUtils.readXMLFile(helperFile);
    }

    protected Document getSchemaHelperDocument() {
        return this._docHelper;
    }

    public String getSchemaName() {
        Element root = this._docHelper.getRootElement();
        Attribute att = root.getAttribute(SCHEMA);
        return att == null ? null : att.getValue();
    }

    public String getHelperValue(DomPath domPath, String helperKey) {
        if (this._docHelper != null && this._docHelper.hasRootElement()) {
            String path = domPath.getPath();
            Element root = this._docHelper.getRootElement();
            for (Element childElement : root.getChildren(ELEMENT)) {
                String name = childElement.getAttributeValue(PATH);
                if (name == null || !path.equals(name) && !path.endsWith(name)) continue;
                String value = childElement.getAttributeValue(helperKey);
                if (value == null) {
                    Element child = childElement.getChild(helperKey);
                    if (child == null) continue;
                    return child.getText().trim();
                }
                return value;
            }
        }
        return null;
    }

    public String getSSHelperValue(DomPath domPath, String helperKey) {
        if (this._docHelper != null && this._docHelper.hasRootElement()) {
            String path = domPath.getPath();
            Element root = this._docHelper.getRootElement();
            for (Element childElement : root.getChildren(ELEMENT)) {
                String name = childElement.getAttributeValue(PATH);
                if (name == null || !path.equals(name)) continue;
                String value = childElement.getAttributeValue(helperKey);
                if (value == null) {
                    Element child = childElement.getChild(helperKey);
                    if (child == null) continue;
                    return child.getText().trim();
                }
                return value;
            }
        }
        return null;
    }

    public List getAttributes(String elementName) {
        if (this._docHelper != null && this._docHelper.hasRootElement()) {
            Element root = this._docHelper.getRootElement();
            return this.recursivelyFindAttributes(elementName, root);
        }
        return null;
    }

    private List recursivelyFindAttributes(String elementName, Element ithElement) {
        for (Element childElement : ithElement.getChildren(ELEMENT)) {
            String childName = childElement.getName();
            if (childName.equalsIgnoreCase(elementName)) {
                return childElement.getAttributes();
            }
            this.recursivelyFindAttributes(elementName, childElement);
        }
        return null;
    }
}

