/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilXMLException;
import uk.ac.reload.dweezil.util.XMLUtils;
import uk.ac.reload.moonunit.dom.DomPath;
import uk.ac.reload.moonunit.schema.ReloadSchemaException;
import uk.ac.reload.moonunit.schema.ReloadSchemaNode;
import uk.ac.reload.moonunit.schema.ReloadVocabularyList;

public class ReloadVocabulary {
    private static Hashtable reloadVocabulariesTable = new Hashtable();
    protected Document _docVocab;
    protected File _fileVocab;
    protected Vector _lists;

    public static ReloadVocabulary getReloadVocabulary(File fileVocab) throws ReloadSchemaException {
        if (fileVocab == null) {
            return null;
        }
        ReloadVocabulary reloadVocabulary = (ReloadVocabulary)reloadVocabulariesTable.get(fileVocab);
        if (reloadVocabulary == null && fileVocab.exists()) {
            reloadVocabulary = new ReloadVocabulary(fileVocab);
            reloadVocabulariesTable.put(fileVocab, reloadVocabulary);
        }
        return reloadVocabulary;
    }

    private ReloadVocabulary(File fileVocab) throws ReloadSchemaException {
        if (fileVocab == null) {
            throw new ReloadSchemaException("Vocabulary file cannot be null");
        }
        this._fileVocab = fileVocab;
        try {
            this._docVocab = this.loadVocabularyFile(fileVocab);
        }
        catch (DweezilXMLException ex) {
            throw new ReloadSchemaException(ex);
        }
        this._lists = this.mapLists();
        String lang = this.getRootAttributeValue("lang");
        this.setDefaultLanguage(lang);
    }

    private Document loadVocabularyFile(File fileVocab) throws DweezilXMLException {
        return XMLUtils.readXMLFile(fileVocab);
    }

    public Document getVocabularyDocument() {
        return this._docVocab;
    }

    public String getVocabularyName() {
        return this._docVocab.getRootElement().getAttributeValue("name");
    }

    public ReloadVocabularyList getVocabularyList(ReloadSchemaNode schemaNode) {
        if (schemaNode == null) {
            return null;
        }
        DomPath nodePath = schemaNode.getDomPath();
        Enumeration lists = this._lists.elements();
        while (lists.hasMoreElements()) {
            ReloadVocabularyList rvList = (ReloadVocabularyList)lists.nextElement();
            DomPath listPath = rvList.getDomPath();
            if (!nodePath.equals(listPath) && !nodePath.endsWith(listPath)) continue;
            if (rvList.getListName().equals("none")) {
                return null;
            }
            return rvList;
        }
        return null;
    }

    public void setDefaultLanguage(String lang) {
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        Enumeration lists = this._lists.elements();
        while (lists.hasMoreElements()) {
            ReloadVocabularyList rvList = (ReloadVocabularyList)lists.nextElement();
            if (!rvList.isLangList()) continue;
            rvList.setDefaultValue(lang);
        }
    }

    private Vector mapLists() {
        Vector<ReloadVocabularyList> map = new Vector<ReloadVocabularyList>();
        block0: for (Element childElement : this._docVocab.getRootElement().getChildren("element")) {
            Element vocabElement;
            String vocabName;
            String listPath = childElement.getAttributeValue("path");
            String listName = childElement.getAttributeValue("list");
            if (listPath == null || listName == null) continue;
            ReloadVocabularyList reloadvocabList = new ReloadVocabularyList(new DomPath(listPath), listName);
            map.addElement(reloadvocabList);
            Iterator vocablist = this._docVocab.getRootElement().getChildren("vocabList").iterator();
            while (vocablist.hasNext() && (vocabName = (vocabElement = (Element)vocablist.next()).getAttributeValue("name")) != null) {
                if (!listName.equals(vocabName)) continue;
                List items = vocabElement.getChildren("item");
                String[] s = new String[items.size()];
                for (int i = 0; i < items.size(); ++i) {
                    Element e = (Element)items.get(i);
                    s[i] = e.getText();
                    Attribute att = e.getAttribute("default");
                    if (att == null) continue;
                    reloadvocabList.setDefaultValue(e.getText());
                }
                reloadvocabList.setList(s);
                continue block0;
            }
        }
        return map;
    }

    protected String getRootAttributeValue(String attName) {
        if (this._docVocab != null && this._docVocab.hasRootElement()) {
            Element root = this._docVocab.getRootElement();
            Attribute att = root.getAttribute(attName);
            return att == null ? null : att.getValue();
        }
        return null;
    }
}

