/*************************************************************************
**
** Filename:  About.js
**
** File Description:
**    Abstract versioning info for all Test Suite about pages.
**
** Author: ADLI Project
**
** Module/Package Name:  none
** Module/Package Description: none
**
** Design Issues:
**
** Implementation Issues:
** Known Problems:
** Side Effects:
**
** References: ADL SCORM
**
***************************************************************************
**
** The Advanced Distributed Learning Co-Laboratory (ADL Co-Lab) Hub grants you
** ("Licensee") a non- exclusive, royalty free, license to use and redistribute
** this software in source and binary code form, provided that i) this copyright
** notice and license appear on all copies of the software; and ii) Licensee does
** not utilize the software in a manner which is disparaging to ADL Co-Lab Hub. 
**
** This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS
** OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED
** WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-
** INFRINGEMENT, ARE HEREBY EXCLUDED. ADL Co-Lab Hub AND ITS LICENSORS SHALL NOT
** BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
** OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL ADL Co-Lab Hub
** OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED
** AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
** INABILITY TO USE SOFTWARE, EVEN IF ADL Co-Lab Hub HAS BEEN ADVISED OF THE
** POSSIBILITY OF SUCH DAMAGES. 
**
**************************************************************************/

//global variables
var isAuditorVersion = false;
var version = "Version 1.0.2";
var scormVersion = "2004 3rd Edition";
var certificationCode =
         "<center>" +
         "   <table border='1' cellspacing='3' width='550px'>" +
         "      <tr >" +
         "         <td id='tableColor'>" +
         "             <p>Certification Note: Successful outcome of this" +
         "               test does not constitute ADL Certification " +
         "               unless an ADL Certified Auditor conducted" +
         "               the test.</p>" +
         "         </td>" +
         "      </tr>" +
         "   </table>" +
         "</center>";



/*******************************************************************************
**
** Function: displayVersion()
** Inputs:  None
** Return:  None
**
** Description:
**    Write the version number to the html page.
**
*******************************************************************************/
function displayVersion()
{
   document.write( version );
}

/*******************************************************************************
**
** Function: displayScormVersion()
** Inputs:  None
** Return:  None
**
** Description:
**    Write the SCORM version number to the html page.
**
*******************************************************************************/
function displayScormVersion()
{
   document.write( scormVersion );
}

/*******************************************************************************
**
** Function: displayTestSuiteVersion()
** Inputs:  None
** Return:  None
**
** Description:
**    Write the test type (Auditor/Self Test) to the html page.
**
*******************************************************************************/
function displayTestSuiteVersion()
{
   if ( isAuditorVersion )
   {
      document.write(  version + " (Auditor Test)" );
   }
   else
   {
      document.write( version + " (Self Test)" );
   }
}


/*******************************************************************************
**
**Function: displayCertification()
**Inputs:  None
**Return:  NONE
**
**Description:
**   Write the certification note.
**
*******************************************************************************/
function displayCertification()
{
    document.write( certificationCode )
}

