/*************************************************************************
**
** Filename:  EmulationCode.js
**
** File Description:   This file provides emulation code to overload the IE specific
**                     procedures "insertAdjacentHTML()" and "scrollIntoView()"
**                     so that they can be used in Netscape 6.
**
**                     insertAdjacentHTML() procedure source code was based upon
**                     code found at:
**                     http://www.faqts.com/knowledge_base/view.phtml/aid/5756
**
**
** Browser Compatibility:
**    This file is now compatible with Netscape 6
**
** Author: ADLI Project
**
** Module/Package Name:  none
** Module/Package Description: none
**
** Design Issues:
**
** Implementation Issues:
** Known Problems:
** Side Effects:
**
** References: ADL SCORM
**
***************************************************************************
**
** The Advanced Distributed Learning Co-Laboratory (ADL Co-Lab) Hub grants you
** ("Licensee") a non- exclusive, royalty free, license to use and redistribute
** this software in source and binary code form, provided that i) this copyright
** notice and license appear on all copies of the software; and ii) Licensee does
** not utilize the software in a manner which is disparaging to ADL Co-Lab Hub. 
**
** This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS
** OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED
** WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-
** INFRINGEMENT, ARE HEREBY EXCLUDED. ADL Co-Lab Hub AND ITS LICENSORS SHALL NOT
** BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
** OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL ADL Co-Lab Hub
** OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED
** AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
** INABILITY TO USE SOFTWARE, EVEN IF ADL Co-Lab Hub HAS BEEN ADVISED OF THE
** POSSIBILITY OF SUCH DAMAGES. 
**
**************************************************************************/
//Checks if the browser needs the emulation code
if (document.childNodes&&!document.childNodes[0].insertAdjacentHTML)
{
   HTMLElement.prototype.insertAdjacentElement = function(where,parsedNode)
   {
      switch (where)
      {
         case 'beforeBegin':
            this.parentNode.insertBefore(parsedNode,this);
            break;
         case 'afterBegin':
            this.insertBefore(parsedNode,this.firstChild);
           break;
         case 'BeforeEnd':
           this.appendChild(parsedNode);
           break;
         case 'afterEnd':
        if (this.nextSibling)
         {
           this.parentNode.insertBefore
           (parsedNode,this.nextSibling);
        }
         else
         {
           this.parentNode.appendChild(parsedNode);
        }
        break;
      }
   }

   HTMLElement.prototype.insertAdjacentHTML = function(where,htmlStr)
   {
      var r = this.ownerDocument.createRange();
      r.setStartBefore(this);
      var parsedHTML = r.createContextualFragment(htmlStr);
      this.insertAdjacentElement(where,parsedHTML);
   }


   HTMLElement.prototype.insertAdjacentText = function(where,txtStr)
   {
      var parsedText = document.createTextNode(txtStr);
      this.insertAdjacentElement(where,parsedText);
   }

   HTMLElement.prototype.scrollIntoView = function()
   {
      var coords = {x: 0, y: 0};
      var el = this;
      do
      {
         coords.x += el.offsetLeft;
         coords.y += el.offsetTop;
      }
      while ((el = el.offsetParent));

      window.scrollTo (coords.x, coords.y);
   }

}
